/* libass/ass_GamePlayer.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

#define ASS_NODEFS
#include "ass.h"
#include "ass_err.h"

/*
 * Returns a player from the game passed it.  The player number is (1-4).
 */
player_t
ass_GamePlayer (
 	game_t game,  /* The game that this player is in */
 	int p         /* What number the player is (1-4) */
) {
 	/* Little error-checking...  Well...  It looks good, anyways...  :) */
 	if (
 	  ass_err (!game, "libass: ass_GamePlayer(): null game\n") ||
 	  ass_err (!(p >= 1 && p <= 4),
 	      "libass: ass_GamePlayer(): invalid player #\n")
 	  )
 		return 0;

 	return &(game->ppl[p-1]);
}
