/* libass/ass_GamePos.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

#include "ass.h"
#include "ass_err.h"

/*
 * This will return the # (1-4) of player who occupies the given position
 * in the game.  If a player of said position cannot be found, it
 * will return 0.  This is _not_ an error.
 */
int  /* (1-4) if position found, 0 otherwise */
ass_GamePos (
 	game_t game,  /* The game the player is in... */
 	position_t pos  /* And their position... */
) {
 	int i;

 	if (
 	  ass_err (!game, "libass: ass_GamePos(): bad game\n") ||
 	  ass_err (pos < ASS || pos > PREZ, "libass: ass_GamePos(): bad pos\n")
 	)
 		return 0;

 	for (i=0; i<4; i++) if (game->ppl[i].pos == pos) return i + 1;
 	return 0;
}
