/* libass/ass_HandCard.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

#define ASS_NODEFS
#include "ass.h"
#include "ass_err.h"

/*
 * This will return a card from a hand.
 */
card_t
ass_HandCard (
 	hand_t hand,  /* The hand from which you want a card */
 	int n         /* What card number for the hand (1-54) */
) {
 	if (
 	  ass_err (!hand, "libass: ass_HandCard(): passed null hand\n") ||
 	  ass_err (!(n >= 1 && n <= 54),
 	      "libass: ass_HandCard(): invalid card #\n")
 	  )
 		return 0;

 	return hand->cards[n - 1];
}
