/* libass/ass_a_clear.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

#include "ass.h"

/*
 * This function will be run automatically at the beginning of
 * ass_move(), but, if for some reason this isn't soon enough for you,
 * you can call it earlier.  It will remove the currently laid set if
 * and only if the next ass_move() will begin a new round.  You can also
 * clear the current set manually by fetching the currentset with
 * ass_GameDown() and using ass_makeset() on it.
 *
 * Returns TRUE if it cleared the set, FALSE otherwise.
 */
int  /* 1 == cleared set, 0 == didn't */
ass_a_clear (
 	game_t game  /* In what game? */
) {
 	/* Don't clear the set if it's already clear, eh? */
 	if (game->down.card == NAC) return 0;

 	if (ass_all (game)) {
 		/* Clear the set... */
 		game->down.card = NAC;
 		/* This isn't really altogether clean.  Should/Shouldn't
 		 * we set game->start and game->last here?  If we do,
 		 * things will break, so we dont, but... */
 		return 1;
 	} else {
 		return 0;
 	}
}
