/* libass/ass_a_shuffle.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

#include "ass.h"
#include <assert.h>

/*
 * This will switch everyone's position based on how quickly they
 * finished...  If there is no info on where each finished, then
 * they are left alone.
 */
void
ass_a_shuffle (
 	game_t game  /* In what game? */
) {
 	int a_f=0, b_f=0, c_f=0, d_f=0, e_f=0;
 	int i;

 	for (i=0; i<4; i++) {
 		switch (game->ppl[i].out) {
 		case 0:
 			e_f++;
 			break;
 		case 1:
 			a_f++;
 			game->ppl[i].pos = PREZ;
 			break;
 		case 2:
 			b_f++;
 			game->ppl[i].pos = VICE;
 			break;
 		case 3:
 			c_f++;
 			game->ppl[i].pos = VICEASS;
 			break;
 		case 4:
 			d_f++;
 			game->ppl[i].pos = ASS;
 			break;
 		default:
 			assert (0);  /* out shouldn't hold such numbers */
 		}
 	}

 	assert (e_f == 4 || (a_f == 1 && b_f == 1 && c_f == 1 && d_f == 1));
}
