/* libass/ass_all.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

#include "ass.h"
#include <assert.h>
#include "ass_err.h"

/*
 * This is a simple shortcut function which will return TRUE if all players
 * have had their turn during this round.
 *
 * May not be called before you have dealt.
 */
int
ass_all (
 	game_t game  /* in which game? */
) {
 	int i, x, k, silly_f=1;  /* junk */
 	int sanity;
 	position_t j;  /* junk */

 	/* If someone just dealt, then obviously no one has gone,
 	 * so therefore, obviously no one has had their turn... */
 	if (game->start == -1) return 0;
 	if (ass_err (game->start == -2, "libass: ass_all(): deal first\n"))
 		return 0;

 	j = game->ppl[game->cur].pos;
 	/* Advance j by one, and keep on doing so, skipping people without
 	 * cards, until we either reach someone with cards or reach 
 	 * the person who started. */
 	sanity = 0;
 	for (;;) {
 		assert (sanity++ < 5);
 		if (j == PREZ) j = ASS; else j++;
 		for (i=0; i<4; i++) if (game->ppl[i].pos == j) break;
 		if (i == 4) {
 			/* Everyone should be an ASS if we couldn't find
 			 * anyone with position j */
 			assert (j == VICEASS);
 			j = ASS;  /* So we fall into this code again */
 			if (silly_f) x = game->cur;
 			silly_f = 0;
 			if (x == 3) x = 0; else x++;
 		} else
 			x = i;
 		if (x == game->start) return 1;
 		for (k=0; k<54; k++)
 			if (game->ppl[x].hand.cards[k] != NAC) break;
 		if (k != 54) return 0;  /* This guy can go! */
 	}
}
