/* libass/ass_makeset.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

#define ASS_NODEFS
#include "ass.h"
#include "ass_err.h"

/*
 * Remember that you must only call this with things that are valid
 * sets...  Either one that you have malloc()'d yourself with
 * myset = malloc (sizeof (*myset)), or one that has been initialized
 * beforehand by libass. 
 * 
 * It will make it so that the set is composed of number of cards.
 */
void
ass_makeset (
 	set_t set,    /* The set to operate on */
 	card_t card,  /* What card to set the set to */
 	int num       /* How many of cards are in said set */
) {
 	ass_err (!set, "libass: ass_makeset(): null set\n");
 	ass_err (card>JOKER || card<NAC, "libass: ass_makeset(): bad card\n");
 	ass_err (num>4 || num<0, "libass: ass_makeset(): bad # of cards\n");

 	set->card = card;
 	set->num = num;
}
