/* libass/ass_move.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

#include "ass.h"
#include "ass_err.h"

/*
 * This is the function which does a player's turn.  It _MUST_ be called
 * for every player that is not out for every round.  It assumes that you
 * are keeping track of who is out, and who starts every round.  If you've
 * forgotten, you can use ass_turn() to figure it out, again...
 * 
 * You are to pass this function a set to lay.  If the move is invalid
 * (eg. the player whose turn it is does not have the cards to lay that
 * hand, or it isn't higher in value than the previous set), the function
 * returns TRUE, otherwise it will return FALSE.
 *
 * A set of NAC cards is considered a PASS.
 */
int  /* Returns TRUE if it was unable to make the move */
ass_move (
 	game_t game,  /* The game you are playing... */
 	set_t set     /* What set are they trying to lay? */
) {
 	int i, x, setstart_f;  /* junk */
 	int goer;  /* The person whose turn it is  */

 	if (ass_err (game->start == -2, "libass: ass_move(): deal first\n"))
 		return 1;

 	/* Clear the currently-laid set iff it's a new round */
 	ass_a_clear (game);
 	if (game->down.card == NAC) setstart_f = 1; else setstart_f = 0;

 	if ((goer = ass_turn (game)) == 0) return 2;  /* No one left to
 	                                               * take a turn!! */
 	goer--;

 	/* Special case the PASS move... */
 	if (set->card == NAC) {
 		if (game->down.card == NAC) {
 			/* This is a new round, and this person is leading,
 			 * but you're not allowed to lead with a pass move! */
 			return 3;
 		}
 		game->cur = goer;
 		return 0;  /* Succesfully PASSed... */
 	}

 	/* Check to make sure that said person has said set... */
 	if (!ass_set (&game->ppl[goer].hand, set)) return 4;

 	/* Check to make sure that said set can go on top of last set... */
 	if (!ass_setlt (&game->down, set)) return 5;

 	/* Okay, lay this set... */
 	game->down = *set;

 	/* Remove player's cards... */
 	x = set->num;
 	for (i=0; i<54 && x > 0; i++)
 	  if (game->ppl[goer].hand.cards[i] == set->card) {
 		x--;
 		game->ppl[goer].hand.cards[i] = NAC;
 	}

 	/* If buddy has no cards left, then we'll set the player->out for him */
 	for (i=0; i<14; i++) if (game->ppl[goer].hand.cards[i] != NAC) break;
 	if (i == 14) {
 		/* How many other people got out first? */
 		x = 1;
 		for (i=0; i<4; i++) if (game->ppl[i].out) x++;
 		game->ppl[goer].out = x;
 	}

 	/* miscellaneous housekeeping */
 	if (setstart_f || game->start == -1) game->start = goer;
 	game->cur = goer;
 	game->last = goer;

 	return 0;  /* success */
}
