/* xprez/xp_aimove.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

#include <ai.h>
#include <ass.h>
#include "tcl.h"
#include "internal.h"
#include <string.h>
#include <assert.h>

/*
 * This will make one move for the AI player whose turn it is.  If it
 * is not an AI player's turn, then this will do nothing and return
 * an empty string.  If it does make a move for an AI player, then it
 * will return the cards that were laid.  You are expected to have
 * already figured-out who is making the move with xp_turn().
 *
 * xp_aimove
 *
 * Returns the cards laid (eg. "d5 d5").  If the AI player passed,
 * then it will return "blank".  If no cards were laid, then it will
 * return an empty string.
 */
int
xp_aimove (ClientData cdata, Tcl_Interp * interp, int argc, char ** argv) {
	char ret[200];
	int t;  /* Who's turn it is */
	int i;  /* junk */

	t = ass_turn (&SGBg);
	if (t > 1) {
		/* It's an AI's turn!! */
		set_t set;

		if (ass_a_clear (&SGBg)) {
			for (i=0; i<4; i++) SGBlaid[i] = NAC;
			for (i=0; i<4; i++) SGBldown[i] = 0;
			for (i=0; i<4; i++) SGBlnum[i] = 0;
			SGBlast = 0;
		}

		set = ai_move (&SGBai[t-2], &SGBg.ppl[t-1].hand, &SGBg.down);
		assert (ass_move (&SGBg, set) == 0);
		SGBldown[SGBlast] = t;
		SGBlaid[SGBlast] = set->card;
		SGBlnum[SGBlast] = set->num;
		SGBlast++;

		for (i=0; i<3; i++)
			if (i != t-2) ai_watch (&SGBai[i], set, t);

		/* Construct what we're going to return */
		*ret = '\0';
		for (i=0; i<set->num; i++) {
			const char * c;
			switch (set->card) {
			case THREE:
				c = "d3 ";
				break;
			case FOUR:
				c = "d4 ";
				break;
			case FIVE:
				c = "d5 ";
				break;
			case SIX:
				c = "d6 ";
				break;
			case SEVEN:
				c = "d7 ";
				break;
			case EIGHT:
				c = "d8 ";
				break;
			case NINE:
				c = "d9 ";
				break;
			case TEN:
				c = "d10 ";
				break;
			case JACK:
				c = "d11 ";
				break;
			case QUEEN:
				c = "d12 ";
				break;
			case KING:
				c = "d13 ";
				break;
			case ACE:
				c = "d1 ";
				break;
			case TWO:
				c = "d2 ";
				break;
			case JOKER:
				c = "d14 ";
				break;
			case NAC:
				c = "blank ";
				break;
			default:
				assert (0);  /* boom */
				c = "blank";
			}
			strcat (ret, c);
		}

		Tcl_SetResult (interp, ret, TCL_VOLATILE);

		/* This is a bit of a hack.  If it is the turn of the
		 * human, next, then we'll try and clear the set.  We must
		 * do this because it is possible that the human laid the
		 * last set, which everyone passed on.  It would then
		 * be the human's turn, but the set would never have been
		 * cleared.  Alternatively, it is possible that the last
		 * person to lay a set is now gone.  We can't just
		 * arbitarily clear the set, because if the user may wish
		 * to see all the sets laid in this round. */
		if (ass_turn (&SGBg) == 1) {
			if (ass_a_clear (&SGBg)) {
				/* Clear the list of cards that are on
				 * the table */
				for (i=0; i<4; i++) SGBlaid[i] = NAC;
				for (i=0; i<4; i++) SGBldown[i] = NAC;
				for (i=0; i<4; i++) SGBlnum[i] = 0;
				SGBlast = 0;
			}
		}
		return TCL_OK;
	}

	*ret = '\0';
	Tcl_SetResult (interp, ret, TCL_VOLATILE);
	return TCL_OK;
}
