/* xprez/xp_cards.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

#include <ass.h>
#include "internal.h"
#include "tcl.h"
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include <stdio.h>

/*
 * Returns the cards to show for a given player.  If we are doing a
 * replay, all the cards will probably be face-up, otherwise all the
 * cards (except for those of our friendly human player) will probably
 * be face-down.
 *
 * xp_cards PLAYNUM
 *
 * Where PLAYNUM is (1-4)
 *
 * It will return a list of 14 cards.
 */
int
xp_cards (ClientData cdata, Tcl_Interp * interp, int argc, char ** argv) {
	int pn;  /* player number (1-4) */
	int i, x;
	char ret[200];  /* Must hold 6 chars @card * 14 cards, max */

	if (argc != 2) {
		char s[500];
		sprintf (s,
		    "wrong # args: should be \"%s PLAYNUM\"", argv[0]);
		Tcl_SetResult (interp, s, TCL_VOLATILE);
		return TCL_ERROR;
	}

	pn = atoi (argv[1]);
	if (pn < 1 || pn > 4) {
		char s[500];
		sprintf (s, "PLAYNUM must be between 1 and 4, inclusive");
		Tcl_SetResult (interp, s, TCL_VOLATILE);
		return TCL_ERROR;
	}

	/* if the player is not the human player... */
	if (pn != 1) {
		for (x=i=0; i<14; i++)
		  if (SGBg.ppl[pn-1].hand.cards[i] != NAC) x++;
		*ret = '\0';
		i = x;  /* save value of x for later use */
		for (; x; x--)
			strcat (ret, "back ");
		i = 14 - i;
		for (; i; i--)
			strcat (ret, "blank ");

		Tcl_SetResult (interp, ret, TCL_VOLATILE);
		return TCL_OK;
	}

/* For no we just use a very simple randomization routine to randomize
 * wether things are hearts, spades, clubs, or diamonds.  This isn't
 * very good, and we should fix it... */

	*ret = '\0';
	for (i=0; i<14; i++) {
	  	char suit;
	  	const char * card;

	  	switch (i%4) {
	  	case 0:
	  		suit = 'd';
	  		break;
	  	case 1:
	  		suit = 'h';
	  		break;
	  	case 2:
	  		suit = 'c';
	  		break;
	  	default:
	  		suit = 's';
	  		break;
	  	}

	  	switch (SGBg.ppl[pn-1].hand.cards[i]) {
	  	case THREE:
	  		card = "3";
	  		break;
	  	case FOUR:
	  		card = "4";
	  		break;
	  	case FIVE:
	  		card = "5";
	  		break;
	  	case SIX:
	  		card = "6";
	  		break;
	  	case SEVEN:
	  		card = "7";
	  		break;
	  	case EIGHT:
	  		card = "8";
	  		break;
	  	case NINE:
	  		card = "9";
	  		break;
	  	case TEN:
	  		card = "10";	
	  		break;
	  	case JACK:
	  		card = "11";
	  		break;
	  	case QUEEN:
	  		card = "12";
	  		break;
	  	case KING:
	  		card = "13";
	  		break;
	  	case ACE:
	  		card = "1";
	  		break;
	  	case TWO:
	  		card = "2";
	  		break;
	  	case JOKER:
	  		card = "14";
	  		break;
	  	case NAC:
	  		card = NULL;
			sprintf (ret+strlen(ret), " blank");
	  		break;
		default:
			assert (0);  /* missing a card in the above list! */
			card = NULL;
			break;  /* Quite impossible! */
	  	}
	  	if (card) sprintf (ret+strlen(ret), " %c%s", suit, card);
	  }

	Tcl_SetResult (interp, ret, TCL_VOLATILE);
	return TCL_OK;
}

