/* xprez/xp_havefile.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */


#include <stdio.h>
#include "tcl.h"

/*
 * This checks for the existance of tk_getOpenFile and returns 
 * a string containing `1' if it does, or `0' if it doesn't
 */
int
xp_havefile (ClientData cdata, Tcl_Interp * interp, int argc, char ** argv) {
	char ret[200];
	Tcl_CmdInfo junk;

	if (Tcl_GetCommandInfo (interp, "tk_getOpenFile", &junk))
		sprintf (ret, "1");
	else
		sprintf (ret, "0");

	Tcl_SetResult (interp, ret, TCL_VOLATILE);
	return TCL_OK;
}
