/* xprez/xp_laid.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

#include "internal.h"
#include "tcl.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

/*
 * This returns information about which cards are laid.
 *
 * xp_laid PLAYNUM num
 * 	Returns the number of cards in the laid set.
 *
 * xp_laid PLAYNUM card
 * 	Returns the card that makes-up the laid set, where PLAYNUM (0-3)
 * refers to the first, second, third, or fourth set to be laid.
 *
 * xp_laid PLAYNUM player
 *	Returns the player (1-4) who put the card there.
 * 
 */
int
xp_laid (ClientData cdata, Tcl_Interp * interp, int argc, char ** argv) {
	char ret[100];
	int playnum;  /* The playnum whose card we are to return */

	if (argc != 3) {
		sprintf (ret, "Wrong # args: %s [num | card]", argv[0]);
		Tcl_SetResult (interp, ret, TCL_VOLATILE);
		return TCL_ERROR;
	}

	playnum = atoi (argv[1]);
	if (playnum < 0 || playnum > 3) {
		sprintf (ret, "Bad arg: PLAYNUM (0-3)");
		Tcl_SetResult (interp, ret, TCL_VOLATILE);
		return TCL_ERROR;
	}

	if (!strcasecmp (argv[2], "num")) {
		sprintf (ret, "%d", SGBlnum[playnum]);
		Tcl_SetResult (interp, ret, TCL_VOLATILE);
		return TCL_OK;
	}

	if (!strcasecmp (argv[2], "card")) {
		switch (SGBlaid[playnum]) {
		case THREE:
			sprintf (ret, "d3");
			break;
		case FOUR:
			sprintf (ret, "d4");
			break;
		case FIVE:
			sprintf (ret, "d5");
			break;
		case SIX:
			sprintf (ret, "d6");
			break;
		case SEVEN:
			sprintf (ret, "d7");
			break;
		case EIGHT:
			sprintf (ret, "d8");
			break;
		case NINE:
			sprintf (ret, "d9");
			break;
		case TEN:
			sprintf (ret, "d10");
			break;
		case JACK:
			sprintf (ret, "d11");
			break;
		case QUEEN:
			sprintf (ret, "d12");
			break;
		case KING:
			sprintf (ret, "d13");
			break;
		case ACE:
			sprintf (ret, "d1");
			break;
		case TWO:
			sprintf (ret, "d2");
			break;
		case JOKER:
			sprintf (ret, "d14");
			break;
		case NAC:
			sprintf (ret, "blank");
			break;
		default:
			sprintf (ret,
				"Internal Error: __FILE__, __LINE__");
			Tcl_SetResult (interp, ret, TCL_VOLATILE);
			return TCL_ERROR;
		}
		Tcl_SetResult (interp, ret, TCL_VOLATILE);
		return TCL_OK;
	}

	if (!strcasecmp (argv[2], "player")) {
		sprintf (ret, "%d", SGBldown[playnum]);
		Tcl_SetResult (interp, ret, TCL_VOLATILE);
		return TCL_OK;
	}

	sprintf (ret,
	    "Incomprehensible args: \"%s PLAYNUM [num | card | player]\"",
	    argv[0]);
	Tcl_SetResult (interp, ret, TCL_VOLATILE);
	return TCL_ERROR;
}
