/* xprez/xp_load.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

#include "internal.h"
#include <ai.h>
#include <ass.h>
#include "tcl.h"
#include <stdio.h>

/*
 * This loads a file from its one single argument.  There is no
 * error checking, eh.
 */
int
xp_load (ClientData cdata, Tcl_Interp * interp, int argc, char ** argv) {
	char ret[200];
	FILE * sg;
	int j;

/* We really should do error checking here, since loading a bad file can
 * cause, well, lots of problems... */

	if (strlen(argv[1]) == 0) {
		Tcl_SetResult (interp, "No filename given", TCL_STATIC);
		return TCL_OK;
	}

	sg = fopen (argv[1], "rb");
	fread (&j, sizeof (int), 1, sg);
	fread (SGBai, sizeof (struct ai_s), 3, sg);
	fread (&SGBg, sizeof (struct game_s), 1, sg);
	fread (SGBlaid, sizeof (card_t), 4, sg);
	fread (SGBldown, sizeof (int), 4, sg);
	fread (SGBlnum, sizeof (int), 4, sg);
	fread (&SGBlast, sizeof (int), 1, sg);
	fread (SGBscores, sizeof (int), 16, sg);
	fread (ret, 21, 3, sg);
	fclose (sg);

	ret[63] = '\0';
	Tcl_SetResult (interp, ret, TCL_VOLATILE);
	return TCL_OK;
}
