/* xprez/xp_position.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

#include "tcl.h"
#include "internal.h"
#include <ass.h>
#include <stdlib.h>
#include <stdio.h>

/*
 * This will return a string "Ass", "President", "Vice-Ass", or
 * "Vice-President" corresponding to the passed player's position in
 * the game.
 *
 * xp_position PLAYER
 *
 * Where PLAYER is 1-4.
 */
int
xp_position (ClientData cdata, Tcl_Interp * interp, int argc, char ** argv) {
	char ret[200];

	if (argc != 2) {
		sprintf (ret, "Wrong # args: \"%s\"", argv[0]);
		Tcl_SetResult (interp, ret, TCL_VOLATILE);
		return TCL_OK;
	}

	if (atoi(argv[1]) < 1 || atoi(argv[1]) > 4) {
		sprintf (ret, "PLAYER must be 1-4");
		Tcl_SetResult (interp, ret, TCL_VOLATILE);
		return TCL_OK;
	}

	switch (SGBg.ppl[atoi(argv[1])-1].pos) {
	case ASS:
		sprintf (ret, "Ass");
		break;
	case VICEASS:
		sprintf (ret, "Vice-Ass");
		break;
	case VICE:
		sprintf (ret, "Vice-President");
		break;
	case PREZ:
		sprintf (ret, "President");
		break;
	default:
		sprintf (ret, "BAD ERROR!  Memory Corruption!");
		break;
	}
	Tcl_SetResult (interp, ret, TCL_VOLATILE);
	return TCL_OK;
}
