/* xprez/xp_save.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

#include "tcl.h"
#include "internal.h"
#include <stdio.h>
#include <ai.h>
#include <ass.h>

/*
 * This will save all the current game data to the file given
 * as argument number one.  It will append ".xtvp" to the filename.
 *
 * You must also pass it the names of the three AI players.  They will
 * be truncated to 20 chars in length and saved.  xp_load will return
 * the list of them, later.
 *
 * There is no error check'n or nut'n.
 */
int
xp_save (ClientData cdata, Tcl_Interp * interp, int argc, char ** argv) {
	char ret[100];
	FILE * sg;
	int j;
	char temp[700];

	if (!(strlen (argv[1]) > 5 && 
	  argv[1][strlen(argv[1])-5] == '.' &&
	  argv[1][strlen(argv[1])-4] == 'x' &&
	  argv[1][strlen(argv[1])-3] == 't' &&
	  argv[1][strlen(argv[1])-2] == 'v' &&
	  argv[1][strlen(argv[1])-1] == 'p')) {
		/* Under windows, our .xtvp extension gets automatically
		 * added for us, but it gets added as .xtv... */
		if (strlen (argv[1]) > 4  &&
		  argv[1][strlen(argv[1])-4] == '.' &&
		  argv[1][strlen(argv[1])-3] == 'x' &&
		  argv[1][strlen(argv[1])-2] == 't' &&
		  argv[1][strlen(argv[1])-1] == 'v')
			sprintf (temp, "%sp", argv[1]);
		else {
#if 0
			/* Urg!  Why can't I link with cygwin's snprintf()!? */
			snprintf (temp, 100, "%s.xtvp", argv[1]);
#else
			sprintf (temp, "%s.xtvp", argv[1]);
#endif
		}
	} else
		strcpy (temp, argv[1]);

	sg = fopen (temp, "wb");
	j = VERSIONSERIAL;
	fwrite (&j, sizeof (int), 1, sg);
	fwrite (SGBai, sizeof (struct ai_s), 3, sg);
	fwrite (&SGBg, sizeof (struct game_s), 1, sg);
	fwrite (SGBlaid, sizeof (card_t), 4, sg);
	fwrite (SGBldown, sizeof (int), 4, sg);
	fwrite (SGBlnum, sizeof (int), 4, sg);
	fwrite (&SGBlast, sizeof (int), 1, sg);
	fwrite (SGBscores, sizeof (int), 16, sg);

	sprintf (temp, "%.20s %.20s %.20s ", argv[2], argv[3], argv[4]);
	fwrite (temp, 21, 3, sg);

	fclose (sg);

	*ret = '\0';
	return TCL_OK;
}
