/* xprez/xp_scores.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

#include "tcl.h"
#include "internal.h"
#include <stdio.h>
#include <ass.h>
#include <string.h>
#include <stdlib.h>

/*
 * This will return the number of points a given player has earned
 * when it has only one argument.  If you give it two arguments, it
 * will return the number of times that person has taken that position.
 *
 * xp_scores PLAYER
 *
 * Where player is 1-4, returns the number of points, in decimal.
 *
 * xp_scores PLAYER POSITION
 *
 * Where PLAYER is 1-4 and POSITION is one of prez, vice, viceass, and
 * ass; returns the number of times PLAYER has taken POSITION, in
 * decimal.
 */
int
xp_scores (ClientData cdata, Tcl_Interp * interp, int argc, char ** argv) {
	char ret[200];
	signed int i, j;

	switch (argc) {
	case 2:
		if (atoi(argv[1]) < 1 || atoi(argv[1]) > 4) {
			sprintf (ret, "Bad player #");
			Tcl_SetResult (interp, ret, TCL_VOLATILE);
			return TCL_ERROR;
		}

		/* Recall ASS, VICEASS, VICE, PREZ are guaranteed to be
		 * ascending in value. */
		for (j=i=0; i < 4; i++) {
			switch (i) {
			case 0:
				j += SGBscores[atoi(argv[1])-1][i] * -2;
				break;
			case 1:
				j += SGBscores[atoi(argv[1])-1][i] * -1;
				break;
			case 2:
				j += SGBscores[atoi(argv[1])-1][i] * 1;
				break;
			case 3:
				j += SGBscores[atoi(argv[1])-1][i] * 2;
				break;
			}
		}

		sprintf (ret, "%d", j);
		Tcl_SetResult (interp, ret, TCL_VOLATILE);
		return TCL_OK;
	case 3:
		if (atoi(argv[1]) < 1 || atoi(argv[1]) > 4) {
			sprintf (ret, "Bad player #");
			Tcl_SetResult (interp, ret, TCL_VOLATILE);
			return TCL_ERROR;
		}

		if (!strcasecmp (argv[2], "ass")) {
			sprintf (ret, "%d",
			    SGBscores[atoi(argv[1])-1][ASS-ASS]);
			Tcl_SetResult (interp, ret, TCL_VOLATILE);
			return TCL_OK;
		} else if (!strcasecmp (argv[2], "viceass")) {
			sprintf (ret, "%d",
			    SGBscores[atoi(argv[1])-1][VICEASS-ASS]);
			Tcl_SetResult (interp, ret, TCL_VOLATILE);
			return TCL_OK;
		} else if (!strcasecmp (argv[2], "vice")) {
			sprintf (ret, "%d",
			    SGBscores[atoi(argv[1])-1][VICE-ASS]);
			Tcl_SetResult (interp, ret, TCL_VOLATILE);
			return TCL_OK;
		} else if (!strcasecmp (argv[2], "prez")) {
			sprintf (ret, "%d",
			    SGBscores[atoi(argv[1])-1][PREZ-ASS]);
			Tcl_SetResult (interp, ret, TCL_VOLATILE);
			return TCL_OK;
		} else {
			sprintf (ret, "Bad args!");
			Tcl_SetResult (interp, ret, TCL_VOLATILE);
			return TCL_ERROR;
		}
	default:
		sprintf (ret, "Unintelligable args!");
		Tcl_SetResult (interp, ret, TCL_VOLATILE);
		return TCL_ERROR;
	}
}
