/* xprez/xp_select.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

#include <ass.h>
#include "internal.h"
#include <stdlib.h>
#include "tcl.h"
#include <stdio.h>

/*
 * This will take an argument referring to a card-number, (0-13),
 * and return the cards that would make-up that set (ie. all cards
 * with lower-card numbers and the same value).
 *
 * xp_select CARDNUM
 *
 * Where CARDNUM is (0-13).
 *
 * It will return "" if nothing can be selected, or the list of
 * cards that would be selected, otherwise.
 */
int
xp_select (ClientData cdata, Tcl_Interp * interp, int argc, char ** argv) {
	char ret[200];
	int cn;  /* cardnum */
	int i;  /* junk */
	card_t j;  /* junk */

	if (argc != 2) {
		sprintf (ret, "wrong # args: should be \"%s CARDNUM\"",
		    argv[0]);
		Tcl_SetResult (interp, ret, TCL_VOLATILE);
		return TCL_ERROR;
	}

	cn = atoi (argv[1]);

	if (cn < 0 || cn > 13 || *argv[1] < '0' || *argv[1] > '9') {
		sprintf (ret, "CARDNUM should be (0-13)");
		Tcl_SetResult (interp, ret, TCL_VOLATILE);
		return TCL_ERROR;
	}

	/* First make sure that there is at least one valid card to return */
	if (SGBg.ppl[0].hand.cards[cn] == NAC) {
		/* Oh-uh! */
		Tcl_SetResult (interp, ret, TCL_VOLATILE);
		return TCL_OK;
	}

	j = SGBg.ppl[0].hand.cards[cn];
	sprintf (ret, "%d", cn);
	for (i=cn - 1; i >= 0 && j == SGBg.ppl[0].hand.cards[i]; i--) {
		sprintf (ret, "%s %d", ret, i);
	}

	Tcl_SetResult (interp, ret, TCL_VOLATILE);
	return TCL_OK;
}
