/* xprez/xpwish.c
 *
 *  Copyright (C) 1997  Timothy M. Vanderhoek
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Tim Vanderhoek
 *  ac199@hwcn.org
 */

/*
 * The main() stuff for xpwish
 */

#include "tcl.h"
#include "tk.h"
#include <ass.h>
#include <stddef.h>
#include "xp_extns.h"
#include "internal.h"

int main (int, char **);
int Tcl_AppInit (Tcl_Interp *);
int XP_Init (Tcl_Interp *);

int
main (int argc, char **argv) {
	Tk_Main (argc, argv, Tcl_AppInit);

	return 0;
}

/*
 * Called by Tk_Main() (in turn called from main()) to init
 * whatever else is remaining to be initted.
 */
int
Tcl_AppInit (Tcl_Interp * interp) {

	if (Tcl_Init (interp) == TCL_ERROR) return TCL_ERROR;  /* Init Tcl */
	if (XP_Init (interp) == TCL_ERROR) return TCL_ERROR;   /* My extns */
	if (Tk_Init (interp) == TCL_ERROR) return TCL_ERROR;   /* And Tk */

  /*
   * if (getenv("HOME")) {
   *   sprintf (tempstring, "%s/.xdeviewrc", getenv ("HOME"));
   *   Tcl_EvalFile (interp, tempstring);
   * }
   */

	return TCL_OK;
}


int
XP_Init (Tcl_Interp * interp) {
	int i, ii;

	/* Initialize the game */
	ass_init (&SGBg);

/* Shouldn't depend on this stuff being here...  I want it all in
 * xp_configure.c */
	for (i=0; i<4; i++) SGBlaid[i] = NAC;
	for (i=0; i<4; i++) SGBldown[i] = 0;
	for (i=0; i<4; i++) SGBlnum[i] = 0;
	SGBlast = 0;
	for (i=0; i<4; i++) for (ii=0; ii<4; ii++) SGBscores[i][ii] = 0;

	Tcl_CreateCommand (interp, "xp_configure", xp_configure, NULL, NULL);
	Tcl_CreateCommand (interp, "xp_deal", xp_deal, NULL, NULL);
	Tcl_CreateCommand (interp, "xp_cards", xp_cards, NULL, NULL);
	Tcl_CreateCommand (interp, "xp_select", xp_select, NULL, NULL);
	Tcl_CreateCommand (interp, "xp_lay", xp_lay, NULL, NULL);
	Tcl_CreateCommand (interp, "xp_laid", xp_laid, NULL, NULL);
	Tcl_CreateCommand (interp, "xp_aimove", xp_aimove, NULL, NULL);
	Tcl_CreateCommand (interp, "xp_turn", xp_turn, NULL, NULL);
	Tcl_CreateCommand (interp, "xp_all", xp_all, NULL, NULL);
	Tcl_CreateCommand (interp, "xp_left", xp_left, NULL, NULL);
	Tcl_CreateCommand (interp, "xp_human", xp_human, NULL, NULL);
	Tcl_CreateCommand (interp, "xp_position", xp_position, NULL, NULL);
	Tcl_CreateCommand (interp, "xp_scores", xp_scores, NULL, NULL);
	Tcl_CreateCommand (interp, "xp_call", xp_call, NULL, NULL);
	Tcl_CreateCommand (interp, "xp_havefile", xp_havefile, NULL, NULL);
	Tcl_CreateCommand (interp, "xp_save", xp_save, NULL, NULL);
	Tcl_CreateCommand (interp, "xp_load", xp_load, NULL, NULL);

	return Tcl_PkgProvide(interp, "xprez", VERSION);
}
