CREATE TABLE dict (
  url_id INT NOT NULL,
  word CHAR(32) NOT NULL,
  intag INT NOT NULL
);

CREATE TABLE url (
  rec_id INT NOT NULL PRIMARY KEY,
  status INT,
  url CHAR(128) NOT NULL,
  content_type CHAR(32),
  last_modified CHAR(48),
  title CHAR(128),
  txt CHAR(255),
  docsize INT,
  last_index_time INT NOT NULL,
  next_index_time INT NOT NULL,
  referrer INT,
  tag INT,
  hops INT,
  keywords CHAR(255),
  description CHAR(100),
  crc CHAR(33) NOT NULL,
  lang CHAR(2)
);

CREATE TABLE stopword (
  word char(32) DEFAULT '' NOT NULL,
  lang char(2) DEFAULT '' NOT NULL
);

CREATE TABLE robots (
  hostinfo CHAR(127) NOT NULL,
  path CHAR(127) NOT NULL
);

CREATE   INDEX dict_word_url_id ON dict (word,url_id);

CREATE   INDEX dict_url_id ON dict (url_id);

CREATE UNIQUE  INDEX url_url ON url (url);

CREATE INDEX url_crc ON url (crc);

CREATE UNIQUE  INDEX stopword_word ON stopword (word,lang);


CREATE GENERATOR rec_id_GEN;
SET TERM !! ;
CREATE TRIGGER CREATE_rec_id FOR url
	BEFORE INSERT
		POSITION 0
	AS BEGIN
		NEW.rec_id = GEN_ID(rec_id_GEN, 1);
	END !!
SET TERM ; !!
