<?

// -----------------------------------------------
// initdb()
// -----------------------------------------------
function initdb(){
   global $dbodbc, $dbodbc_cursor_type;
   global $dbhost,$dbuser,$dbpass,$dbname,$dbport,$dbtype;
   global $dbconn;
   global $cur_row_array;
   global $num_rows_array;

   if ($dbodbc) {
       if ($dbodbc_cursor_type) {
          if (! $dbconn=odbc_pconnect($dbname,$dbuser,$dbpass,$dbodbc_cursor_type)) 
          print_error_local("Cannot connect to odbc datasource $dbname as user $dbuser");
       } else {
          if (! $dbconn=odbc_pconnect($dbname,$dbuser,$dbpass)) 
          print_error_local("Cannot connect to odbc datasource $dbname as user $dbuser");
       }
   } else {
       switch($dbtype) {
          case 'mysql':
             if ($dbport == '') {
               if (!mysql_pconnect($dbhost,$dbuser,$dbpass))
                  print_error_local("Cannot connect to mysql host $dbhost as user $dbuser");
             } else {
               if (!mysql_pconnect("$dbhost:$dbport",$dbuser,$dbpass))
                  print_error_local("Cannot connect to mysql host $dbhost:$dbport as user $dbuser");
             }
             
             if (! mysql_select_db($dbname))
                print_error_local("DB $dbname select error");
    
             break;
          case 'oracle':
          case 'oracle8':
             if (! $dbconn=OCIPLogon($dbuser,$dbpass,$dbname)) 
                print_error_local("Cannot connect to oracle db $dbname as user $dbuser");
    
             break;
          case 'oracle7':
             if (! $dbconn=ora_plogon("$dbuser/$dbpass@$dbname",""))
                print_error_local("Cannot connect to oracle db $dbname as user $dbuser");
             if (! $dbconn=ora_open($dbconn))
                print_error_local("Cannot connect to oracle db $dbname as user $dbuser");
             break;
          case 'pgsql':
             if ($dbport == '') {
               if (! $dbconn=pg_pconnect("dbname=$dbname host=$dbhost user=$dbuser password=$dbpass"))
                  print_error_local("Cannot connect to pgsql host $dbhost as user $dbuser");
             } else {
               if (! $dbconn=pg_pconnect("dbname=$dbname host=$dbhost port=$dbport user=$dbuser password=$dbpass"))
                  print_error_local("Cannot connect to pgsql host $dbhost:$dbport as user $dbuser");
             }
    
             $cur_row_array = array();
             $num_rows_array = array();
    
             break;
          default:
             print_error_local("Unknown DBType: $dbtype");
       }
   }
}

// -----------------------------------------------
// db_numrows($res)
// -----------------------------------------------
function db_numrows($res) {
   global $dbtype;
   global $dbodbc;

   if ($dbodbc) {
      $rows=odbc_num_rows($res);
   } else {
      switch($dbtype) {
         case 'mysql':
            $rows=mysql_numrows($res);
            break;
         case 'pgsql':
            $rows=pg_numrows($res);
            break;
         default:
            print_error_local("Unknown DBType: $dbtype");
      }
   }
   return($rows);
}

// -----------------------------------------------
// query($query)
// -----------------------------------------------
function query($query) {
   global $dbtype;
   global $dbodbc;
   global $dbconn;
   global $cur_row_array;
   global $num_rows_array;

   if ($dbodbc) {
      $res=odbc_exec($dbconn,$query);
   } else {
      switch($dbtype) {
         case 'mysql':
            $res=mysql_query($query);
            break;
         case 'oracle':
         case 'oracle8':
            if (! $pres=OCIPArse($dbconn,$query)) return $pres;
            $res=OCIExecute($pres);
            if ($res)  return ($pres);
            break;
         case 'oracle7':
            if (! $pres=ora_parse($dbconn, $query)) return $pres;
            $res=ora_exec($dbconn);
            if ($res)  return ($pres);
            break;
         case 'pgsql':
            $res=pg_exec($dbconn,$query);
            $cur_row_array[$res]=0;
            $num_rows_array[$res]=db_numrows($res);
            break;
         default:
            print_error_local("Unknown DBType: $dbtype");
      }
   }
   return($res);
}

// -----------------------------------------------
// fetch_row($res)
// -----------------------------------------------
function fetch_row($res) {
   global $dbtype;
   global $dbodbc;
   global $dbconn;
   global $cur_row_array;
   global $num_rows_array;

   if ($dbodbc) {
      if (! odbc_fetch_into($res,&$row)) $row=array();
   } else {
      switch($dbtype) {
         case 'mysql':
            $row=mysql_fetch_row($res);
            break;
         case 'oracle':
         case 'oracle8':
            $result=OCIFetchInto($res,&$row,OCI_NUM+OCI_RETURN_NULLS );
            if (! $result) $row=array();
            break;
         case 'oracle7':
            $result=ora_fetch($dbconn);
            $errno=ora_errorcode($dbconn);
            if(1403 == $errno || !$result)
            { // 1043 means no more records found
                return array();
            }
    
            for($ix=0;$ix<ora_numcols($dbconn);$ix++) 
            {
                  $col=strtolower(ora_columnname($dbconn,$ix));
                  $value=ora_getcolumn($dbconn,$ix);
                  $row[ "$col" ] = $value;
                  $row[ $ix ]    = $value;
            }
            break;
          case 'pgsql':
            if ($cur_row_array[$res] >= $num_rows_array[$res]) {
               $row=array();
            } else {
               $row=pg_fetch_row($res,$cur_row_array[$res]);
               $cur_row_array[$res]++;
            }
            break;
         default:
            print_error_local("Unknown DBType: $dbtype");
      }
   }
   return($row);
}

// -----------------------------------------------
// db_data_seek($res,$from)
// -----------------------------------------------
function db_data_seek($res,$from) {
   global $dbtype;
   global $dbodbc;
   global $cur_row_array;

   if ($dbodbc) {
      $dataseek=1;
      for ($i=0; $i<$from; $i++) {
         $row=fetch_row($res);
         if (! $row) {
            $dataseek=0;
            break;
         }
      }
   } else {
      switch($dbtype) {
         case 'mysql':
            $dataseek=mysql_data_seek($res,$from);
            break;
         case 'oracle':
         case 'oracle8':
         case 'oracle7':
            $dataseek=1;
            for ($i=0; $i<$from; $i++) {
               $row=fetch_row($res);
               if (! $row) {
                  $dataseek=0;
                  break;
               }
            }
            break;
         case 'pgsql':
            $dataseek=1;
            $cur_row_array[$res]=$from;
            break;
         default:
            print_error_local("Unknown DBType: $dbtype");
      }
   }
   return($dataseek);
}

// -----------------------------------------------
// free_result($res)
// -----------------------------------------------
function free_result($res) {
   global $dbtype;
   global $dbodbc;

   if ($dbodbc) {
      odbc_free_result($res);
   } else {
      switch($dbtype) {
         case 'mysql':
            mysql_free_result($res);
            break;
         case 'oracle':
         case 'oracle8':
            OCIFreeStatement($res);
            break;
         case 'oracle7':
            break;
         case 'pgsql':
            pg_freeresult($res);
            break;
         default:
            print_error_local("Unknown DBType: $dbtype");
      }
   }
}

// -----------------------------------------------
// db_error()
// -----------------------------------------------
function db_error() {
   global $dbtype;
   global $dbodbc;
   global $dbconn;

   if ($dbodbc) {
      $error='ODBC error occured';
   } else {
      switch($dbtype) {
         case 'mysql':
            $error=mysql_error();
            break;
         case 'oracle':
         case 'oracle8':
            $error=OCIError();
            break;
         case 'oracle7':
            $error=Ora_Error($dbconn);
            break;	 
         case 'pgsql':
            $error=pg_errormessage();
            break;
         default:
            print_error_local("Unknown DBType: $dbtype");
      }
   }
   return $error;
}

?>
