#ifndef _UDM_DBMS_H
#define _UDM_DBMS_H


/* Database type */
#define UDM_DB_UNK		0
#define UDM_DB_MSQL		1
#define UDM_DB_MYSQL		2
#define UDM_DB_PGSQL		3
#define UDM_DB_SOLID		4
#define UDM_DB_ORACLE		5
#define UDM_DB_VIRT		6
#define UDM_DB_IBASE		7
#define UDM_DB_ORACLE8		8
#define UDM_DB_ORACLE7		9
#define UDM_DB_MSSQL		10
#define UDM_DB_FILES		100

/* FIXME: hide this function into SQL.c */
extern char * escstr(char *x,char *y);

extern int UdmLoadStopList(void * db);
extern int UdmAddURL(UDM_INDEXER * Indexer,char *url,int referrer,int hops, char * msg_id);
extern int UdmDeleteWordFromURL(UDM_INDEXER* Indexer,int url_id);
extern int UdmDeleteUrl(UDM_INDEXER* Indexer,int url_id);
extern int UdmUpdateUrl(UDM_INDEXER* Indexer,int url_id,int status,int period);

#ifdef NEWS_EXT
extern int UdmRegisterChild(UDM_INDEXER *Indexer, int parent_id, int child_id);
extern int UdmFindMsgID(UDM_INDEXER *Indexer, const char * msg_id);
extern int UdmDeleteAllFromThread(UDM_INDEXER* Indexer);
extern int UdmLongUpdateUrl(UDM_INDEXER *Indexer,
	int url_id,int status,int changed,int size,int period,
	int hint,int index,
	char *last_modified_escaped,
	char *text_escaped,
	char *title_escaped,
	char *content_type,
	char *keywords_escaped,
	char *descript_escaped,
	char *digest,
	char *lang,
	char *hd_date,
	char *hd_subj,
	char *hd_from,
	char *hd_group,
	char *hd_ref,
	char *msg_id
);
#else
extern int UdmLongUpdateUrl(UDM_INDEXER* Indexer,
	int url_id,int status,int is_changed,
	int size,int period,int hint,int index,
	char *last_modified_escaped,
	char *text_escaped,
	char *title_escaped,
	char *content_type,
	char *keywords_escaped,
	char *descript_escaped,
	char *digest,
	char *lang);
#endif

extern int UdmStoreWords(UDM_INDEXER * Indexer, int url_id);
extern int UdmFindOrigin(UDM_INDEXER* Indexer,char *crc);
extern int UdmUpdateClone(UDM_INDEXER* Indexer,int url_id,int status,int period,
	char *content_type,char *last_modified_escaped,char *digest);

extern int UdmDeleteAllFromDict(UDM_INDEXER* Indexer);
extern int UdmDeleteAllFromUrl(UDM_INDEXER* Indexer);
extern int UdmDeleteRobotsFromHost(UDM_INDEXER* Indexer,char *hostinfo);
extern int UdmAddRobotsToHost(UDM_INDEXER* Indexer,char *hostinfo,char *s);

extern UDM_DOCUMENT * UdmFind(void * db,char *q,int np,int ps, int mode,int sort_order,char *wordinfo,int *found);
extern UDM_DOCUMENT * UdmCloneList(void * db,char *crc);
extern UDM_DOCUMENT * UdmGetDocInfo(UDM_INDEXER* Indexer,int expired_first);
extern UDM_STOPWORD * UdmIsStopWord(char *word);
extern char * UdmDBErrorMsg(void *db);
extern int UdmDBErrorCode(void *db);

extern void * UdmAllocDB(int mode);
extern void   UdmFreeDB(void * db);
extern int    UdmLoadRobots(UDM_INDEXER *Indexer);
extern int    UdmMarkForReindex(UDM_INDEXER * Indexer);
extern int    UdmClearDB(UDM_INDEXER * Indexer);
extern int    UdmInitDB();

extern int         UdmInsertSpell(UDM_INDEXER *,char *,char *,char *);
extern UDM_SPELL * UdmFindWordDB(char *);
extern int 	   UdmInsertAffix(UDM_INDEXER *,char ,char *,char *,char *,char *,char *);
extern int         UdmDBImportAffixes(void *);

extern __INDLIB__ int UdmAddTagLimit(int tag);
extern __INDLIB__ int UdmAddStatusLimit(int status);
extern __INDLIB__ int UdmAddURLLimit(char * URL);
extern __INDLIB__ int UdmAddLangLimit(char * lang);
extern __INDLIB__ int UdmClearURLLimit();
extern __INDLIB__ int UdmClearLimits();
extern __INDLIB__ int UdmGetReferers(UDM_INDEXER * Indexer);
extern __INDLIB__ int UdmGetStatistics();
extern __INDLIB__ char * UdmVersion();


#ifdef USE_HTDB
int UdmHTDBGet(UDM_INDEXER * Indexer,char *path,char *filename,char * htdb_list, char * htdb_doc,
		char *buf,int MaxDocSize);
#endif


#endif
