#ifndef _UDM_SYSLOG_H
#define _UDM_SYSLOG_H

#include "udm_config.h"
#ifdef HAVE_SYSLOG_H
#include <syslog.h>
#endif

/* Verbose levels */
#define UDM_LOG_NONE	0
#define UDM_LOG_ERROR	1
#define UDM_LOG_WARN	2
#define UDM_LOG_INFO	3
#define UDM_LOG_EXTRA	4
#define UDM_LOG_DEBUG	5

extern void (*ThreadInfo)(int handle,char *state, char* str); /* EXT */
extern void (*StatInfo)(int handle, int code, int expired, int total, char* str);  /* EXT */
extern void (*RefInfo)(int code,char *url, char *ref);  /* EXT */

extern int UdmOpenLog(int log2stderr);
extern void UdmLog(int handle,int level, const char *fmt, ...);

extern __INDLIB__ int  UdmSetRefProc(void (*_RefProc)(int code,char *url, char *ref));
extern __INDLIB__ int  UdmSetThreadProc(void (*_ThreadInfo)(int handle,char *state, char* str));
extern __INDLIB__ int  UdmSetStatProc(void (*_StatInfo)(int handle,int code, int expired, int total, char* str));
extern __INDLIB__ void UdmSetLogLevel(int level);
extern __INDLIB__ void UdmSetLogFacility(char * facility);

#endif
