/* Unix/Windows specific stuff */

#ifndef _UDM_OS_H
#define _UDM_OS_H

#if (WIN32|WINNT)
#include <windows.h>
#include "strcasecmp.h"	/* Windows has no built-in strcasecmp, use own one */
#define mode_t int	/* mode_t is UNIX related, does not matter for MS  */
#define __INDLIB__	__declspec(dllexport) /* export functions for DLL  */
#define UDMSLASH		'\\'
#define UDMSLEEP(x)		_sleep(x*1000)
#define UDMMEMZERO(a,b)		memset(a,0,b)
#else
#define __INDLIB__
#define UDMSLASH		'/'
#define UDMSLEEP(x)		sleep(x)
#define UDMMEMZERO(a,b)		bzero(a,b)
#endif

#endif /* _UDM_OS_H */
