#ifndef _UDM_PROTO_H
#define _UDM_PROTO_H

extern char *MirrorRoot;		/* EXT */
extern char *MirrorHeadersRoot;		/* EXT */

/* some of NNTP status codes */
#define NNTP_GROUP_OK                 211
#define NNTP_XOVER_OK                 224

/* HTTP status codes */
#define UDM_HTTP_STATUS_UNKNOWN		0
#define UDM_HTTP_STATUS_OK		200
#define UDM_HTTP_STATUS_REDIRECT	301
#define UDM_HTTP_STATUS_NOT_MODIFIED	304
#define UDM_HTTP_STATUS_DELETE		400
#define UDM_HTTP_STATUS_RETRY		503
#define UDM_HTTP_STATUS_BAD_REQUEST	400
#define UDM_HTTP_STATUS_UNAVAIL		503
#define UDM_HTTP_STATUS_TIMEOUT		504
#define UDM_HTTP_STATUS_NOT_SUPPORTED	505

/* UdmSearch network error codes */
#define UDM_NET_ERROR			-1
#define UDM_NET_TIMEOUT			-2
#define UDM_NET_CANT_CONNECT		-3
#define UDM_NET_CANT_RESOLVE		-4
#define UDM_NET_UNKNOWN			-5

/* Mirror parameters and error codes */
#define UDM_MIRROR_NO			-1
#define UDM_MIRROR_YES			0
#define UDM_MIRROR_NOT_FOUND		-1
#define UDM_MIRROR_EXPIRED		-2
#define UDM_MIRROR_CANT_BUILD		-3
#define UDM_MIRROR_CANT_OPEN		-4


/* Mime type functions */
extern int  UdmAddType(char * mime_type,char *reg, char * errstr);
extern void UdmFreeTypes();

/* Build directory */
extern int   UdmBuild(char * path, int mode);

/* Different protocols */
extern int   UdmHTTPResponseType(int status);
extern char *UdmHTTPErrMsg(int code);
extern int   UdmFILEGet(char *header,char *dist,int maxsize);
extern int   UdmHTTPGet(char *host, int port, char *header,
       UDM_INDEXER *Indexer, int maxsize, int read_timeout);
extern int  UdmNEWSGet(char *host,int port,char *header,
	char *dist,int maxsize,int read_timeout);
extern int   UdmNNTPGet(char *host,int port,char *header,
	char *dist,int maxsize,int read_timeout);
extern int   UdmMirrorPUT(char *schema, char *hostname, char *path,
	char *filename, char *header, char *content, int size, char *errmsg);
extern int   UdmMirrorGET(char *schema, char *hostname, char *path,
	char *filename, char *buf, int MaxDocSize, int days, char *errmsg);

#endif
