#include "udm_config.h"
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include "udm_common.h"
#include "udm_log.h"

#ifdef HAVE_SYSLOG_H
#ifndef LOG_FACILITY
#define LOG_FACILITY LOG_LOCAL7
#endif /* LOG_FACILITY */
#else
#define LOG_FACILITY 0
#endif

void (*RefInfo)(int code,char *url, char *ref);
__INDLIB__ int UdmSetRefProc(void (*_RefProc)(int code,char *url, char *ref)){
	RefInfo=_RefProc;
	return(0);
}

void (*ThreadInfo)(int handle,char *state, char* str) = NULL;
__INDLIB__ int UdmSetThreadProc(void (*_ThreadInfo)(int handle,char *state, char* str)){
	ThreadInfo=_ThreadInfo;
	return(0);
}

void (*StatInfo)(int handle, int code, int expired, int total, char* str);
__INDLIB__ int UdmSetStatProc(void (*_StatInfo)(int handle,int code, int expired, int total, char* str)){
	StatInfo=_StatInfo;
	return(0);
}


static int LogFacility=LOG_FACILITY;
static int LogLevel=UDM_LOG_INFO;
static int is_log_open=0;
static FILE *error=NULL;


#ifndef HAVE_VSNPRINTF
#ifndef HAVE_STRNLEN
int strnlen(const char *s, int max){
const char *e;
	e=s;
	while((*e)&&((e-s)<max))e++;
	return(e-s);
}
#endif
/* we use this so that we can do without the ctype library */
#define is_digit(c)	((c) >= '0' && (c) <= '9')
#define ZEROPAD	1		/* pad with zero */
#define SIGN	2		/* unsigned/signed long */
#define PLUS	4		/* show plus */
#define SPACE	8		/* space if plus */
#define LEFT	16		/* left justified */
#define SPECIAL	32		/* 0x */
#define LARGE	64		/* use 'ABCDEF' instead of 'abcdef' */

#define do_div(n,base) ({ \
int __res; \
__res = ((unsigned long) n) % (unsigned) base; \
n = ((unsigned long) n) / (unsigned) base; \
__res; })

static int skip_atoi(const char **s){
	int i=0;

	while (is_digit(**s))
		i = i*10 + *((*s)++) - '0';
	return i;
}
static int number(long num, int base, int size, int precision ,int type)
{
	int buflen=0;
	char c,sign,tmp[66];
	const char *digits="0123456789abcdefghijklmnopqrstuvwxyz";
	int i;

	if (type & LARGE)
		digits = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
	if (type & LEFT)
		type &= ~ZEROPAD;
	if (base < 2 || base > 36)
		return 0;
	c = (type & ZEROPAD) ? '0' : ' ';
	sign = 0;
	if (type & SIGN) {
		if (num < 0) {
			sign = '-';
			num = -num;
			size--;
		} else if (type & PLUS) {
			sign = '+';
			size--;
		} else if (type & SPACE) {
			sign = ' ';
			size--;
		}
	}
	if (type & SPECIAL) {
		if (base == 16)
			size -= 2;
		else if (base == 8)
			size--;
	}
	i = 0;
	if (num == 0)
		tmp[i++]='0';
	else while (num != 0)
		tmp[i++] = digits[do_div(num,base)];
	if (i > precision)
		precision = i;
	size -= precision;
	if (!(type&(ZEROPAD+LEFT)))
		while(size-->0)
			buflen++;
	if (sign)
		buflen++;
	if (type & SPECIAL) {
		if (base==8)
			buflen++;
		else if (base==16) {
			buflen++;
			buflen++;
		}
	}
	if (!(type & LEFT))
		while (size-- > 0)
			buflen++;
	while (i < precision--)
		buflen++;
	while (i-- > 0)
		buflen++;
	while (size-- > 0)
		buflen++;
	return buflen;
}
static int udm_vsnprintf(const char *fmt, va_list args)
{
	int buflen=0;
	int len;
	unsigned long num;
	int i, base;
	const char *s;

	int flags;		/* flags to number() */

	int field_width;	/* width of output field */
	int precision;		/* min. # of digits for integers; max
				   number of chars for from string */
	int qualifier;		/* 'h', 'l', or 'L' for integer fields */

	for (; *fmt ; ++fmt) {
		if (*fmt != '%') {
			buflen++;
			continue;
		}
			
		/* process flags */
		flags = 0;
		repeat:
			++fmt;		/* this also skips first '%' */
			switch (*fmt) {
				case '-': flags |= LEFT; goto repeat;
				case '+': flags |= PLUS; goto repeat;
				case ' ': flags |= SPACE; goto repeat;
				case '#': flags |= SPECIAL; goto repeat;
				case '0': flags |= ZEROPAD; goto repeat;
				}
		
		/* get field width */
		field_width = -1;
		if (is_digit(*fmt))
			field_width = skip_atoi(&fmt);
		else if (*fmt == '*') {
			++fmt;
			/* it's the next argument */
			field_width = va_arg(args, int);
			if (field_width < 0) {
				field_width = -field_width;
				flags |= LEFT;
			}
		}

		/* get the precision */
		precision = -1;
		if (*fmt == '.') {
			++fmt;	
			if (is_digit(*fmt))
				precision = skip_atoi(&fmt);
			else if (*fmt == '*') {
				++fmt;
				/* it's the next argument */
				precision = va_arg(args, int);
			}
			if (precision < 0)
				precision = 0;
		}

		/* get the conversion qualifier */
		qualifier = -1;
		if (*fmt == 'h' || *fmt == 'l' || *fmt == 'L') {
			qualifier = *fmt;
			++fmt;
		}

		/* default base */
		base = 10;

		switch (*fmt) {
		case 'c':
			if (!(flags & LEFT))
				while (--field_width > 0)
					buflen++;
			buflen+= sizeof((unsigned char) va_arg(args, int));
			while (--field_width > 0)
				buflen++;
			continue;

		case 's':
			s = va_arg(args, char *);
			if (!s)
				s = "<NULL>";

			len = strnlen(s, precision);

			if (!(flags & LEFT))
				while (len < field_width--)
					buflen++;
			for (i = 0; i < len; ++i){
				buflen++;
				s++;
			}
			while (len < field_width--)
				buflen++;
			continue;

		case 'p':
			if (field_width == -1) {
				field_width = 2*sizeof(void *);
				flags |= ZEROPAD;
			}
			buflen += number(
				(unsigned long) va_arg(args, void *), 16,
				field_width, precision, flags);
			continue;


		case '%':
			buflen++;
			continue;

		/* integer number formats - set up the flags and "break" */
		case 'o':
			base = 8;
			break;

		case 'X':
			flags |= LARGE;
		case 'x':
			base = 16;
			break;

		case 'd':
		case 'i':
			flags |= SIGN;
		case 'u':
			break;

		default:
			buflen++;
			if (*fmt)
				buflen++;
			else
				--fmt;
			continue;
		}
		if (qualifier == 'l')
			num = va_arg(args, unsigned long);
		else if (qualifier == 'h') {
			num = (unsigned short) va_arg(args, int);
			if (flags & SIGN)
				num = (short) num;
		} else if (flags & SIGN)
			num = va_arg(args, int);
		else
			num = va_arg(args, unsigned int);
		buflen += number(num, base, field_width, precision, flags);
	}
	return buflen;
}
#endif


/* According to some recommendations, try not to exceed about 800 bytes 
   or you might have problems with old syslog implementations */
#define LOG_BUF_LEN 255

typedef struct _code {
        char    *c_name;
        int     c_val;
} CODE;

#ifdef HAVE_SYSLOG_H
static const CODE facilitynames[] ={
#ifdef LOG_AUTH
    {"auth",	LOG_AUTH},
#endif
#ifdef LOG_AUTHPRIV
    {"authpriv",LOG_AUTHPRIV},
#endif
#ifdef LOG_CRON
    {"cron", 	LOG_CRON},
#endif
#ifdef LOG_DAEMON
    {"daemon",	LOG_DAEMON},
#endif
#ifdef LOG_FTP
    {"ftp",	LOG_FTP},
#endif
#ifdef LOG_KERN
    {"kern",	LOG_KERN},
#endif
#ifdef LOG_LPR
    {"lpr",	LOG_LPR},
#endif
#ifdef LOG_MAIL
    {"mail",	LOG_MAIL},
#endif
#ifdef LOG_NEWS
    {"news",	LOG_NEWS},
#endif
#ifdef LOG_SYSLOG
    {"syslog",	LOG_SYSLOG},
#endif
#ifdef LOG_USER
    {"user",	LOG_USER},
#endif
#ifdef LOG_UUCP
    {"uucp",	LOG_UUCP},
#endif
#ifdef LOG_LOCAL0
    {"local0",	LOG_LOCAL0},
#endif
#ifdef LOG_LOCAL1
    {"local1",	LOG_LOCAL1},
#endif
#ifdef LOG_LOCAL2
    {"local2",	LOG_LOCAL2},
#endif
#ifdef LOG_LOCAL3
    {"local3",	LOG_LOCAL3},
#endif
#ifdef LOG_LOCAL4
    {"local4",	LOG_LOCAL4},
#endif
#ifdef LOG_LOCAL5
    {"local5",	LOG_LOCAL5},
#endif
#ifdef LOG_LOCAL6
    {"local6",	LOG_LOCAL6},
#endif
#ifdef LOG_LOCAL7
    {"local7",	LOG_LOCAL7},
#endif
    {NULL,		-1},
};
static int syslog_facility(char *f){
	const CODE *fn;
	fn=facilitynames;
	while (fn->c_name!=NULL){
		if (strcasecmp(f, fn->c_name)==0)
			return fn->c_val;
		fn++;
	}
	fprintf(stderr, "Config file error: unknown facility given: %s\n\r", f);
	fprintf(stderr, "Will continue with default facility\n\r");
	return LOG_FACILITY;
}

#endif /* HAVE_SYSLOG_H */


__INDLIB__ void UdmSetLogLevel(int level){
	LogLevel=level;
}

__INDLIB__ void UdmSetLogFacility(char * facility){
	if(!strcmp(facility,"")){
		LogFacility=LOG_FACILITY;
		return;
	}
#ifdef HAVE_SYSLOG_H
	LogFacility=syslog_facility(facility);
#endif
}



int UdmOpenLog(int log2stderr){
#if defined HAVE_SYSLOG_H && defined USE_SYSLOG
/* LOG_PERROR supported by 4.3BSD Reno releases and later */
#ifdef LOG_PERROR
    openlog("Indexer",(log2stderr)?LOG_PERROR|LOG_PID:LOG_PID,LogFacility);
#else
    openlog("Indexer",LOG_PID,LogFacility);
    if(log2stderr) error=stderr;
#endif /* LOG_PERROR */
#else
    /* If syslog not found or not used, use stderr. */
    if(log2stderr) error=stderr;
#endif /* HAVE_SYSLOG_H */
    is_log_open=1;return(0);
}



static int udm_logger(int handle,int level, const char *fmt, va_list ap){
char buf[LOG_BUF_LEN+1];

	if(LogLevel<level) return 0;

#if (WIN32|WINNT)
	_vsnprintf(buf,LOG_BUF_LEN,fmt,ap);
#ifdef _CONSOLE
	printf("%s\n",buf);
#else
	if(ThreadInfo)ThreadInfo(0,"",buf);
#endif
#else
#ifdef HAVE_VSNPRINTF
	vsnprintf(buf,LOG_BUF_LEN,fmt,ap);
#else
	if (udm_vsnprintf(fmt,ap)<LOG_BUF_LEN)
		vsprintf(buf,fmt,ap);
	else
		strcpy(buf,"Output buffer overflow - please try to increase LOG_BUF_LEN");
#endif /* HAVE VSNPRINTF */
#endif

#if defined HAVE_SYSLOG_H && defined USE_SYSLOG
	if(handle)
		syslog((level!=UDM_LOG_ERROR)?LOG_INFO:LOG_ERR,"[%d] %s",handle,buf);
	else
		syslog((level!=UDM_LOG_ERROR)?LOG_INFO:LOG_ERR,"%s",buf);
#endif
	if(error!=NULL) fprintf(error,"%s\n",buf); 
	return 1;
}



void UdmLog(int handle,int level, const char *fmt, ...){
	va_list ap;
#if (WIN32|WINNT)
#else
	if(is_log_open){
#endif
		va_start(ap,fmt);
		udm_logger(handle,level,fmt,ap);
		va_end(ap);
#if (WIN32|WINNT)
#else
	}else
		fprintf(stderr,"Log not opened\n");
#endif
	return;
}
