#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/types.h>
#include <ctype.h>

#include "udm_config.h"
#include "udmsearch.h"

#define NO_TITLE	"No title"
#define MAX_PS		100
#define DEFAULT_PS	20

#define T_STEP		100
#define T_UNKNOWN	 0
#define T_TOP		 1
#define T_BOT		 2
#define T_RESTOP	 3
#define T_RESBOT	 4
#define T_RESULT	 5
#define T_ERROR		 6
#define T_NOTFOUND	 7
#define T_CLONE		 8
#define T_NAVIGATOR	 9
#define T_NAVLEFT	10
#define T_NAVBAR0	11
#define T_NAVBAR1	12
#define T_NAVRIGHT	13
#define T_INCLUDE	14
#define T_MAX		15

static int lastt[T_MAX] = {
	0,
	T_TOP*T_STEP,
	T_BOT*T_STEP,
	T_RESTOP*T_STEP,
	T_RESBOT*T_STEP,
	T_RESULT*T_STEP,
	T_ERROR*T_STEP,	
	T_NOTFOUND*T_STEP,
	T_CLONE*T_STEP,
	T_NAVIGATOR*T_STEP,
	T_NAVLEFT*T_STEP,
	T_NAVBAR0*T_STEP,
	T_NAVBAR1*T_STEP,
	T_NAVRIGHT*T_STEP,
	T_INCLUDE*T_STEP
};
#define TEMPL(x)	(((lastt[x]-x*T_STEP)>format)?x*T_STEP+format:lastt[x]-1)

typedef struct var_struct{
	char *name;
	char *value;
} TVAR;

typedef struct template_struct{
	int where;
	char *str;
} TEMPLATE;

typedef struct dict_struct {
	char lang[3];
	char * path;
} DICT;

#define MAXTEMPLATE 1024
static TEMPLATE Template[MAXTEMPLATE];
static int ntempl=0;
static void * db;

#define MAXVARIABLE	32
TVAR Variables[MAXVARIABLE];
int nVar=0;

#define MAXRANDOM 128
int Randoms[MAXRANDOM];

#define MAXDICT 128
DICT Dict[MAXDICT];
int dict_num=0;

/* Template variables */
static char error[BUFSIZ]="";
static char wordinfo[UDMSTRSIZ]="";
static char href[UDMSTRSIZ]="";
static char fullhref[UDMSTRSIZ]="";
static char *query_form_escaped=NULL;
static char *query_url_escaped=NULL;
static char *crc=0;
static char self[UDMSTRSIZ]="";
static char *title=0;
static char *text=0;
static int  size=0;
static int  rating=0;
static char *descr=0;
static char *keywords=0;
static int  url_id,docnum,first=0,last=0,found=0;
static int num_pages=0, navpage=0, ps=0, pps=10,np=0,is_next=0;
static int format=0, use_clones=1;
static char *mode=NULL;
static char *sort=NULL;
static char *ul_unescaped=NULL;
static int LCharset=UDM_CHARSET_NO;
static int ttag=-1;

int AddVariable(char *name,char *value){
	if(nVar<MAXVARIABLE){
		Variables[nVar].name=strdup(name);
		Variables[nVar].value=strdup(value);
		nVar++;
		return(0);
	}
	return(1);
}

char LightWords[UDMSTRSIZ]="";
char * hilightcpy(char *dst,char *src, char *w_list, char *start,char *stop){
char *s,*t,*word;
char real_word[64]="";

	word=s=src;
	t=dst;*t=0;
	while(*s){
		if(!UdmWordChar(*s,LCharset)||!(*(s+1))){
			if(word<s){
				char save=0;
				if(*(s+1)){
					save=*s;
					*s=0;
				}
				real_word[0]=' ';
				strncpy(real_word+1,word,sizeof(real_word)-3);
				strcpy(real_word+strlen(real_word)," ");
				UdmTolower(real_word,LCharset);
				if(strstr(w_list,real_word)){
					sprintf(t,"%s%s%s",start,word,stop);
					t=t+strlen(t);
				}else{
					strcpy(t,word);
					t+=strlen(word);
				}
				if(*(s+1)){
					*s=save;
				}
			}
			if(*(s+1)){
				*t=*s;
				t++;
				*t=0;
			}
			word=s+1;
		}
		s++;
	}
	return(dst);
}


int LoadTemplate(char *name, char *query, int default_where){
FILE *file;
int where=0,variables=0;
char *s,*lasttok=NULL;
char str[BUFSIZ];
char first_letters[128]="";

	file=fopen(name,"r");
	if(!file)return(1);
	where=default_where;

	/* Init for the case when there is no  */
	/* LocalCharset definition in template */
	LCharset=UdmGetDefaultCharset();

	while((fgets(str,sizeof(str),file))&&(ntempl<MAXTEMPLATE)){
		if(!UDM_STRNCMP(str,"<!--top-->"))	where=lastt[T_TOP]++;
		else
		if(!UDM_STRNCMP(str,"<!--bottom-->"))	where=lastt[T_BOT]++;
		else
		if(!UDM_STRNCMP(str,"<!--restop-->"))	where=lastt[T_RESTOP]++;
		else
		if(!UDM_STRNCMP(str,"<!--resbot-->"))	where=lastt[T_RESBOT]++;
		else
		if(!UDM_STRNCMP(str,"<!--res-->"))	where=lastt[T_RESULT]++;
		else
		if(!UDM_STRNCMP(str,"<!--notfound-->"))	where=lastt[T_NOTFOUND]++;
		else
		if(!UDM_STRNCMP(str,"<!--error-->"))	where=lastt[T_ERROR]++;
		else
		if(!UDM_STRNCMP(str,"<!--clone-->"))	where=lastt[T_CLONE]++;
		else
		if(!UDM_STRNCMP(str,"<!--navigator-->"))where=lastt[T_NAVIGATOR]++;
		else
		if(!UDM_STRNCMP(str,"<!--navleft-->"))	where=lastt[T_NAVLEFT]++;
		else
		if(!UDM_STRNCMP(str,"<!--navbar1-->"))	where=lastt[T_NAVBAR1]++;
		else
		if(!UDM_STRNCMP(str,"<!--navbar0-->"))	where=lastt[T_NAVBAR0]++;
		else
		if(!UDM_STRNCMP(str,"<!--navright-->"))	where=lastt[T_NAVRIGHT]++;
		else
		if(!UDM_STRNCMP(str,"<!--/top-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/bottom-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/restop-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/resbot-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/res-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/notfound-->"))where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/error-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/clone-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--variables")){
			where=default_where;
			variables=1;
		}else
		if(!UDM_STRNCMP(str,"<!--/navigator-->"))where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/navleft-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/navbar1-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/navbar0-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/navright-->"))where=default_where;
		else
		if(!UDM_STRNCMP(str,"-->")){	
			if(variables){
				where=default_where;
				variables=0;
			}
		}else{
			Template[ntempl].where=where;
			Template[ntempl].str=strdup(str);
			ntempl++;
			if((variables)&&(s=UdmGetToken(str,"\r\n",&lasttok))){
				if(!UDM_STRNCASECMP(str,"DBAddr"))
					UdmSetDBAddr(UdmTrim(str+6,"= \t\r\n"));
				else
				if(!UDM_STRNCASECMP(str,"DBMode"))
					UdmSetDBMode(UdmTrim(str+6,"= \t\r\n"));
				else
				if(!UDM_STRNCASECMP(str,"DBHost"))
					DBHost=strdup(UdmTrim(str+6,"= \t\r\n"));
				else
				if(!UDM_STRNCASECMP(str,"DBName"))
					DBName=strdup(UdmTrim(str+6,"= \t\r\n"));
				else
				if(!UDM_STRNCASECMP(str,"DBUser"))
					DBUser=strdup(UdmTrim(str+6,"= \t\r\n"));
				else
				if(!UDM_STRNCASECMP(str,"DBPass"))
					DBPass=strdup(UdmTrim(str+6,"= \t\r\n"));
				else
				if(!UDM_STRNCASECMP(str,"DBPort"))
					DBPort=atoi(UdmTrim(str+6,"= \t\r\n"));
				else
				if(!UDM_STRNCASECMP(str,"ResultsPerPage"))
					ps=atoi(UdmTrim(str+14,"= \t\r\n"));
				else
				if(!UDM_STRNCASECMP(str,"PagesPerScreen"))
					pps=atoi(UdmTrim(str+14,"= \t\r\n"));
				else
				if(!UDM_STRNCASECMP(str,"Clones")){
					if(!UDM_STRNCASECMP(UdmTrim(str+6,"= \r\t\n"),"no"))
						use_clones=0;
					else
						use_clones=1;
				}else
				if(!UDM_STRNCASECMP(str,"IspellMode")){
					if(!UDM_STRNCASECMP(UdmTrim(str+10,"= \r\t\n"),"db")) 
					     ispell_mode=UDM_ISPELL_MODE_DB;
					else ispell_mode=UDM_ISPELL_MODE_TEXT;
				}else
				if(!UDM_STRNCASECMP(str,"LocalCharset")){
					LCharset=UdmGetCharset(UdmTrim(str+12,"= \r\t\n"));
					UdmSetDefaultCharset(LCharset);
				}else
				if(!UDM_STRNCASECMP(str,"R")){
					int i,j;
					float frand;
					i=atoi(str+1);
					s=str+1;
					while((*s)&&(isdigit(*s)))s++;
					j=atoi(UdmTrim(s,"= \t\r\n"));
					if((i>0)&&(i<MAXRANDOM)){
						frand=rand();
						frand=frand/RAND_MAX*j;
						Randoms[i]=frand;
					}
				}else
				if(!UDM_STRNCASECMP(str,"Affix")){
					char lang[20]="";char str1[UDMSTRSIZ]="";
					if((query) && (ispell_mode==UDM_ISPELL_MODE_TEXT))
					if(sscanf(str+5,"%s%s",lang,str1)){
						if(*str1=='/')strcpy(str,str1);
						else	sprintf(str,"%s/%s",UDM_CONF_DIR,str1);
						UdmImportAffixes(lang,str,NULL,0);
					}
				}else
				if(!UDM_STRNCASECMP(str,"Spell")){
					char lang[20]="";
					char str1[UDMSTRSIZ]="";
					if(ispell_mode==UDM_ISPELL_MODE_TEXT)
					if(sscanf(str+5,"%s%s",lang,str1)){
						if(*str1=='/')strcpy(str,str1);
						else	sprintf(str,"%s/%s",UDM_CONF_DIR,str1);
						strncpy(Dict[dict_num].lang,lang,2);
						Dict[dict_num].lang[2]=0;
						Dict[dict_num].path=strdup(str);
						dict_num++;
					}
				}
			}
		}
	}
	fclose(file);
	if(query){
		char *w, *lasttok;int i;
		/* If the query is specified we'll compose   */
		/* a string with first letters of every      */
		/* word It will allow fast Ispell dictionay  */
		/* loading we'll also compose string         */
		/* with light words and tolower query        */
		/* As far as search is case insencitive      */
		/* the first thing to do is lo-case query    */
	
		UdmTolower(query,LCharset);
		strcpy(str,query);
		w=UdmGetWord(str,&lasttok, LCharset);
		while(w){
			int len;
			/* Add first letter */
			len=strlen(first_letters);
			first_letters[len]=w[0];
			first_letters[len+1]=0;
			/* Make string with words to be hilighted */
			sprintf(UDM_STREND(LightWords)," %s ",w);
			w=UdmGetWord(NULL, &lasttok, LCharset);
		}
		
		if (ispell_mode == UDM_ISPELL_MODE_TEXT) {
		    for(i=0;i<dict_num;i++){
			    UdmImportDictionary(Dict[i].lang,Dict[i].path,1,first_letters);
			    free(Dict[i].path);
		    }
		    if(dict_num);
			UdmSortDictionary();
		}
	}
	return(0);
}

int PrintTemplate(char * Target,int where,char *url,char *content_type,char *last_modified);

static int PrintOneTemplate(char * Target,char *s,int where,char *url,char *content_type,char *last_modified){
UDM_DOCUMENT *r=NULL;
int rnum,tmp;
char notitle[]=NO_TITLE;

	*Target=0;
	while(*s){
		if((*s=='\\')&&(*(s+1)=='$')){
			sprintf(UDM_STREND(Target),"$");
			s+=2;
			continue;
		}
		if(*s!='$'){
			sprintf(UDM_STREND(Target),"%c",*s);
			s++;
			continue;
		}

		s++;
		switch(*s){
		case 'A': sprintf(UDM_STREND(Target),"%s",self);break;
		case 'Q': sprintf(UDM_STREND(Target),"%s",query_form_escaped?query_form_escaped:"");break;
		case 'q': sprintf(UDM_STREND(Target),"%s",query_url_escaped?query_url_escaped:"");break;
		case 'E': sprintf(UDM_STREND(Target),"%s",error);break;
		case 'W': sprintf(UDM_STREND(Target),"%s",wordinfo);break;
		case 'f': sprintf(UDM_STREND(Target),"%d",first);break;
		case 'l': sprintf(UDM_STREND(Target),"%d",last);break;
		case 't': sprintf(UDM_STREND(Target),"%d",found);break;
		case 'm': sprintf(UDM_STREND(Target),"%s",mode?mode:"all");break;
		case 's': sprintf(UDM_STREND(Target),"%s",sort?sort:"rate");break;
		case 'o': sprintf(UDM_STREND(Target),"%d",format);break;
		case 'g': {
			if(ttag!=-1)sprintf(UDM_STREND(Target),"%d",ttag);
			break;
		}

		case 'r': {
			s++;
			rnum=atoi(s);
			if((rnum>=0)&&(rnum<MAXRANDOM))
				sprintf(UDM_STREND(Target),"%d",Randoms[rnum]);
			while((*s)&&(isdigit(*(s+1))))
				s++;
			break;
		}
		case 'V': {
			if(num_pages>1)
				PrintTemplate(UDM_STREND(Target),TEMPL(T_NAVIGATOR),"","","");
			break;
		}
		case 'D':
			s++;
			switch(*s){
			case 'U':sprintf(UDM_STREND(Target),"%s",url?url:"");break;
			case 'C':sprintf(UDM_STREND(Target),"%s",content_type?content_type:"");break;
			case 'M':sprintf(UDM_STREND(Target),"%s",last_modified?last_modified:"");break;
			case 'R':sprintf(UDM_STREND(Target),"%d",rating);break;
			case 'S':sprintf(UDM_STREND(Target),"%d",size);break;
			case 'N':sprintf(UDM_STREND(Target),"%d",docnum);break;

			case 'D':hilightcpy(UDM_STREND(Target),descr    ,LightWords,"<b>","</b>");break;
			case 'T':hilightcpy(UDM_STREND(Target),title[0]?title:notitle,LightWords,"<b>","</b>");break;
			case 'K':hilightcpy(UDM_STREND(Target),keywords ,LightWords,"<b>","</b>");break;
			case 'X':hilightcpy(UDM_STREND(Target),text     ,LightWords,"<b>","</b>");break;

			default :sprintf(UDM_STREND(Target),"%c",*s);
			}
			break;

		case 'C':
			s++;
			switch(*s){
			case 'L':
			if((use_clones)&&(crc)&&(*crc)&&(where==T_RESULT)){
				if((r=UdmCloneList(db,crc))){
					while(r->url_id){
						if(r->url_id!=url_id)
						PrintTemplate(UDM_STREND(Target),TEMPL(T_CLONE),r->url,r->content_type,r->last_modified);
						r++;
					}
				}
			}
			break;
			default : sprintf(UDM_STREND(Target),"%c",*s);
			}
			break;
		case 'N':
			s++;
			switch(*s){
				case 'L':
				if (np > 0) {
					if(np>1)sprintf(fullhref,"%s&np=%d",href,np-1);
					else strcpy(fullhref,href);
					PrintTemplate(UDM_STREND(Target),TEMPL(T_NAVLEFT),"","","");
				}
				break;
				case 'B':
				for(navpage = 1; navpage <= num_pages;navpage++){
					tmp = np + 1 - pps/2;
					if (tmp < 1) tmp = 1;
					if (tmp > num_pages - pps + 1)
					tmp = num_pages - pps + 1;
					if (navpage >= tmp && navpage <(tmp+pps)){
						if(navpage>1)sprintf(fullhref,"%s&np=%d",href,navpage-1);
						else strcpy(fullhref,href);
						if (np == navpage-1)
						PrintTemplate(UDM_STREND(Target),TEMPL(T_NAVBAR0),"","","");
					else
						PrintTemplate(UDM_STREND(Target),TEMPL(T_NAVBAR1),"","","");
					}
				}
			break;
				case 'R':
				if (is_next) {
					sprintf(fullhref,"%s&np=%d",href,np+1);
					PrintTemplate(UDM_STREND(Target),TEMPL(T_NAVRIGHT),"","","");
				}
				break;
				case 'H': sprintf(UDM_STREND(Target),"%s",fullhref);break;
				case 'P': sprintf(UDM_STREND(Target),"%d",navpage);break;
			}
			break;
		case 'i':
		case 'I':
			if(!strncasecmp(s,"if(",3)){
				char *fname=s+3;
				
				if((s=strchr(s,')'))){
					char template[UDMSTRSIZ];
					*s=0;
					if(strlen(fname)>sizeof(template))
						fname[sizeof(template)-1]=0;
					sprintf(template,"%s%c%s", UDM_CONF_DIR,UDMSLASH,fname);
					if(LoadTemplate(template,"",lastt[T_INCLUDE])){
						sprintf(UDM_STREND(Target),"Unable to include '%s'",template);
					}else{
						PrintTemplate(UDM_STREND(Target),TEMPL(T_INCLUDE),"","","");
						lastt[T_INCLUDE]++;
					}
				}
			}else
			sprintf(UDM_STREND(Target),"%c",*s);
			break;
		default: 
			if(!strncmp(s,"ps",2)){
				sprintf(UDM_STREND(Target),"%d",ps?ps:DEFAULT_PS);				
				s++;
			}else
			if(!strncmp(s,"ul",2)){
				sprintf(UDM_STREND(Target),"%s",ul_unescaped?ul_unescaped:"");
				s++;
			}else
			sprintf(UDM_STREND(Target),"%c",*s);
		}
		s++;
	}
	return(0);
}

static int PrintOption(char * Target,int where,char * option){
UDM_TAG tag;
char *s;
int len;
char tmp[UDMSTRSIZ]="";

	if(!(s=strchr(option,'>'))){
		sprintf(UDM_STREND(Target),"%s",option);
		return(0);
	}
	len=s-option;
	s=strdup(option);
	s[len+1]=0;
	UdmParseTag(&tag,s);
	if(tag.selected&&tag.value){
		int i;
		char *value;
		PrintOneTemplate(tmp,option,where,"","","");
		UdmFreeTag(&tag);
		UdmParseTag(&tag,tmp);
		value=tag.selected?tag.selected:"";
		if(*value=='$'){
			for(i=0;i<nVar;i++){

				if(!strcmp(Variables[i].name,"ul")&&
					!strcmp(Variables[i].value,tag.value)){
					value=Variables[i].value;
					break;
				}
			}
		}
		sprintf(UDM_STREND(Target),"<OPTION VALUE=\"%s\"%s>",tag.value,
			strcmp(tag.value,value)?"":" SELECTED");
		PrintOneTemplate(UDM_STREND(Target),option+len+1,where,"","","");
	}else{	
		sprintf(UDM_STREND(Target),"%s",option);
	}
	UdmFreeTag(&tag);
	return(0);
}


int PrintTemplate(char * Target,int where,char *url,char *content_type,char *last_modified){
int i;
	*Target=0;
	for(i=0;i<ntempl;i++){
		char *s;
		if(Template[i].where!=where)continue;
		s=Template[i].str;
		while((*s==' '||*s=='\t'))
			s++;
		if(!UDM_STRNCASECMP(s,"<OPTION")){
			PrintOption(UDM_STREND(Target),where,s);
			continue;
		}
		PrintOneTemplate(UDM_STREND(Target),Template[i].str,where,url,content_type,last_modified);
	}
	return(0);
}

void InitRand(){
int i;
time_t tclock;
	tclock=time(0);
	srand(tclock);
	for(i=0;i<MAXRANDOM;i++)
		Randoms[i]=0;
}

int main(int argc, char **argv) {
char template[UDMSTRSIZ]="";
char query_string[UDMSTRSIZ]="";
char *query_words=NULL;
char ul_str[UDMSTRSIZ]="";
char Target[UDMSTRSIZ*16]="";
int sort_order=UDM_ORD_RATE;
int search_mode=UDM_MOD_ALL;
char *env,*lasttok,*token;
UDM_DOCUMENT * r=NULL;


	UdmInit(); /* Initialize library */
	
	/* Output Content-type if under HTTPD	*/
	/* Some servers do not pass QUERY_STRING*/
	/* if the query was empty, so check	*/
	/* REQUEST_METHOD as well to be safe    */

	if(getenv("QUERY_STRING")||getenv("REQUEST_METHOD")){
		printf("Content-type: text/html\r\n\r\n");
	}

	/* Determine self and template name */
	if((env=getenv("UDMSEARCH_TEMPLATE")))
		strcpy(template,env);

	if((env=getenv("QUERY_STRING"))){
		strcpy(query_string,env);
		if((env=getenv("REDIRECT_STATUS"))){

			/* Check Apache internal redirect  */
			/* via   "AddHandler" and "Action" */

			env=getenv("REDIRECT_URL");
			strcpy(self,env?env:"search.cgi");
			if(!template[0]){
				env=getenv("PATH_TRANSLATED");
				strcpy(template,env?env:"");
			}
		}else{
			/* CGI executed directly */

			env=getenv("SCRIPT_NAME");
			strcpy(self,env?env:"search.cgi");
			if(!template[0]){
				char *s;
				if(strcmp(UDM_CONF_DIR,".")){
					sprintf(template,"%s/%s", UDM_CONF_DIR,(s=strrchr(self,UDMSLASH))?(s+1):(self));
				}else{
					env=getenv("SCRIPT_FILENAME");
					strcpy(template,env?env:"search.cgi");
				}
				if((s=strrchr(template,'.'))){
					*s=0;strcat(template,".htm");
				}else{
					strcpy(template,"search.htm");
				}
			}
		}
	}else{
		/* Executed from command line     */
		/* or under server which do not   */
		/* pass an empty QUERY_STRING var */

		if(argv[1])
			sprintf(query_string,"q=%s",argv[1]);
		if(!template[0])
			sprintf(template,"%s/%s", UDM_CONF_DIR,"search.htm");
	}

	InitRand();
	
	/* Parse Query String */
	token=UdmGetToken(query_string,"&",&lasttok);
	while(token){
		if(!UDM_STRNCMP(token,"q=")){
			char str[UDMSTRSIZ]="";
			query_words=strdup(UdmUnescapeCGIQuery(str,token+2));
			query_url_escaped=strdup(UdmEscapeURL(str,query_words));
			query_form_escaped=UdmHtmlSpecialChars(query_words);
		}else
		if(!UDM_STRNCMP(token,"np=")){
			np=atoi(token+3);
		}else
		if(!UDM_STRNCMP(token,"o=")){
			format=atoi(token+2);
			if((format>99)||(format<0))
				format=0;
		}else
		if(!UDM_STRNCMP(token,"ps=")){
			ps=atoi(token+3);
			/* Extra safety          */
			/* Don not allow to pass */
			/* very big page sizes   */
			ps=(ps>MAX_PS)?ps=MAX_PS:ps;
		}else
		if(!UDM_STRNCMP(token,"ul=") && strlen(token) > 3){
			char str1[UDMSTRSIZ]="";
			char str[UDMSTRSIZ]="";
#ifdef HAVE_FILES
#undef USE_AUTO_WILD
#endif
#ifdef USE_AUTO_WILD
			sprintf(str1,"%%%s%%",UdmUnescapeCGIQuery(str,token+3));
#else
			sprintf(str1,"%s",UdmUnescapeCGIQuery(str,token+3));
#endif
			AddVariable("ul",str);
			UDM_FREE(ul_unescaped);
			ul_unescaped=strdup(str);
			UdmAddURLLimit(str1);
			sprintf(UDM_STREND(ul_str),"&ul=%s",token+3);
		}else
		if((!UDM_STRNCMP(token,"t="))&&(*(token+2))){
			UdmAddTagLimit(atoi(token+2));
			sprintf(UDM_STREND(ul_str),"&t=%s",token+2);
			ttag=atoi(token+2);
		}else
		if((!UDM_STRNCMP(token,"g="))&&(*(token+2))){
			UdmAddLangLimit(token+2);
			sprintf(UDM_STREND(ul_str),"&g=%s",token+2);
		}else
		if(!UDM_STRNCMP(token,"m=")){
			mode=token+2;
			if(!strcmp(mode,"all"))search_mode=UDM_MOD_ALL;
			if(!strcmp(mode,"any"))search_mode=UDM_MOD_ANY;
		}else
		if(!UDM_STRNCMP(token,"s=")){
			sort=token+2;
			if(!strcmp(sort,"date"))sort_order=UDM_ORD_DATE;
			if(!strcmp(sort,"rate"))sort_order=UDM_ORD_RATE;
		}
		token=UdmGetToken(NULL,"&",&lasttok);
	}

	ispell_mode=UDM_ISPELL_MODE_TEXT;
	if(LoadTemplate(template,query_words,0)){
		printf("<html><body>Can't open template file '%s'!</body></html>\n",template);
		return(0);
	}

	/* Print TOP and if no query BOTTOM */
	PrintTemplate(Target,TEMPL(T_TOP),"","","");
	printf("%s",Target);
	if(!query_words){
		PrintTemplate(Target,TEMPL(T_BOT),"","","");
		printf("%s",Target);
		exit(0);
	}

	/* Find */
	db=UdmAllocDB(UDM_OPEN_MODE_READ);
	if (ispell_mode==UDM_ISPELL_MODE_DB) {
	    if (UdmDBImportAffixes(db)) {
		strcpy(error,UdmDBErrorMsg(db));
		PrintTemplate(Target,TEMPL(T_ERROR),"","","");
		printf("%s",Target);
	
		UdmFreeDB(db);

		PrintTemplate(Target,TEMPL(T_BOT),"","","");
		printf("%s",Target);
		return(0);
	    }
	}
	
	if((r=UdmFind(db,query_words,np,ps?ps:DEFAULT_PS,search_mode,sort_order,wordinfo,&found))){
		UDM_DOCUMENT * r1;
	
		last=first=docnum=(ps?ps:DEFAULT_PS)*np+1;
		r1=r;while((++r1)->url_id)last++;
		num_pages = found/(ps?ps:DEFAULT_PS);
		is_next=last<found;
		if((ps?ps:DEFAULT_PS)*num_pages<found)num_pages++;			
		sprintf(href,"%s?q=%s",self,query_url_escaped);
		strcpy(UDM_STREND(href),ul_str);
		if(mode)sprintf(UDM_STREND(href),"&m=%s",mode);
		if(sort)sprintf(UDM_STREND(href),"&s=%s",sort);
		if(ps)sprintf(UDM_STREND(href),"&ps=%d",ps);
		if(format)sprintf(UDM_STREND(href),"&o=%d",format);

		/* Print RESTOP then all RES's */
		PrintTemplate(Target,TEMPL(T_RESTOP),"","","");
		printf("%s",Target);
		while(r->url_id){
			url_id=r->url_id;
			title=UdmHtmlSpecialChars(r->title?r->title:"");
			text=UdmHtmlSpecialChars(r->text?r->text:"");
			size=r->size;
			rating=r->rating;
			descr=UdmHtmlSpecialChars(r->description?r->description:"");
			keywords=UdmHtmlSpecialChars(r->keywords?r->keywords:"");
			crc=r->crc?r->crc:"";
			PrintTemplate(Target,TEMPL(T_RESULT),
				r->url?r->url:"",
				r->content_type?r->content_type:"",
				r->last_modified?r->last_modified:"");
			printf("%s",Target);
			UDM_FREE(title);
			UDM_FREE(text);
			UDM_FREE(descr);
			UDM_FREE(keywords);
			r++;docnum++;
		}
		/* Print RESBOT */
		PrintTemplate(Target,TEMPL(T_RESBOT),"","","");
		printf("%s",Target);
	}else{
		/* Check the reason of NOTFOUND */
		if(UdmDBErrorCode(db)){
			/* Opsss... error! We tried ...*/
			strcpy(error,UdmDBErrorMsg(db));
			PrintTemplate(Target,TEMPL(T_ERROR),"","","");
			printf("%s",Target);
		}else{
			PrintTemplate(Target,TEMPL(T_NOTFOUND),"","","");
			printf("%s",Target);
		}
	}
	UdmFreeDB(db);

	/* That' all, folks. Print the BOT */
	PrintTemplate(Target,TEMPL(T_BOT),"","","");
	printf("%s",Target);
	return(0);
}
