#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "udm_utils.h"

char * UdmTrim(char *p, char *delim){
int len;
	len = strlen(p);
	while ((len > 0) && strchr(delim, p[len - 1] )) {
		p[len - 1] = '\0';
		len--;
	}
	while((*p)&&(strchr(delim,*p)))p++;
	return(p);
}

char * UdmRTrim(char* p, char *delim){
int len;
	len = strlen(p);
	while ((len > 0) && strchr(delim, p[len - 1] )) {
		p[len - 1] = '\0';
		len--;
	}
	return(p);
}


/* strtok_r clone */
char * UdmGetToken(char *s, const char *delim, char **last)
{
    char *spanp;
    int c, sc;
    char *tok;

    if (s == NULL && (s = *last) == NULL)
	return NULL;

cont:
    c = *s++;
    for (spanp = (char *)delim; (sc = *spanp++) != 0; )
    {
	if (c == sc)
	{
	    goto cont;
	}
    }

    if (c == 0)		/* no non-delimiter characters */
    {
	*last = NULL;
	return NULL;
    }
    tok = s - 1;

    for (;;)
    {
	c = *s++;
	spanp = (char *)delim;
	do
	{
	    if ((sc = *spanp++) == c)
	    {
		if (c == 0)
		{
		    s = NULL;
		}
		else
		{
		    char *w = s - 1;
		    *w = '\0';
		}
		*last = s;
		return tok;
	    }
	}
	while (sc != 0);
    }
}



char * UdmHtmlSpecialChars(char *str){
char *pos, *p;
int len;
	if(!str)return(NULL);
	len = strlen(str)+1;
	for(pos = str; *pos; pos++){
		switch (*pos){
			case '&': len+=4; break;
			case '"': len+=5; break;
			case '<':
			case '>': len+=3; break;
		}
	}
	p = (char*) malloc(len+1);*p = 0;
	for(pos=p; *str; str++) {
	switch (*str){
		case '&': strcat(p, "&amp;"); pos+=5; break;
		case '"': strcat(p, "&quot;");pos+=6; break;
		case '<': strcat(p, "&lt;");pos+=4; break;
		case '>': strcat(p, "&gt;");pos+=4; break;
		default:
			*pos = *str;
			pos++;*pos=0;
		}
	}
	return p;
}

char * UdmUnescapeCGIQuery(char *d,char *s){
int hi,lo=0;
char *dd;
	if((d==NULL)||(s==NULL))return(0);
	dd=d;
	while(*s){
		if(*s=='%'){
			if(strchr("0123456789",*(++s))) hi=*s-'0';
			else hi=*s-'A'+10;
			if(strchr("0123456789",*(++s))) lo=*s-'0';
			else lo=*s-'A'+10;
			*d=hi*16+lo;
		}else
		if(*s=='+'){
			*d=' ';
		}else{
			*d=*s;
		}
		s++; d++;
	}
	*d=0;return(dd);
}

char * UdmEscapeURL(char *d,char *s){
char *dd;
	if((d==NULL)||(s==NULL))return(0);
	dd=d;
	while(*s){
		if(strchr("%&<>+[](){}/?#'\"\\;,",*s)){
			sprintf(d,"%%%x",(int)*s);
			*(d+1)=toupper(*(d+1));
			*(d+2)=toupper(*(d+2));
			d+=2;
		}else
		if(*s==' '){
			*d='+';
		}else{
			*d=*s;
		}
		s++;d++;
	}
	*d=0;
	return(dd);
}


/* Oh,no! We have to remove parent level like /parent/../index.html from path
   Let's do it recursively! */
char * UdmRemove2Dot(char *path){
    char *ptr;
    char *tail;
    
    if(!(ptr=strstr(path,"../"))) return path;
    if(ptr==path) return path; /* How could it be? */
    tail=ptr+2;
    ptr--;
    *ptr=0;
    if(!(ptr=strrchr(path,'/'))) *path=0; else *ptr=0;
    path=strcat(path,tail);
    return UdmRemove2Dot(path);
}
