/*****************************************************************
Copyright (c) 1999 Torben Weis <weis@kde.org>
Copyright (c) 2000 Matthias Ettrich <ettrich@kde.org>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <cstdlib>
#include <sstream>
#include <fstream>
#include <iostream>
#include <string>
#include <iterator>
#include <algorithm>

#include <stdio.h>

void stubberParse( const char *_code );

int idl_line_no;

#if YYDEBUG
extern int yydebug;
#endif

int main( int argc, char** argv )
{
    if (argc != 2)
    {
        fprintf(stderr, "Usage : %s input_file\n", argv[0]);
        return -1;
    }
    
    std::ifstream file( argv[1] );
    if (!file)
    {
        fprintf(stderr, "Can't open input file %s\n", argv[1]);
        return -1;
    }

    std::ostringstream arr;
#if 0 // TODO OpenBSD
    file.unsetf(std::ios_base::skipws);
    arr.unsetf(std::ios_base::skipws);
#endif

    std::istream_iterator<char> iit(file), eof_it;
    std::ostream_iterator<char> oit(arr);
    std::copy(iit, eof_it, oit);
    arr << '\0';

#if YYDEBUG
    char *debug = getenv("DEBUG");
    if (debug)
	yydebug = 1;
#endif
    idl_line_no = 1;

    printf("<!DOCTYPE DCOP-IDL><DCOP-IDL>\n");
    printf("<SOURCE>%s</SOURCE>\n", argv[1] );
    stubberParse(arr.str().data() );                            
    printf("</DCOP-IDL>\n");

    return 0;
}
