/***************************************************************************
                    ulxr_except.h  -  exception handling
                             -------------------
    begin                : Sun Mar 24 2002
    copyright            : (C) 2002-2006 by Ewald Arnold
    email                : ulxmlrpcpp@ewald-arnold.de

    $Id: ulxr_except.cpp,v 1.11 2006/02/23 18:06:34 ewald-arnold Exp $

 ***************************************************************************/

/**************************************************************************
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ***************************************************************************/

#include <ulxmlrpcpp/ulxmlrpcpp.h>  // always first header

#include <ulxmlrpcpp/ulxr_except.h>


namespace ulxr {

ULXR_EXPORT Exception::Exception(int fc, const CppString &s)
  :
#ifdef ULXR_USE_STD_EXCEPTION
   std::exception(),
#endif
   reason(s), faultcode(fc)
{
  ULXR_DOUT("=== Exception: " << s);
}


ULXR_EXPORT Exception::~Exception() throw()
{
}


CppString ULXR_EXPORT Exception::why() const
{
  return reason;
}


#ifdef ULXR_USE_STD_EXCEPTION

const char *ULXR_EXPORT Exception::what() const throw()
{
  what_helper = getLatin1(why());
  return what_helper.c_str();
}

#endif


int ULXR_EXPORT Exception::getFaultCode() const
{
  return faultcode;
}


/////////////////////////////////////////////////////////////////////////


ULXR_EXPORT ConnectionException::ConnectionException(int fc, const CppString &phrase, int stat)
  : Exception(fc, phrase)
  , status(stat)
{
}


ULXR_EXPORT ConnectionException::~ConnectionException() throw()
{
}


int ULXR_EXPORT ConnectionException::getStatusCode() const
{
  return status;
}


/////////////////////////////////////////////////////////////////////////


ULXR_EXPORT RuntimeException::RuntimeException(int fc, const CppString &s)
  : Exception(fc, s)
{
}


ULXR_EXPORT RuntimeException::~RuntimeException() throw()
{
}


/////////////////////////////////////////////////////////////////////////


ULXR_EXPORT XmlException::XmlException(int fc, const CppString &s, int l,
                                       const CppString &err)
  : Exception(fc, s), line(l), xmlerror(err)
{
}


ULXR_EXPORT XmlException::~XmlException() throw()
{
}


int ULXR_EXPORT XmlException::getErrorLine() const
{
  return line;
}


CppString ULXR_EXPORT XmlException::getErrorString() const
{
  return xmlerror;
}


/////////////////////////////////////////////////////////////////////////


ULXR_EXPORT ParameterException::ParameterException(int fc, const CppString &s)
  : Exception(fc, s)
{
}


ULXR_EXPORT ParameterException::~ParameterException()  throw()
{
}


/////////////////////////////////////////////////////////////////////////


ULXR_EXPORT MethodException::MethodException(int fc, const CppString &s)
  : Exception(fc, s)
{
}


ULXR_EXPORT MethodException::~MethodException()  throw()
{
}


}  // namespace ulxr
