/***************************************************************************
                 ulxr_response.cpp  -  create xml-rpc response
                             -------------------
    begin                : Sun Mar 10 2002
    copyright            : (C) 2002-2006 by Ewald Arnold
    email                : ulxmlrpcpp@ewald-arnold.de

    $Id: ulxr_response.cpp,v 1.25 2006/02/23 18:06:34 ewald-arnold Exp $

 ***************************************************************************/

/**************************************************************************
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ***************************************************************************/

//#define ULXR_SHOW_TRACE
//#define ULXR_DEBUG_OUTPUT
//#define ULXR_SHOW_READ
//#define ULXR_SHOW_WRITE

#include <ulxmlrpcpp/ulxmlrpcpp.h>  // always first header

#include <ulxmlrpcpp/ulxr_response.h>
#include <ulxmlrpcpp/ulxr_responseparse_wb.h>
#include <ulxmlrpcpp/ulxr_wbxmlparse.h>
#include <ulxmlrpcpp/ulxr_value.h>


namespace ulxr {


ULXR_EXPORT MethodResponse::MethodResponse()
  : wasOk(true)
{
}


ULXR_EXPORT MethodResponse::MethodResponse (const Void & /*val*/)
  : wasOk(true)
{
}


ULXR_EXPORT MethodResponse::MethodResponse(int fval, const CppString &fstr)

{
  setFault(fval, fstr);
}


ULXR_EXPORT MethodResponse::MethodResponse (const Value &val)
{
  setResult (val);
}


ULXR_EXPORT MethodResponse::~MethodResponse()
{
}


bool ULXR_EXPORT MethodResponse::isOK() const
{
  return wasOk;
}


void ULXR_EXPORT MethodResponse::setFault(int fval, const CppString &fstr)
{
  ULXR_TRACE(ULXR_PCHAR("setFault"));
  wasOk = false;
  Struct st;
  st.addMember(ULXR_PCHAR("faultCode"), Integer(fval));
  st.addMember(ULXR_PCHAR("faultString"), RpcString(fstr));
  respval = st;
}


void ULXR_EXPORT MethodResponse::setResult (const Value &val)
{
  ULXR_TRACE(ULXR_PCHAR("setResult"));
  wasOk = true;
  respval = val;
}


const Value& ULXR_EXPORT MethodResponse::getResult() const
{
  return respval;
}


CppString ULXR_EXPORT MethodResponse::getSignature(bool deep) const
{
  return respval.getSignature(deep);
}


CppString ULXR_EXPORT MethodResponse::getXml(int indent) const
{
  CppString ind (indent, ' ');
  CppString s = ULXR_PCHAR("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
  s += ind + ULXR_PCHAR("<methodResponse>\n");
  if (wasOk)
  {
    s += ind + ULXR_PCHAR(" <params>\n");
    if (!respval.isVoid())
    {
      s += ind + ULXR_PCHAR("  <param>\n");
      s += respval.getXml(indent+3) + ULXR_PCHAR("\n");
      s += ind + ULXR_PCHAR("  </param>\n");
    }
    s += ind + ULXR_PCHAR(" </params>\n");
  }
  else
  {
    s += ind + ULXR_PCHAR(" <fault>\n");
    s += respval.getXml(indent+2) + ULXR_PCHAR("\n");
    s += ind + ULXR_PCHAR(" </fault>\n");
  }
  s += ind + ULXR_PCHAR("</methodResponse>");
  return s;
}


std::string ULXR_EXPORT MethodResponse::getWbXml() const
{
  std::string s;
  s.assign(WbXmlParser::wbxml_START_SEQ_STR, WbXmlParser::wbxml_START_SEQ_LEN);
  s += MethodResponseParserWb::wbToken_MethodResponse;
  if (wasOk)
  {
    s += MethodResponseParserWb::wbToken_Params;
    if (!respval.isVoid())
    {
      s += MethodResponseParserWb::wbToken_Param;
      s += respval.getWbXml();
      s += WbXmlParser::wbxml_END;
    }
    s += WbXmlParser::wbxml_END;
  }
  else
  {
    s += MethodResponseParserWb::wbToken_Fault;
    s += respval.getWbXml();
    s += WbXmlParser::wbxml_END;
  }
  s += WbXmlParser::wbxml_END;
  return s;
}


}  // namespace ulxr

