/**************************************************************************
                   ulxr_xmlparse_base.cpp  -  parse xml files
                             -------------------
    begin                : Fri Jan 09 2004
    copyright            : (C) 2002-2006 by Ewald Arnold
    email                : ulxmlrpcpp@ewald-arnold.de

    $Id: ulxr_xmlparse_base.cpp,v 1.12 2006/02/23 18:06:34 ewald-arnold Exp $

 ***************************************************************************/

/**************************************************************************
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ***************************************************************************/

#include <ulxmlrpcpp/ulxmlrpcpp.h>

#include <ulxmlrpcpp/ulxr_xmlparse_base.h>


namespace ulxr {


ULXR_EXPORT XmlParserBase::XmlParserBase()
{
  ULXR_TRACE(ULXR_PCHAR("XmlParserBase::XmlParserBase()"));
  complete = false;
}


ULXR_EXPORT XmlParserBase::~XmlParserBase()
{
}


void ULXR_EXPORT XmlParserBase::clearStates()
{
  while (!states.empty())
  {
    delete states.top();
    states.pop();
  }
}

bool ULXR_EXPORT XmlParserBase::isComplete() const
{
  return complete;
}


void ULXR_EXPORT XmlParserBase::setComplete(bool comp)
{
  complete = comp;
}


//////////////////////////////////////////////////////////////////////////
//

ULXR_EXPORT XmlParserBase::ParserState::ParserState (unsigned st)
  : state(st)
  , prevstate(eUnknown)
{
}


ULXR_EXPORT XmlParserBase::ParserState::~ParserState()
{
}


unsigned ULXR_EXPORT XmlParserBase::ParserState::getParserState() const
{
  return state;
}


unsigned ULXR_EXPORT XmlParserBase::ParserState::getPrevParserState() const
{
  return prevstate;
}


void ULXR_EXPORT XmlParserBase::ParserState::setPrevParserState(unsigned prev)
{
  prevstate = prev;
}


CppString ULXR_EXPORT XmlParserBase::ParserState::getStateName() const
{
  return ULXR_PCHAR("eUnknown");
}


void ULXR_EXPORT XmlParserBase::ParserState::appendCharData(const std::string &/*s*/)
{
  ULXR_TRACE(ULXR_PCHAR("XmlParserBase::ParserState::appendCharData(const std::string &)"));
#ifdef ULXR_UNICODE
#else
#endif
}


void ULXR_EXPORT XmlParserBase::ParserState::appendCharData(const XML_Char *s, int len)
{
  ULXR_TRACE(ULXR_PCHAR("XmlParserBase::ParserState::appendCharData(const XML_Char *, int)"));
#ifdef ULXR_UNICODE
  cdata += utf8ToUnicode(Cpp8BitString(s, len));
#else
  cdata.append(s, len);
#endif
}


CppString ULXR_EXPORT XmlParserBase::ParserState::getCharData() const
{
  ULXR_TRACE(ULXR_PCHAR("XmlParserBase::ParserState::getCharData()"));
  return cdata;
}


}  // namespace ulxr

