/***************************************************************************
               ulxr_callparse_wb.h  -  parse wbxml-rpc method call
                             -------------------
    begin                : Fri Jan 09 2004
    copyright            : (C) 2002-2006 by Ewald Arnold
    email                : ulxmlrpcpp@ewald-arnold.de

    $Id: ulxr_callparse_wb.h,v 1.10 2006/02/23 18:06:34 ewald-arnold Exp $

 ***************************************************************************/

/**************************************************************************
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ***************************************************************************/

#ifndef ULXR_CALLPARSE_WB_H
#define ULXR_CALLPARSE_WB_H

#include <ulxmlrpcpp/ulxmlrpcpp.h>  // always first header

#include <ulxmlrpcpp/ulxr_callparse_base.h>
#include <ulxmlrpcpp/ulxr_valueparse_wb.h>


namespace ulxr {


/** An wbxml parser for a MethodCall.
  * @ingroup grp_ulxr_parser
  */
class ULXR_EXPORT MethodCallParserWb : public ValueParserWb,
                                       public MethodCallParserBase
{
 public:

   enum CallWellKnownToken
   {
     wbToken_MethodCall = ValueParserWb::wbToken_ValueParserLast, // 0x52
     wbToken_MethodName,                                          // 0x53
     wbToken_Params,                                              // 0x54
     wbToken_Param,                                               // 0x55
     wbToken_CallParserLast                                       // 0x56
   };

 protected:

 /** Tests if the current opening tag is to be parsed by this
   * inheritance level or by the parent.
   * @param  token  current well known token
   * @param  attr   tag attributes
   * @return true: element has been handled
   */
   bool testStartElement(unsigned token, const Attributes &attr);

 /** C++ callback for an opening XML tag.
   * @param  token  current well known token
   * @param  attr   tag attributes
   */
   virtual void startElement(unsigned token, const Attributes &attr);

 /** C++ callback for a closing XML tag.
   * @return true: element has been handled
   */
   bool testEndElement();

 /** C++ callback for a closing XML tag.
   */
   virtual void endElement();
};


}  // namespace ulxr


#endif // ULXR_CALLPARSE_WB_H
