/* Table for converting KSC-5601 characters to UTF-16 characters.
   Generated automatically and edited by Bang Jun-Young, 2000.

   This table is in public domain and may be used for any purpose. */

/* NOTE: KSC-5601 has been replaced by the new standard KSX-1001 which 
   defines the same character sets.  However, the name of KSX-1001 isn't
   popular as much as KSC-5601, so I've decided to keep the old name. */

const unsigned short ksc5601_utf16_table[8742] = {
	/* Miscellaneous characters including general puctuation, arrows, 
	   dingbats, mathematical operators, etc. */
	0x3000, 0x3001, 0x3002, 0x00B7, 0x2025, 0x2026, 0x00A8, 0x3003,
	0x00AD, 0x2015, 0x2225, 0xFF3C, 0x223C, 0x2018, 0x2019, 0x201C,
	0x201D, 0x3014, 0x3015, 0x3008, 0x3009, 0x300A, 0x300B, 0x300C,
	0x300D, 0x300E, 0x300F, 0x3010, 0x3011, 0x00B1, 0x00D7, 0x00F7,
	0x2260, 0x2264, 0x2265, 0x221E, 0x2234, 0x00B0, 0x2032, 0x2033,
	0x2103, 0x212B, 0xFFE0, 0xFFE1, 0xFFE5, 0x2642, 0x2640, 0x2220,
	0x22A5, 0x2312, 0x2202, 0x2207, 0x2261, 0x2252, 0x00A7, 0x203B,
	0x2606, 0x2605, 0x25CB, 0x25CF, 0x25CE, 0x25C7, 0x25C6, 0x25A1,
	0x25A0, 0x25B3, 0x25B2, 0x25BD, 0x25BC, 0x2192, 0x2190, 0x2191,
	0x2193, 0x2194, 0x3013, 0x226A, 0x226B, 0x221A, 0x223D, 0x221D,
	0x2235, 0x222B, 0x222C, 0x2208, 0x220B, 0x2286, 0x2287, 0x2282,
	0x2283, 0x222A, 0x2229, 0x2227, 0x2228, 0xFFE2,

	/* Miscellaneous characters including general puctuation, arrows, 
	   dingbats, musical symbols, etc. */
	0x21D2, 0x21D4, 0x2200, 0x2203, 0x00B4, 0xFF5E, 0x02C7, 0x02D8,
	0x02DD, 0x02DA, 0x02D9, 0x00B8, 0x02DB, 0x00A1, 0x00BF, 0x02D0,
	0x222E, 0x2211, 0x220F, 0x00A4, 0x2109, 0x2030, 0x25C1, 0x25C0,
	0x25B7, 0x25B6, 0x2664, 0x2660, 0x2661, 0x2665, 0x2667, 0x2663,
	0x2299, 0x25C8, 0x25A3, 0x25D0, 0x25D1, 0x2592, 0x25A4, 0x25A5,
	0x25A8, 0x25A7, 0x25A6, 0x25A9, 0x2668, 0x260F, 0x260E, 0x261C,
	0x261E, 0x00B6, 0x2020, 0x2021, 0x2195, 0x2197, 0x2199, 0x2196,
	0x2198, 0x266D, 0x2669, 0x266A, 0x266C, 0x327F, 0x321C, 0x2116,
	0x33C7, 0x2122, 0x33C2, 0x33D8, 0x2121, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,

#if 1
	/* 94 fullwidth ASCII characters. Note that in Unicode the 
	   currency symbol ("Won") doesn't replace backslash any more
	   and has its own place at 0x20a9. */
	0xFF01, 0xFF02, 0xFF03, 0xFF04, 0xFF05, 0xFF06, 0xFF07, 0xFF08,
	0xFF09, 0xFF0A, 0xFF0B, 0xFF0C, 0xFF0D, 0xFF0E, 0xFF0F, 0xFF10,
	0xFF11, 0xFF12, 0xFF13, 0xFF14, 0xFF15, 0xFF16, 0xFF17, 0xFF18,
	0xFF19, 0xFF1A, 0xFF1B, 0xFF1C, 0xFF1D, 0xFF1E, 0xFF1F, 0xFF20,
	0xFF21, 0xFF22, 0xFF23, 0xFF24, 0xFF25, 0xFF26, 0xFF27, 0xFF28,
	0xFF29, 0xFF2A, 0xFF2B, 0xFF2C, 0xFF2D, 0xFF2E, 0xFF2F, 0xFF30,
	0xFF31, 0xFF32, 0xFF33, 0xFF34, 0xFF35, 0xFF36, 0xFF37, 0xFF38,
	0xFF39, 0xFF3A, 0xFF3B, 0x20A9, 0xFF3D, 0xFF3E, 0xFF3F, 0xFF40,
	0xFF41, 0xFF42, 0xFF43, 0xFF44, 0xFF45, 0xFF46, 0xFF47, 0xFF48,
	0xFF49, 0xFF4A, 0xFF4B, 0xFF4C, 0xFF4D, 0xFF4E, 0xFF4F, 0xFF50,
	0xFF51, 0xFF52, 0xFF53, 0xFF54, 0xFF55, 0xFF56, 0xFF57, 0xFF58,
	0xFF59, 0xFF5A, 0xFF5B, 0xFF5C, 0xFF5D, 0xFFE3,
#else
	/* Basic Latin. */
	0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 0x0028,
	0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 0x0030,
	0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
	0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 0x0040,
	0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048,
	0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050,
	0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058,
	0x0059, 0x005a, 0x005b, 0x20a9, 0x005d, 0x005e, 0x005f, 0x0060,
	0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068,
	0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070,
	0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078,
	0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, 	
#endif

	/* 94 Hangul Jamo. */
	0x3131, 0x3132, 0x3133, 0x3134, 0x3135, 0x3136, 0x3137, 0x3138,
	0x3139, 0x313a, 0x313b, 0x313c, 0x313d, 0x313e, 0x313f, 0x3140,
	0x3141, 0x3142, 0x3143, 0x3144, 0x3145, 0x3146, 0x3147, 0x3148,
	0x3149, 0x314a, 0x314b, 0x314c, 0x314d, 0x314e, 0x314f, 0x3150,
	0x3151, 0x3152, 0x3153, 0x3154, 0x3155, 0x3156, 0x3157, 0x3158,
	0x3159, 0x315a, 0x315b, 0x315c, 0x315d, 0x315e, 0x315f, 0x3160,
	0x3161, 0x3162, 0x3163, 0x3164, 0x3165, 0x3166, 0x3167, 0x3168,
	0x3169, 0x316a, 0x316b, 0x316c, 0x316d, 0x316e, 0x316f, 0x3170,
	0x3171, 0x3172, 0x3173, 0x3174, 0x3175, 0x3176, 0x3177, 0x3178,
	0x3179, 0x317a, 0x317b, 0x317c, 0x317d, 0x317e, 0x317f, 0x3180,
	0x3181, 0x3182, 0x3183, 0x3184, 0x3185, 0x3186, 0x3187, 0x3188,
	0x3189, 0x318a, 0x318b, 0x318c, 0x318d, 0x318e, 

	/* 10 small Roman numbers. */
	0x2170, 0x2171, 0x2172, 0x2173, 0x2174, 0x2175, 0x2176, 0x2177,
	0x2178, 0x2179, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* 10 Roman numbers. */
								0x2160,
	0x2161, 0x2162, 0x2163, 0x2164, 0x2165, 0x2166, 0x2167, 0x2168,
	0x2169, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* 24 Greek capital letters. */
	0x0391, 0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 0x0397, 0x0398,
	0x0399, 0x039a, 0x039b, 0x039c, 0x039d, 0x039e, 0x039f, 0x03a0,
	0x03a1, 0x03a3, 0x03a4, 0x03a5, 0x03a6, 0x03a7, 0x03a8, 0x03a9,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* 24 Greek small letters. */
	0x03b1, 0x03b2, 0x03b3, 0x03b4, 0x03b5, 0x03b6, 0x03b7, 0x03b8,
	0x03b9, 0x03ba, 0x03bb, 0x03bc, 0x03bd, 0x03be, 0x03bf, 0x03c0,
	0x03c1, 0x03c3, 0x03c4, 0x03c5, 0x03c6, 0x03c7, 0x03c8, 0x03c9,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 

	/* Box drawing characters. */
	0x2500, 0x2502, 0x250C, 0x2510, 0x2518, 0x2514, 0x251C, 0x252C,
	0x2524, 0x2534, 0x253C, 0x2501, 0x2503, 0x250F, 0x2513, 0x251B,
	0x2517, 0x2523, 0x2533, 0x252B, 0x253B, 0x254B, 0x2520, 0x252F,
	0x2528, 0x2537, 0x253F, 0x251D, 0x2530, 0x2525, 0x2538, 0x2542,
	0x2512, 0x2511, 0x251A, 0x2519, 0x2516, 0x2515, 0x250E, 0x250D,
	0x251E, 0x251F, 0x2521, 0x2522, 0x2526, 0x2527, 0x2529, 0x252A,
	0x252D, 0x252E, 0x2531, 0x2532, 0x2535, 0x2536, 0x2539, 0x253A,
	0x253D, 0x253E, 0x2540, 0x2541, 0x2543, 0x2544, 0x2545, 0x2546,
	0x2547, 0x2548, 0x2549, 0x254A, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,

	/* Units of measurement. */
	0x3395, 0x3396, 0x3397, 0x2113, 0x3398, 0x33c4, 0x33a3, 0x33a4,
	0x33a5, 0x33a6, 0x3399, 0x339a, 0x339b, 0x339c, 0x339d, 0x339e,
	0x339f, 0x33a0, 0x33a1, 0x33a2, 0x33ca, 0x338d, 0x338e, 0x338f,
	0x33cf, 0x3388, 0x3389, 0x33c8, 0x33a7, 0x33a8, 0x33b0, 0x33b1,
	0x33b2, 0x33b3, 0x33b4, 0x33b5, 0x33b6, 0x33b7, 0x33b8, 0x33b9,
	0x3380, 0x3381, 0x3382, 0x3383, 0x3384, 0x33ba, 0x33bb, 0x33bc,
	0x33bd, 0x33be, 0x33bf, 0x3390, 0x3391, 0x3392, 0x3393, 0x3394,
	0x2126, 0x33c0, 0x33c1, 0x338a, 0x338b, 0x338c, 0x33d6, 0x33c5,
	0x33ad, 0x33ae, 0x33af, 0x33db, 0x33a9, 0x33aa, 0x33ab, 0x33ac,
	0x33dd, 0x33d0, 0x33d3, 0x33c3, 0x33c9, 0x33dc, 0x33c6, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 

	/* Latin capital letters. */
	0x00C6, 0x00D0, 0x00AA, 0x0126, 0x0000, 0x0132, 0x0000, 0x013F, 
	0x0141, 0x00D8,	0x0152, 0x00BA, 0x00DE, 0x0166, 0x014A, 0x0000,
	/* Circled Hangul Jaum. */
	0x3260, 0x3261, 0x3262, 0x3263, 0x3264, 0x3265, 0x3266, 0x3267,
	0x3268, 0x3269, 0x326a, 0x326b, 0x326c, 0x326d, 
	/* Circled Hangul syllables. */
							0x326e, 0x326f,
	0x3270, 0x3271, 0x3272, 0x3273, 0x3274, 0x3275, 0x3276, 0x3277,
	0x3278, 0x3279, 0x327a, 0x327b,
	/* Circled Latin small letters. */
					0x24d0, 0x24d1, 0x24d2, 0x24d3, 
	0x24d4, 0x24d5, 0x24d6, 0x24d7,	0x24d8, 0x24d9, 0x24da, 0x24db, 
	0x24dc, 0x24dd, 0x24de, 0x24df,	0x24e0, 0x24e1, 0x24e2, 0x24e3, 
	0x24e4, 0x24e5, 0x24e6, 0x24e7,	0x24e8, 0x24e9,
	/* Circled numbers. */
							0x2460, 0x2461, 
	0x2462, 0x2463, 0x2464, 0x2465,	0x2466, 0x2467, 0x2468, 0x2469, 
	0x246a, 0x246b, 0x246c, 0x246d,	0x246e, 
	/* Fractions. */
						0x00bd, 0x2153, 0x2154, 
	0x00bc, 0x00be, 0x215b, 0x215c,	0x215d, 0x215e, 

	/* Latin small letters. */
	0x00E6, 0x0111, 0x00F0, 0x0127, 0x0131, 0x0133, 0x0138, 0x0140,
	0x0142, 0x00F8, 0x0153, 0x00DF, 0x00FE, 0x0167, 0x014B, 0x0149,
	/* Parenthesized Hangul Jaum. */
	0x3200, 0x3201, 0x3202, 0x3203, 0x3204, 0x3205, 0x3206, 0x3207,
	0x3208, 0x3209, 0x320a, 0x320b, 0x320c, 0x320d, 
	/* Parenthesized Hangul syllables. */
							0x320e, 0x320f,
	0x3210, 0x3211, 0x3212, 0x3213, 0x3214, 0x3215, 0x3216, 0x3217,
	0x3218, 0x3219, 0x321a, 0x321b,
	/* Parenthesized Latin small letters. */
					0x249c, 0x249d, 0x249e, 0x249f, 
	0x24a0, 0x24a1, 0x24a2, 0x24a3,	0x24a4, 0x24a5, 0x24a6, 0x24a7, 
	0x24a8, 0x24a9, 0x24aa, 0x24ab,	0x24ac, 0x24ad, 0x24ae, 0x24af, 
	0x24b0, 0x24b1, 0x24b2, 0x24b3,	0x24b4, 0x24b5,	
	/* Parenthesized numbers. */
	                				0x2474, 0x2475, 
	0x2476, 0x2477, 0x2478, 0x2479,	0x247a, 0x247b, 0x247c, 0x247d, 
	0x247e, 0x247f, 0x2480, 0x2481,	0x2482, 
	/* Superscripts. */
						0x00b9, 0x00b2, 0x00b3, 
	0x2074, 0x207f,
	/* Subscripts. */
			0x2081, 0x2082, 0x2083, 0x2084,

	/* Hiragana. */
	0x3041, 0x3042, 0x3043, 0x3044, 0x3045, 0x3046, 0x3047, 0x3048, 
	0x3049, 0x304a, 0x304b, 0x304c, 0x304d, 0x304e, 0x304f, 0x3050, 
	0x3051, 0x3052, 0x3053, 0x3054, 0x3055, 0x3056, 0x3057, 0x3058, 
	0x3059, 0x305a, 0x305b, 0x305c, 0x305d, 0x305e, 0x305f, 0x3060, 
	0x3061, 0x3062, 0x3063, 0x3064, 0x3065, 0x3066, 0x3067, 0x3068, 
	0x3069, 0x306a, 0x306b, 0x306c, 0x306d, 0x306e, 0x306f, 0x3070, 
	0x3071, 0x3072, 0x3073, 0x3074, 0x3075, 0x3076, 0x3077, 0x3078, 
	0x3079, 0x307a, 0x307b, 0x307c, 0x307d, 0x307e, 0x307f, 0x3080, 
	0x3081, 0x3082, 0x3083, 0x3084, 0x3085, 0x3086, 0x3087, 0x3088, 
	0x3089, 0x308a, 0x308b, 0x308c, 0x308d, 0x308e, 0x308f, 0x3090, 
	0x3091, 0x3092, 0x3093, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 

	/* Katakana. */
	0x30a1, 0x30a2, 0x30a3, 0x30a4, 0x30a5, 0x30a6, 0x30a7, 0x30a8, 
	0x30a9, 0x30aa, 0x30ab, 0x30ac, 0x30ad, 0x30ae, 0x30af, 0x30b0, 
	0x30b1, 0x30b2, 0x30b3, 0x30b4, 0x30b5, 0x30b6, 0x30b7, 0x30b8, 
	0x30b9, 0x30ba, 0x30bb, 0x30bc, 0x30bd, 0x30be, 0x30bf, 0x30c0, 
	0x30c1, 0x30c2, 0x30c3, 0x30c4, 0x30c5, 0x30c6, 0x30c7, 0x30c8, 
	0x30c9, 0x30ca, 0x30cb, 0x30cc, 0x30cd, 0x30ce, 0x30cf, 0x30d0, 
	0x30d1, 0x30d2, 0x30d3, 0x30d4, 0x30d5, 0x30d6, 0x30d7, 0x30d8, 
	0x30d9, 0x30da, 0x30db, 0x30dc, 0x30dd, 0x30de, 0x30df, 0x30e0, 
	0x30e1, 0x30e2, 0x30e3, 0x30e4, 0x30e5, 0x30e6, 0x30e7, 0x30e8, 
	0x30e9, 0x30ea, 0x30eb, 0x30ec, 0x30ed, 0x30ee, 0x30ef, 0x30f0, 
	0x30f1, 0x30f2, 0x30f3, 0x30f4, 0x30f5, 0x30f6, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 

	/* Cyrillic upper case letters. */
	0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0401, 0x0416,
	0x0417, 0x0418, 0x0419, 0x041a, 0x041b, 0x041c, 0x041d, 0x041e,
	0x041f, 0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426,
	0x0427, 0x0428, 0x0429, 0x042a, 0x042b, 0x042c, 0x042d, 0x042e,
	0x042f, 0x0000,	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* Cyrillic lower case letters. */		
	0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0451, 0x0436,
	0x0437, 0x0438, 0x0439, 0x043a, 0x043b, 0x043c, 0x043d, 0x043e,
	0x043f, 0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446,
	0x0447, 0x0448, 0x0449, 0x044a, 0x044b, 0x044c, 0x044d, 0x044e,
	0x044f, 0x0000,	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 

	/* Undefined. */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 

	/* Undefined. */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 

	/* Undefined. */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 

	/* 2350 (= 94 * 25) Hangul syllables. There's no unified way to 
	   convert Unicode Hangul characters undefined in KSC-5601 to 
	   KSC-5601 characters. */
	0xac00, 0xac01, 0xac04, 0xac07, 0xac08, 0xac09, 0xac0a, 0xac10,
	0xac11, 0xac12, 0xac13, 0xac14, 0xac15, 0xac16, 0xac17, 0xac19,
	0xac1a, 0xac1b, 0xac1c, 0xac1d, 0xac20, 0xac24, 0xac2c, 0xac2d,
	0xac2f, 0xac30, 0xac31, 0xac38, 0xac39, 0xac3c, 0xac40, 0xac4b,
	0xac4d, 0xac54, 0xac58, 0xac5c, 0xac70, 0xac71, 0xac74, 0xac77,
	0xac78, 0xac7a, 0xac80, 0xac81, 0xac83, 0xac84, 0xac85, 0xac86,
	0xac89, 0xac8a, 0xac8b, 0xac8c, 0xac90, 0xac94, 0xac9c, 0xac9d,
	0xac9f, 0xaca0, 0xaca1, 0xaca8, 0xaca9, 0xacaa, 0xacac, 0xacaf,
	0xacb0, 0xacb8, 0xacb9, 0xacbb, 0xacbc, 0xacbd, 0xacc1, 0xacc4,
	0xacc8, 0xaccc, 0xacd5, 0xacd7, 0xace0, 0xace1, 0xace4, 0xace7,
	0xace8, 0xacea, 0xacec, 0xacef, 0xacf0, 0xacf1, 0xacf3, 0xacf5,
	0xacf6, 0xacfc, 0xacfd, 0xad00, 0xad04, 0xad06, 

	0xad0c, 0xad0d,	0xad0f, 0xad11, 0xad18, 0xad1c, 0xad20, 0xad29, 
	0xad2c, 0xad2d,	0xad34, 0xad35, 0xad38, 0xad3c, 0xad44, 0xad45, 
	0xad47, 0xad49,	0xad50, 0xad54, 0xad58, 0xad61, 0xad63, 0xad6c, 
	0xad6d, 0xad70,	0xad73, 0xad74, 0xad75, 0xad76, 0xad7b, 0xad7c, 
	0xad7d, 0xad7f,	0xad81, 0xad82, 0xad88, 0xad89, 0xad8c, 0xad90, 
	0xad9c, 0xad9d,	0xada4, 0xadb7, 0xadc0, 0xadc1, 0xadc4, 0xadc8, 
	0xadd0, 0xadd1,	0xadd3, 0xaddc, 0xade0, 0xade4, 0xadf8, 0xadf9, 
	0xadfc, 0xadff,	0xae00, 0xae01, 0xae08, 0xae09, 0xae0b, 0xae0d, 
	0xae14, 0xae30,	0xae31, 0xae34, 0xae37, 0xae38, 0xae3a, 0xae40, 
	0xae41, 0xae43,	0xae45, 0xae46, 0xae4a, 0xae4c, 0xae4d, 0xae4e, 
	0xae50, 0xae54,	0xae56, 0xae5c, 0xae5d, 0xae5f, 0xae60, 0xae61, 
	0xae65, 0xae68,	0xae69, 0xae6c, 0xae70, 0xae78, 

	0xae79, 0xae7b, 0xae7c, 0xae7d,	0xae84, 0xae85, 0xae8c, 0xaebc, 
	0xaebd, 0xaebe, 0xaec0, 0xaec4, 0xaecc, 0xaecd, 0xaecf, 0xaed0, 
	0xaed1, 0xaed8, 0xaed9, 0xaedc,	0xaee8, 0xaeeb, 0xaeed, 0xaef4, 
	0xaef8, 0xaefc, 0xaf07, 0xaf08, 0xaf0d, 0xaf10, 0xaf2c, 0xaf2d, 
	0xaf30, 0xaf32, 0xaf34, 0xaf3c, 0xaf3d, 0xaf3f, 0xaf41, 0xaf42,
	0xaf43, 0xaf48, 0xaf49, 0xaf50, 0xaf5c, 0xaf5d, 0xaf64, 0xaf65,
	0xaf79, 0xaf80, 0xaf84, 0xaf88, 0xaf90, 0xaf91, 0xaf95, 0xaf9c, 
	0xafb8, 0xafb9, 0xafbc, 0xafc0, 0xafc7, 0xafc8, 0xafc9, 0xafcb, 
	0xafcd, 0xafce, 0xafd4, 0xafdc,	0xafe8, 0xafe9, 0xaff0, 0xaff1, 
	0xaff4, 0xaff8, 0xb000, 0xb001,	0xb004, 0xb00c, 0xb010, 0xb014, 
	0xb01c, 0xb01d, 0xb028, 0xb044, 0xb045, 0xb048, 0xb04a, 0xb04c, 
	0xb04e, 0xb053, 0xb054, 0xb055,	0xb057, 0xb059, 

	0xb05d, 0xb07c, 0xb07d, 0xb080, 0xb084, 0xb08c,	0xb08d, 0xb08f, 
	0xb091, 0xb098, 0xb099, 0xb09a, 0xb09c, 0xb09f,	0xb0a0, 0xb0a1, 
	0xb0a2, 0xb0a8, 0xb0a9, 0xb0ab, 0xb0ac, 0xb0ad,	0xb0ae, 0xb0af, 
	0xb0b1, 0xb0b3, 0xb0b4, 0xb0b5, 0xb0b8, 0xb0bc,	0xb0c4, 0xb0c5, 
	0xb0c7, 0xb0c8, 0xb0c9, 0xb0d0, 0xb0d1, 0xb0d4,	0xb0d8, 0xb0e0, 
	0xb0e5, 0xb108, 0xb109, 0xb10b, 0xb10c, 0xb110,	0xb112, 0xb113, 
	0xb118, 0xb119, 0xb11b, 0xb11c, 0xb11d, 0xb123,	0xb124, 0xb125, 
	0xb128, 0xb12c, 0xb134, 0xb135, 0xb137, 0xb138,	0xb139, 0xb140, 
	0xb141, 0xb144, 0xb148, 0xb150, 0xb151, 0xb154,	0xb155, 0xb158, 
	0xb15c, 0xb160, 0xb178, 0xb179, 0xb17c, 0xb180,	0xb182, 0xb188, 
	0xb189, 0xb18b, 0xb18d, 0xb192, 0xb193, 0xb194,	0xb198, 0xb19c, 
	0xb1a8, 0xb1cc, 0xb1d0, 0xb1d4, 0xb1dc, 0xb1dd,

	0xb1df, 0xb1e8, 0xb1e9, 0xb1ec, 0xb1f0, 0xb1f9, 0xb1fb, 0xb1fd,
	0xb204, 0xb205, 0xb208, 0xb20b, 0xb20c, 0xb214, 0xb215, 0xb217,
	0xb219, 0xb220, 0xb234, 0xb23c, 0xb258, 0xb25c, 0xb260, 0xb268,
	0xb269, 0xb274, 0xb275, 0xb27c, 0xb284, 0xb285, 0xb289, 0xb290,
	0xb291, 0xb294, 0xb298, 0xb299, 0xb29a, 0xb2a0, 0xb2a1, 0xb2a3,
	0xb2a5, 0xb2a6, 0xb2aa, 0xb2ac, 0xb2b0, 0xb2b4, 0xb2c8, 0xb2c9,
	0xb2cc, 0xb2d0, 0xb2d2, 0xb2d8, 0xb2d9, 0xb2db, 0xb2dd, 0xb2e2,
	0xb2e4, 0xb2e5, 0xb2e6, 0xb2e8, 0xb2eb, 0xb2ec, 0xb2ed, 0xb2ee,
	0xb2ef, 0xb2f3, 0xb2f4, 0xb2f5, 0xb2f7, 0xb2f8, 0xb2f9, 0xb2fa,
	0xb2fb, 0xb2ff, 0xb300, 0xb301, 0xb304, 0xb308, 0xb310, 0xb311,
	0xb313, 0xb314, 0xb315, 0xb31c, 0xb354, 0xb355, 0xb356, 0xb358,
	0xb35b, 0xb35c, 0xb35e, 0xb35f, 0xb364, 0xb365,

	0xb367, 0xb369, 0xb36b, 0xb36e, 0xb370, 0xb371, 0xb374, 0xb378,
	0xb380, 0xb381,	0xb383, 0xb384, 0xb385, 0xb38c, 0xb390, 0xb394,
	0xb3a0, 0xb3a1,	0xb3a8, 0xb3ac, 0xb3c4, 0xb3c5, 0xb3c8, 0xb3cb,
	0xb3cc, 0xb3ce,	0xb3d0, 0xb3d4, 0xb3d5, 0xb3d7, 0xb3d9, 0xb3db,
	0xb3dd, 0xb3e0,	0xb3e4, 0xb3e8, 0xb3fc, 0xb410, 0xb418, 0xb41c,
	0xb420, 0xb428,	0xb429, 0xb42b, 0xb434, 0xb450, 0xb451, 0xb454,
	0xb458, 0xb460,	0xb461, 0xb463, 0xb465, 0xb46c, 0xb480, 0xb488,
	0xb49d, 0xb4a4,	0xb4a8, 0xb4ac, 0xb4b5, 0xb4b7, 0xb4b9, 0xb4c0,
	0xb4c4, 0xb4c8,	0xb4d0, 0xb4d5, 0xb4dc, 0xb4dd, 0xb4e0, 0xb4e3,
	0xb4e4, 0xb4e6,	0xb4ec, 0xb4ed, 0xb4ef, 0xb4f1, 0xb4f8, 0xb514,
	0xb515, 0xb518,	0xb51b, 0xb51c, 0xb524, 0xb525, 0xb527, 0xb528,
	0xb529, 0xb52a,	0xb530, 0xb531, 0xb534, 0xb538,

	0xb540, 0xb541, 0xb543, 0xb544,	0xb545, 0xb54b, 0xb54c, 0xb54d,
	0xb550, 0xb554, 0xb55c, 0xb55d,	0xb55f, 0xb560, 0xb561, 0xb5a0,
	0xb5a1, 0xb5a4, 0xb5a8, 0xb5aa,	0xb5ab, 0xb5b0, 0xb5b1, 0xb5b3,
	0xb5b4, 0xb5b5, 0xb5bb, 0xb5bc,	0xb5bd, 0xb5c0, 0xb5c4, 0xb5cc,
	0xb5cd, 0xb5cf, 0xb5d0, 0xb5d1,	0xb5d8, 0xb5ec, 0xb610, 0xb611,
	0xb614, 0xb618, 0xb625, 0xb62c,	0xb634, 0xb648, 0xb664, 0xb668,
	0xb69c, 0xb69d, 0xb6a0, 0xb6a4,	0xb6ab, 0xb6ac, 0xb6b1, 0xb6d4,
	0xb6f0, 0xb6f4, 0xb6f8, 0xb700,	0xb701, 0xb705, 0xb728, 0xb729,
	0xb72c, 0xb72f, 0xb730, 0xb738,	0xb739, 0xb73b, 0xb744, 0xb748,
	0xb74c, 0xb754, 0xb755, 0xb760,	0xb764, 0xb768, 0xb770, 0xb771,
	0xb773, 0xb775, 0xb77c, 0xb77d,	0xb780, 0xb784, 0xb78c, 0xb78d,
	0xb78f, 0xb790, 0xb791, 0xb792,	0xb796, 0xb797,

	0xb798, 0xb799,	0xb79c, 0xb7a0, 0xb7a8, 0xb7a9,	0xb7ab, 0xb7ac,
	0xb7ad, 0xb7b4, 0xb7b5, 0xb7b8, 0xb7c7, 0xb7c9,	0xb7ec, 0xb7ed,
	0xb7f0, 0xb7f4, 0xb7fc, 0xb7fd, 0xb7ff, 0xb800,	0xb801, 0xb807,
	0xb808, 0xb809, 0xb80c, 0xb810, 0xb818, 0xb819,	0xb81b, 0xb81d,
	0xb824, 0xb825, 0xb828, 0xb82c, 0xb834, 0xb835,	0xb837, 0xb838,
	0xb839, 0xb840, 0xb844, 0xb851, 0xb853, 0xb85c,	0xb85d, 0xb860,
	0xb864, 0xb86c, 0xb86d, 0xb86f, 0xb871, 0xb878,	0xb87c, 0xb88d,
	0xb8a8, 0xb8b0, 0xb8b4, 0xb8b8, 0xb8c0, 0xb8c1,	0xb8c3, 0xb8c5,
	0xb8cc, 0xb8d0, 0xb8d4, 0xb8dd, 0xb8df, 0xb8e1,	0xb8e8, 0xb8e9,
	0xb8ec, 0xb8f0, 0xb8f8, 0xb8f9, 0xb8fb, 0xb8fd,	0xb904, 0xb918,
	0xb920, 0xb93c, 0xb93d, 0xb940, 0xb944, 0xb94c,	0xb94f, 0xb951,
	0xb958, 0xb959, 0xb95c, 0xb960, 0xb968, 0xb969,

	0xb96b, 0xb96d, 0xb974, 0xb975, 0xb978, 0xb97c, 0xb984, 0xb985,
	0xb987, 0xb989, 0xb98a, 0xb98d, 0xb98e, 0xb9ac, 0xb9ad, 0xb9b0,
	0xb9b4, 0xb9bc, 0xb9bd, 0xb9bf, 0xb9c1, 0xb9c8, 0xb9c9, 0xb9cc,
	0xb9ce, 0xb9cf, 0xb9d0, 0xb9d1, 0xb9d2, 0xb9d8, 0xb9d9, 0xb9db,
	0xb9dd, 0xb9de, 0xb9e1, 0xb9e3, 0xb9e4, 0xb9e5, 0xb9e8, 0xb9ec,
	0xb9f4, 0xb9f5, 0xb9f7, 0xb9f8, 0xb9f9, 0xb9fa, 0xba00, 0xba01,
	0xba08, 0xba15, 0xba38, 0xba39, 0xba3c, 0xba40, 0xba42, 0xba48,
	0xba49, 0xba4b, 0xba4d, 0xba4e, 0xba53, 0xba54, 0xba55, 0xba58,
	0xba5c, 0xba64, 0xba65, 0xba67, 0xba68, 0xba69, 0xba70, 0xba71,
	0xba74, 0xba78, 0xba83, 0xba84, 0xba85, 0xba87, 0xba8c, 0xbaa8,
	0xbaa9, 0xbaab, 0xbaac, 0xbab0, 0xbab2, 0xbab8, 0xbab9, 0xbabb,
	0xbabd, 0xbac4, 0xbac8, 0xbad8, 0xbad9, 0xbafc,

	0xbb00, 0xbb04, 0xbb0d, 0xbb0f, 0xbb11, 0xbb18, 0xbb1c, 0xbb20,
	0xbb29, 0xbb2b, 0xbb34, 0xbb35, 0xbb36, 0xbb38, 0xbb3b, 0xbb3c,
	0xbb3d, 0xbb3e,	0xbb44, 0xbb45, 0xbb47, 0xbb49, 0xbb4d, 0xbb4f,
	0xbb50, 0xbb54,	0xbb58, 0xbb61, 0xbb63, 0xbb6c, 0xbb88, 0xbb8c,
	0xbb90, 0xbba4,	0xbba8, 0xbbac, 0xbbb4, 0xbbb7, 0xbbc0, 0xbbc4,
	0xbbc8, 0xbbd0,	0xbbd3, 0xbbf8, 0xbbf9, 0xbbfc, 0xbbff, 0xbc00,
	0xbc02, 0xbc08,	0xbc09, 0xbc0b, 0xbc0c, 0xbc0d, 0xbc0f, 0xbc11,
	0xbc14, 0xbc15,	0xbc16, 0xbc17, 0xbc18, 0xbc1b, 0xbc1c, 0xbc1d,
	0xbc1e, 0xbc1f,	0xbc24, 0xbc25, 0xbc27, 0xbc29, 0xbc2d, 0xbc30,
	0xbc31, 0xbc34,	0xbc38, 0xbc40, 0xbc41, 0xbc43, 0xbc44, 0xbc45,
	0xbc49, 0xbc4c,	0xbc4d, 0xbc50, 0xbc5d, 0xbc84, 0xbc85, 0xbc88,
	0xbc8b, 0xbc8c,	0xbc8e, 0xbc94, 0xbc95, 0xbc97,

	0xbc99, 0xbc9a, 0xbca0, 0xbca1,	0xbca4, 0xbca7, 0xbca8, 0xbcb0,
	0xbcb1, 0xbcb3, 0xbcb4, 0xbcb5,	0xbcbc, 0xbcbd, 0xbcc0, 0xbcc4,
	0xbccd, 0xbccf, 0xbcd0, 0xbcd1,	0xbcd5, 0xbcd8, 0xbcdc, 0xbcf4,
	0xbcf5, 0xbcf6, 0xbcf8, 0xbcfc,	0xbd04, 0xbd05, 0xbd07, 0xbd09,
	0xbd10, 0xbd14, 0xbd24, 0xbd2c,	0xbd40, 0xbd48, 0xbd49, 0xbd4c,
	0xbd50, 0xbd58, 0xbd59, 0xbd64,	0xbd68, 0xbd80, 0xbd81, 0xbd84,
	0xbd87, 0xbd88, 0xbd89, 0xbd8a,	0xbd90, 0xbd91, 0xbd93, 0xbd95,
	0xbd99, 0xbd9a, 0xbd9c, 0xbda4,	0xbdb0, 0xbdb8, 0xbdd4, 0xbdd5,
	0xbdd8, 0xbddc, 0xbde9, 0xbdf0,	0xbdf4, 0xbdf8, 0xbe00, 0xbe03,
	0xbe05, 0xbe0c, 0xbe0d, 0xbe10,	0xbe14, 0xbe1c, 0xbe1d, 0xbe1f,
	0xbe44, 0xbe45, 0xbe48, 0xbe4c, 0xbe4e, 0xbe54, 0xbe55, 0xbe57,
	0xbe59, 0xbe5a, 0xbe5b, 0xbe60,	0xbe61, 0xbe64,

	0xbe68, 0xbe6a, 0xbe70, 0xbe71, 0xbe73, 0xbe74,	0xbe75, 0xbe7b,
	0xbe7c, 0xbe7d, 0xbe80, 0xbe84, 0xbe8c, 0xbe8d,	0xbe8f, 0xbe90,
	0xbe91, 0xbe98, 0xbe99, 0xbea8, 0xbed0, 0xbed1,	0xbed4, 0xbed7,
	0xbed8, 0xbee0, 0xbee3, 0xbee4, 0xbee5, 0xbeec,	0xbf01, 0xbf08,
	0xbf09, 0xbf18, 0xbf19, 0xbf1b, 0xbf1c, 0xbf1d,	0xbf40, 0xbf41,
	0xbf44, 0xbf48, 0xbf50, 0xbf51, 0xbf55, 0xbf94,	0xbfb0, 0xbfc5,
	0xbfcc, 0xbfcd, 0xbfd0, 0xbfd4, 0xbfdc, 0xbfdf,	0xbfe1, 0xc03c,
	0xc051, 0xc058, 0xc05c, 0xc060, 0xc068, 0xc069,	0xc090, 0xc091,
	0xc094, 0xc098, 0xc0a0, 0xc0a1, 0xc0a3, 0xc0a5,	0xc0ac, 0xc0ad,
	0xc0af, 0xc0b0, 0xc0b3, 0xc0b4, 0xc0b5, 0xc0b6,	0xc0bc, 0xc0bd,
	0xc0bf, 0xc0c0, 0xc0c1, 0xc0c5, 0xc0c8, 0xc0c9,	0xc0cc, 0xc0d0,
	0xc0d8, 0xc0d9, 0xc0db, 0xc0dc, 0xc0dd, 0xc0e4,

	0xc0e5, 0xc0e8, 0xc0ec, 0xc0f4, 0xc0f5, 0xc0f7, 0xc0f9, 0xc100,
	0xc104, 0xc108, 0xc110, 0xc115, 0xc11c, 0xc11d, 0xc11e, 0xc11f,
	0xc120, 0xc123, 0xc124, 0xc126, 0xc127, 0xc12c, 0xc12d, 0xc12f,
	0xc130, 0xc131, 0xc136, 0xc138, 0xc139, 0xc13c, 0xc140, 0xc148,
	0xc149, 0xc14b, 0xc14c, 0xc14d, 0xc154, 0xc155, 0xc158, 0xc15c,
	0xc164, 0xc165, 0xc167, 0xc168, 0xc169, 0xc170, 0xc174, 0xc178,
	0xc185, 0xc18c, 0xc18d, 0xc18e, 0xc190, 0xc194, 0xc196, 0xc19c,
	0xc19d, 0xc19f, 0xc1a1, 0xc1a5, 0xc1a8, 0xc1a9, 0xc1ac, 0xc1b0,
	0xc1bd, 0xc1c4, 0xc1c8, 0xc1cc, 0xc1d4, 0xc1d7, 0xc1d8, 0xc1e0,
	0xc1e4, 0xc1e8, 0xc1f0, 0xc1f1, 0xc1f3, 0xc1fc, 0xc1fd, 0xc200,
	0xc204, 0xc20c, 0xc20d, 0xc20f, 0xc211, 0xc218, 0xc219, 0xc21c,
	0xc21f, 0xc220, 0xc228, 0xc229, 0xc22b, 0xc22d,

	0xc22f, 0xc231,	0xc232, 0xc234, 0xc248, 0xc250, 0xc251, 0xc254,
	0xc258, 0xc260,	0xc265, 0xc26c, 0xc26d, 0xc270, 0xc274, 0xc27c,
	0xc27d, 0xc27f,	0xc281, 0xc288, 0xc289, 0xc290, 0xc298, 0xc29b,
	0xc29d, 0xc2a4,	0xc2a5, 0xc2a8, 0xc2ac, 0xc2ad, 0xc2b4, 0xc2b5,
	0xc2b7, 0xc2b9,	0xc2dc, 0xc2dd, 0xc2e0, 0xc2e3, 0xc2e4, 0xc2eb,
	0xc2ec, 0xc2ed,	0xc2ef, 0xc2f1, 0xc2f6, 0xc2f8, 0xc2f9, 0xc2fb,
	0xc2fc, 0xc300,	0xc308, 0xc309, 0xc30c, 0xc30d, 0xc313, 0xc314,
	0xc315, 0xc318,	0xc31c, 0xc324, 0xc325, 0xc328, 0xc329, 0xc345,
	0xc368, 0xc369,	0xc36c, 0xc370, 0xc372, 0xc378, 0xc379, 0xc37c,
	0xc37d, 0xc384,	0xc388, 0xc38c, 0xc3c0, 0xc3d8, 0xc3d9, 0xc3dc,
	0xc3df, 0xc3e0,	0xc3e2, 0xc3e8, 0xc3e9, 0xc3ed, 0xc3f4, 0xc3f5,
	0xc3f8, 0xc408,	0xc410, 0xc424, 0xc42c, 0xc430,

	0xc434, 0xc43c, 0xc43d, 0xc448,	0xc464, 0xc465, 0xc468, 0xc46c,
	0xc474, 0xc475, 0xc479, 0xc480,	0xc494, 0xc49c, 0xc4b8, 0xc4bc,
	0xc4e9, 0xc4f0, 0xc4f1, 0xc4f4,	0xc4f8, 0xc4fa, 0xc4ff, 0xc500,
	0xc501, 0xc50c, 0xc510, 0xc514,	0xc51c, 0xc528, 0xc529, 0xc52c,
	0xc530, 0xc538, 0xc539, 0xc53b,	0xc53d, 0xc544, 0xc545, 0xc548,
	0xc549, 0xc54a, 0xc54c, 0xc54d,	0xc54e, 0xc553, 0xc554, 0xc555,
	0xc557, 0xc558, 0xc559, 0xc55d,	0xc55e, 0xc560, 0xc561, 0xc564,
	0xc568, 0xc570, 0xc571, 0xc573,	0xc574, 0xc575, 0xc57c, 0xc57d,
	0xc580, 0xc584, 0xc587, 0xc58c,	0xc58d, 0xc58f, 0xc591, 0xc595,
	0xc597, 0xc598, 0xc59c, 0xc5a0,	0xc5a9, 0xc5b4, 0xc5b5, 0xc5b8,
	0xc5b9, 0xc5bb, 0xc5bc, 0xc5bd,	0xc5be, 0xc5c4, 0xc5c5, 0xc5c6,
	0xc5c7, 0xc5c8, 0xc5c9, 0xc5ca,	0xc5cc, 0xc5ce,

	0xc5d0, 0xc5d1, 0xc5d4, 0xc5d8, 0xc5e0, 0xc5e1,	0xc5e3, 0xc5e5,
	0xc5ec, 0xc5ed, 0xc5ee, 0xc5f0, 0xc5f4, 0xc5f6,	0xc5f7, 0xc5fc,
	0xc5fd, 0xc5fe, 0xc5ff, 0xc600, 0xc601, 0xc605,	0xc606, 0xc607,
	0xc608, 0xc60c, 0xc610, 0xc618, 0xc619, 0xc61b,	0xc61c, 0xc624,
	0xc625, 0xc628, 0xc62c, 0xc62d, 0xc62e, 0xc630,	0xc633, 0xc634,
	0xc635, 0xc637, 0xc639, 0xc63b, 0xc640, 0xc641,	0xc644, 0xc648,
	0xc650, 0xc651, 0xc653, 0xc654, 0xc655, 0xc65c,	0xc65d, 0xc660,
	0xc66c, 0xc66f, 0xc671, 0xc678, 0xc679, 0xc67c,	0xc680, 0xc688,
	0xc689, 0xc68b, 0xc68d, 0xc694, 0xc695, 0xc698,	0xc69c, 0xc6a4,
	0xc6a5, 0xc6a7, 0xc6a9, 0xc6b0, 0xc6b1, 0xc6b4,	0xc6b8, 0xc6b9,
	0xc6ba, 0xc6c0, 0xc6c1, 0xc6c3, 0xc6c5, 0xc6cc,	0xc6cd, 0xc6d0,
	0xc6d4, 0xc6dc, 0xc6dd, 0xc6e0, 0xc6e1, 0xc6e8,

	0xc6e9, 0xc6ec, 0xc6f0, 0xc6f8, 0xc6f9, 0xc6fd, 0xc704, 0xc705,
	0xc708, 0xc70c, 0xc714, 0xc715, 0xc717, 0xc719, 0xc720, 0xc721,
	0xc724, 0xc728, 0xc730, 0xc731, 0xc733, 0xc735, 0xc737, 0xc73c,
	0xc73d, 0xc740, 0xc744, 0xc74a, 0xc74c, 0xc74d, 0xc74f, 0xc751,
	0xc752, 0xc753, 0xc754, 0xc755, 0xc756, 0xc757, 0xc758, 0xc75c,
	0xc760, 0xc768, 0xc76b, 0xc774, 0xc775, 0xc778, 0xc77c, 0xc77d,
	0xc77e, 0xc783, 0xc784, 0xc785, 0xc787, 0xc788, 0xc789, 0xc78a,
	0xc78e, 0xc790, 0xc791, 0xc794, 0xc796, 0xc797, 0xc798, 0xc79a,
	0xc7a0, 0xc7a1, 0xc7a3, 0xc7a4, 0xc7a5, 0xc7a6, 0xc7ac, 0xc7ad,
	0xc7b0, 0xc7b4, 0xc7bc, 0xc7bd, 0xc7bf, 0xc7c0, 0xc7c1, 0xc7c8,
	0xc7c9, 0xc7cc, 0xc7ce, 0xc7d0, 0xc7d8, 0xc7dd, 0xc7e4, 0xc7e8,
	0xc7ec, 0xc800, 0xc801, 0xc804, 0xc808, 0xc80a,

	0xc810, 0xc811,	0xc813, 0xc815, 0xc816, 0xc81c, 0xc81d, 0xc820,
	0xc824, 0xc82c,	0xc82d, 0xc82f, 0xc831, 0xc838, 0xc83c, 0xc840,
	0xc848, 0xc849,	0xc84c, 0xc84d, 0xc854, 0xc870, 0xc871, 0xc874,
	0xc878, 0xc87a,	0xc880, 0xc881, 0xc883, 0xc885, 0xc886, 0xc887,
	0xc88b, 0xc88c,	0xc88d, 0xc894, 0xc89d, 0xc89f, 0xc8a1, 0xc8a8,
	0xc8bc, 0xc8bd,	0xc8c4, 0xc8c8, 0xc8cc, 0xc8d4, 0xc8d5, 0xc8d7,
	0xc8d9, 0xc8e0,	0xc8e1, 0xc8e4, 0xc8f5, 0xc8fc, 0xc8fd, 0xc900,
	0xc904, 0xc905,	0xc906, 0xc90c, 0xc90d, 0xc90f, 0xc911, 0xc918,
	0xc92c, 0xc934,	0xc950, 0xc951, 0xc954, 0xc958, 0xc960, 0xc961,
	0xc963, 0xc96c,	0xc970, 0xc974, 0xc97c, 0xc988, 0xc989, 0xc98c,
	0xc990, 0xc998,	0xc999, 0xc99b, 0xc99d, 0xc9c0, 0xc9c1, 0xc9c4,
	0xc9c7, 0xc9c8,	0xc9ca, 0xc9d0, 0xc9d1, 0xc9d3,

	0xc9d5, 0xc9d6, 0xc9d9, 0xc9da,	0xc9dc, 0xc9dd, 0xc9e0, 0xc9e2,
	0xc9e4, 0xc9e7, 0xc9ec, 0xc9ed,	0xc9ef, 0xc9f0, 0xc9f1, 0xc9f8,
	0xc9f9, 0xc9fc, 0xca00, 0xca08,	0xca09, 0xca0b, 0xca0c, 0xca0d,
	0xca14, 0xca18, 0xca29, 0xca4c,	0xca4d, 0xca50, 0xca54, 0xca5c,
	0xca5d, 0xca5f, 0xca60, 0xca61,	0xca68, 0xca7d, 0xca84, 0xca98,
	0xcabc, 0xcabd, 0xcac0, 0xcac4,	0xcacc, 0xcacd, 0xcacf, 0xcad1,
	0xcad3, 0xcad8, 0xcad9, 0xcae0,	0xcaec, 0xcaf4, 0xcb08, 0xcb10,
	0xcb14, 0xcb18, 0xcb20, 0xcb21,	0xcb41, 0xcb48, 0xcb49, 0xcb4c,
	0xcb50, 0xcb58, 0xcb59, 0xcb5d,	0xcb64, 0xcb78, 0xcb79, 0xcb9c,
	0xcbb8, 0xcbd4, 0xcbe4, 0xcbe7,	0xcbe9, 0xcc0c, 0xcc0d, 0xcc10,
	0xcc14, 0xcc1c, 0xcc1d, 0xcc21,	0xcc22, 0xcc27, 0xcc28, 0xcc29,
	0xcc2c, 0xcc2e, 0xcc30, 0xcc38,	0xcc39, 0xcc3b,

	0xcc3c, 0xcc3d, 0xcc3e, 0xcc44, 0xcc45, 0xcc48,	0xcc4c, 0xcc54,
	0xcc55, 0xcc57, 0xcc58, 0xcc59, 0xcc60, 0xcc64,	0xcc66, 0xcc68,
	0xcc70, 0xcc75, 0xcc98, 0xcc99, 0xcc9c, 0xcca0,	0xcca8, 0xcca9,
	0xccab, 0xccac, 0xccad, 0xccb4, 0xccb5, 0xccb8,	0xccbc, 0xccc4,
	0xccc5, 0xccc7, 0xccc9, 0xccd0, 0xccd4, 0xcce4,	0xccec, 0xccf0,
	0xcd01, 0xcd08, 0xcd09, 0xcd0c, 0xcd10, 0xcd18,	0xcd19, 0xcd1b,
	0xcd1d, 0xcd24, 0xcd28, 0xcd2c, 0xcd39, 0xcd5c,	0xcd60, 0xcd64,
	0xcd6c, 0xcd6d, 0xcd6f, 0xcd71, 0xcd78, 0xcd88,	0xcd94, 0xcd95,
	0xcd98, 0xcd9c, 0xcda4, 0xcda5, 0xcda7, 0xcda9,	0xcdb0, 0xcdc4,
	0xcdcc, 0xcdd0, 0xcde8, 0xcdec, 0xcdf0, 0xcdf8,	0xcdf9, 0xcdfb,
	0xcdfd, 0xce04, 0xce08, 0xce0c, 0xce14, 0xce19,	0xce20, 0xce21,
	0xce24, 0xce28, 0xce30, 0xce31, 0xce33, 0xce35,

	0xce58, 0xce59, 0xce5c, 0xce5f, 0xce60, 0xce61, 0xce68, 0xce69,
	0xce6b, 0xce6d, 0xce74, 0xce75, 0xce78, 0xce7c, 0xce84, 0xce85,
	0xce87, 0xce89, 0xce90, 0xce91, 0xce94, 0xce98, 0xcea0, 0xcea1,
	0xcea3, 0xcea4, 0xcea5, 0xceac, 0xcead, 0xcec1, 0xcee4, 0xcee5,
	0xcee8, 0xceeb, 0xceec, 0xcef4, 0xcef5, 0xcef7, 0xcef8, 0xcef9,
	0xcf00, 0xcf01, 0xcf04, 0xcf08, 0xcf10, 0xcf11, 0xcf13, 0xcf15,
	0xcf1c, 0xcf20, 0xcf24, 0xcf2c, 0xcf2d, 0xcf2f, 0xcf30, 0xcf31,
	0xcf38, 0xcf54, 0xcf55, 0xcf58, 0xcf5c, 0xcf64, 0xcf65, 0xcf67,
	0xcf69, 0xcf70, 0xcf71, 0xcf74, 0xcf78, 0xcf80, 0xcf85, 0xcf8c,
	0xcfa1, 0xcfa8, 0xcfb0, 0xcfc4, 0xcfe0, 0xcfe1, 0xcfe4, 0xcfe8,
	0xcff0, 0xcff1, 0xcff3, 0xcff5, 0xcffc, 0xd000, 0xd004, 0xd011,
	0xd018, 0xd02d, 0xd034, 0xd035, 0xd038, 0xd03c,

	0xd044, 0xd045,	0xd047, 0xd049, 0xd050, 0xd054, 0xd058, 0xd060,
	0xd06c, 0xd06d,	0xd070, 0xd074, 0xd07c, 0xd07d, 0xd081, 0xd0a4,
	0xd0a5, 0xd0a8,	0xd0ac, 0xd0b4, 0xd0b5, 0xd0b7, 0xd0b9, 0xd0c0,
	0xd0c1, 0xd0c4,	0xd0c8, 0xd0c9, 0xd0d0, 0xd0d1, 0xd0d3, 0xd0d4,
	0xd0d5, 0xd0dc,	0xd0dd, 0xd0e0, 0xd0e4, 0xd0ec, 0xd0ed, 0xd0ef,
	0xd0f0, 0xd0f1,	0xd0f8, 0xd10d, 0xd130, 0xd131, 0xd134, 0xd138,
	0xd13a, 0xd140,	0xd141, 0xd143, 0xd144, 0xd145, 0xd14c, 0xd14d,
	0xd150, 0xd154,	0xd15c, 0xd15d, 0xd15f, 0xd161, 0xd168, 0xd16c,
	0xd17c, 0xd184,	0xd188, 0xd1a0, 0xd1a1, 0xd1a4, 0xd1a8, 0xd1b0,
	0xd1b1, 0xd1b3,	0xd1b5, 0xd1ba, 0xd1bc, 0xd1c0, 0xd1d8, 0xd1f4,
	0xd1f8, 0xd207,	0xd209, 0xd210, 0xd22c, 0xd22d, 0xd230, 0xd234,
	0xd23c, 0xd23d,	0xd23f, 0xd241, 0xd248, 0xd25c,

	0xd264, 0xd280, 0xd281, 0xd284,	0xd288, 0xd290, 0xd291, 0xd295,
	0xd29c, 0xd2a0, 0xd2a4, 0xd2ac,	0xd2b1, 0xd2b8, 0xd2b9, 0xd2bc,
	0xd2bf, 0xd2c0, 0xd2c2, 0xd2c8,	0xd2c9, 0xd2cb, 0xd2d4, 0xd2d8,
	0xd2dc, 0xd2e4, 0xd2e5, 0xd2f0,	0xd2f1, 0xd2f4, 0xd2f8, 0xd300,
	0xd301, 0xd303, 0xd305, 0xd30c,	0xd30d, 0xd30e, 0xd310, 0xd314,
	0xd316, 0xd31c, 0xd31d, 0xd31f,	0xd320, 0xd321, 0xd325, 0xd328,
	0xd329, 0xd32c, 0xd330, 0xd338,	0xd339, 0xd33b, 0xd33c, 0xd33d,
	0xd344, 0xd345, 0xd37c, 0xd37d,	0xd380, 0xd384, 0xd38c, 0xd38d,
	0xd38f, 0xd390, 0xd391, 0xd398,	0xd399, 0xd39c, 0xd3a0, 0xd3a8,
	0xd3a9, 0xd3ab, 0xd3ad, 0xd3b4,	0xd3b8, 0xd3bc, 0xd3c4, 0xd3c5,
	0xd3c8, 0xd3c9, 0xd3d0, 0xd3d8,	0xd3e1, 0xd3e3, 0xd3ec, 0xd3ed,
	0xd3f0, 0xd3f4, 0xd3fc, 0xd3fd,	0xd3ff, 0xd401,

	0xd408, 0xd41d, 0xd440, 0xd444, 0xd45c, 0xd460,	0xd464, 0xd46d,
	0xd46f, 0xd478, 0xd479, 0xd47c, 0xd47f, 0xd480,	0xd482, 0xd488,
	0xd489, 0xd48b, 0xd48d, 0xd494, 0xd4a9, 0xd4cc,	0xd4d0, 0xd4d4,
	0xd4dc, 0xd4df, 0xd4e8, 0xd4ec, 0xd4f0, 0xd4f8,	0xd4fb, 0xd4fd,
	0xd504, 0xd508, 0xd50c, 0xd514, 0xd515, 0xd517,	0xd53c, 0xd53d,
	0xd540, 0xd544, 0xd54c, 0xd54d, 0xd54f, 0xd551,	0xd558, 0xd559,
	0xd55c, 0xd560, 0xd565, 0xd568, 0xd569, 0xd56b,	0xd56d, 0xd574,
	0xd575, 0xd578, 0xd57c, 0xd584, 0xd585, 0xd587,	0xd588, 0xd589,
	0xd590, 0xd5a5, 0xd5c8, 0xd5c9, 0xd5cc, 0xd5d0,	0xd5d2, 0xd5d8,
	0xd5d9, 0xd5db, 0xd5dd, 0xd5e4, 0xd5e5, 0xd5e8,	0xd5ec, 0xd5f4,
	0xd5f5, 0xd5f7, 0xd5f9, 0xd600, 0xd601, 0xd604,	0xd608, 0xd610,
	0xd611, 0xd613, 0xd614, 0xd615, 0xd61c, 0xd620,

	0xd624, 0xd62d, 0xd638, 0xd639, 0xd63c, 0xd640, 0xd645, 0xd648,
	0xd649, 0xd64b, 0xd64d, 0xd651, 0xd654, 0xd655, 0xd658, 0xd65c,
	0xd667, 0xd669, 0xd670, 0xd671, 0xd674, 0xd683, 0xd685, 0xd68c,
	0xd68d, 0xd690, 0xd694, 0xd69d, 0xd69f, 0xd6a1, 0xd6a8, 0xd6ac,
	0xd6b0, 0xd6b9, 0xd6bb, 0xd6c4, 0xd6c5, 0xd6c8, 0xd6cc, 0xd6d1,
	0xd6d4, 0xd6d7, 0xd6d9, 0xd6e0, 0xd6e4, 0xd6e8, 0xd6f0, 0xd6f5,
	0xd6fc, 0xd6fd, 0xd700, 0xd704, 0xd711, 0xd718, 0xd719, 0xd71c,
	0xd720, 0xd728, 0xd729, 0xd72b, 0xd72d, 0xd734, 0xd735, 0xd738,
	0xd73c, 0xd744, 0xd747, 0xd749, 0xd750, 0xd751, 0xd754, 0xd756,
	0xd757, 0xd758, 0xd759, 0xd760, 0xd761, 0xd763, 0xd765, 0xd769,
	0xd76c, 0xd770, 0xd774, 0xd77c, 0xd77d, 0xd781, 0xd788, 0xd789,
	0xd78c, 0xd790, 0xd798, 0xd799, 0xd79b, 0xd79d,

	/* User defined characters. */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 

	/* 4888 Hanja. */
	0x4F3D, 0x4F73, 0x5047, 0x50F9, 0x52A0, 0x53EF, 0x5475, 0x54E5,
	0x5609, 0x5AC1, 0x5BB6, 0x6687, 0x67B6, 0x67B7, 0x67EF, 0x6B4C,
	0x73C2, 0x75C2, 0x7A3C, 0x82DB, 0x8304, 0x8857, 0x8888, 0x8A36,
	0x8CC8, 0x8DCF, 0x8EFB, 0x8FE6, 0x99D5, 0x523B, 0x5374, 0x5404,
	0x606A, 0x6164, 0x6BBC, 0x73CF, 0x811A, 0x89BA, 0x89D2, 0x95A3,
	0x4F83, 0x520A, 0x58BE, 0x5978, 0x59E6, 0x5E72, 0x5E79, 0x61C7,
	0x63C0, 0x6746, 0x67EC, 0x687F, 0x6F97, 0x764E, 0x770B, 0x78F5,
	0x7A08, 0x7AFF, 0x7C21, 0x809D, 0x826E, 0x8271, 0x8AEB, 0x9593,
	0x4E6B, 0x559D, 0x66F7, 0x6E34, 0x78A3, 0x7AED, 0x845B, 0x8910,
	0x874E, 0x97A8, 0x52D8, 0x574E, 0x582A, 0x5D4C, 0x611F, 0x61BE,
	0x6221, 0x6562, 0x67D1, 0x6A44, 0x6E1B, 0x7518, 0x75B3, 0x76E3,
	0x77B0, 0x7D3A, 0x90AF, 0x9451, 0x9452, 0x9F95,

	0x5323, 0x5CAC, 0x7532, 0x80DB, 0x9240, 0x9598, 0x525B, 0x5808,
	0x59DC, 0x5CA1, 0x5D17, 0x5EB7, 0x5F3A, 0x5F4A, 0x6177, 0x6C5F,
	0x757A, 0x7586, 0x7CE0, 0x7D73, 0x7DB1, 0x7F8C, 0x8154, 0x8221,
	0x8591, 0x8941, 0x8B1B, 0x92FC, 0x964D, 0x9C47, 0x4ECB, 0x4EF7,
	0x500B, 0x51F1, 0x584F, 0x6137, 0x613E, 0x6168, 0x6539, 0x69EA,
	0x6F11, 0x75A5, 0x7686, 0x76D6, 0x7B87, 0x82A5, 0x84CB, 0xF900,
	0x93A7, 0x958B, 0x5580, 0x5BA2, 0x5751, 0xF901, 0x7CB3, 0x7FB9,
	0x91B5, 0x5028, 0x53BB, 0x5C45, 0x5DE8, 0x62D2, 0x636E, 0x64DA,
	0x64E7, 0x6E20, 0x70AC, 0x795B, 0x8DDD, 0x8E1E, 0xF902, 0x907D,
	0x9245, 0x92F8, 0x4E7E, 0x4EF6, 0x5065, 0x5DFE, 0x5EFA, 0x6106,
	0x6957, 0x8171, 0x8654, 0x8E47, 0x9375, 0x9A2B, 0x4E5E, 0x5091,
	0x6770, 0x6840, 0x5109, 0x528D, 0x5292, 0x6AA2,

	0x77BC, 0x9210, 0x9ED4, 0x52AB, 0x602F, 0x8FF2, 0x5048, 0x61A9,
	0x63ED, 0x64CA, 0x683C, 0x6A84, 0x6FC0, 0x8188, 0x89A1, 0x9694,
	0x5805, 0x727D, 0x72AC, 0x7504, 0x7D79, 0x7E6D, 0x80A9, 0x898B,
	0x8B74, 0x9063, 0x9D51, 0x6289, 0x6C7A, 0x6F54, 0x7D50, 0x7F3A,
	0x8A23, 0x517C, 0x614A, 0x7B9D, 0x8B19, 0x9257, 0x938C, 0x4EAC,
	0x4FD3, 0x501E, 0x50BE, 0x5106, 0x52C1, 0x52CD, 0x537F, 0x5770,
	0x5883, 0x5E9A, 0x5F91, 0x6176, 0x61AC, 0x64CE, 0x656C, 0x666F,
	0x66BB, 0x66F4, 0x6897, 0x6D87, 0x7085, 0x70F1, 0x749F, 0x74A5,
	0x74CA, 0x75D9, 0x786C, 0x78EC, 0x7ADF, 0x7AF6, 0x7D45, 0x7D93,
	0x8015, 0x803F, 0x811B, 0x8396, 0x8B66, 0x8F15, 0x9015, 0x93E1,
	0x9803, 0x9838, 0x9A5A, 0x9BE8, 0x4FC2, 0x5553, 0x583A, 0x5951,
	0x5B63, 0x5C46, 0x60B8, 0x6212, 0x6842, 0x68B0,

	0x68E8, 0x6EAA, 0x754C, 0x7678, 0x78CE, 0x7A3D, 0x7CFB, 0x7E6B,
	0x7E7C, 0x8A08, 0x8AA1, 0x8C3F, 0x968E, 0x9DC4, 0x53E4, 0x53E9,
	0x544A, 0x5471, 0x56FA, 0x59D1, 0x5B64, 0x5C3B, 0x5EAB, 0x62F7,
	0x6537, 0x6545, 0x6572, 0x66A0, 0x67AF, 0x69C1, 0x6CBD, 0x75FC,
	0x7690, 0x777E, 0x7A3F, 0x7F94, 0x8003, 0x80A1, 0x818F, 0x82E6,
	0x82FD, 0x83F0, 0x85C1, 0x8831, 0x88B4, 0x8AA5, 0xF903, 0x8F9C,
	0x932E, 0x96C7, 0x9867, 0x9AD8, 0x9F13, 0x54ED, 0x659B, 0x66F2,
	0x688F, 0x7A40, 0x8C37, 0x9D60, 0x56F0, 0x5764, 0x5D11, 0x6606,
	0x68B1, 0x68CD, 0x6EFE, 0x7428, 0x889E, 0x9BE4, 0x6C68, 0xF904,
	0x9AA8, 0x4F9B, 0x516C, 0x5171, 0x529F, 0x5B54, 0x5DE5, 0x6050,
	0x606D, 0x62F1, 0x63A7, 0x653B, 0x73D9, 0x7A7A, 0x86A3, 0x8CA2,
	0x978F, 0x4E32, 0x5BE1, 0x6208, 0x679C, 0x74DC,

	0x79D1, 0x83D3, 0x8A87, 0x8AB2, 0x8DE8, 0x904E, 0x934B, 0x9846,
	0x5ED3, 0x69E8, 0x85FF, 0x90ED, 0xF905, 0x51A0, 0x5B98, 0x5BEC,
	0x6163, 0x68FA, 0x6B3E, 0x704C, 0x742F, 0x74D8, 0x7BA1, 0x7F50,
	0x83C5, 0x89C0, 0x8CAB, 0x95DC, 0x9928, 0x522E, 0x605D, 0x62EC,
	0x9002, 0x4F8A, 0x5149, 0x5321, 0x58D9, 0x5EE3, 0x66E0, 0x6D38,
	0x709A, 0x72C2, 0x73D6, 0x7B50, 0x80F1, 0x945B, 0x5366, 0x639B,
	0x7F6B, 0x4E56, 0x5080, 0x584A, 0x58DE, 0x602A, 0x6127, 0x62D0,
	0x69D0, 0x9B41, 0x5B8F, 0x7D18, 0x80B1, 0x8F5F, 0x4EA4, 0x50D1,
	0x54AC, 0x55AC, 0x5B0C, 0x5DA0, 0x5DE7, 0x652A, 0x654E, 0x6821,
	0x6A4B, 0x72E1, 0x768E, 0x77EF, 0x7D5E, 0x7FF9, 0x81A0, 0x854E,
	0x86DF, 0x8F03, 0x8F4E, 0x90CA, 0x9903, 0x9A55, 0x9BAB, 0x4E18,
	0x4E45, 0x4E5D, 0x4EC7, 0x4FF1, 0x5177, 0x52FE,

	0x5340, 0x53E3, 0x53E5, 0x548E, 0x5614, 0x5775, 0x57A2, 0x5BC7,
	0x5D87, 0x5ED0, 0x61FC, 0x62D8, 0x6551, 0x67B8, 0x67E9, 0x69CB,
	0x6B50, 0x6BC6, 0x6BEC, 0x6C42, 0x6E9D, 0x7078, 0x72D7, 0x7396,
	0x7403, 0x77BF, 0x77E9, 0x7A76, 0x7D7F, 0x8009, 0x81FC, 0x8205,
	0x820A, 0x82DF, 0x8862, 0x8B33, 0x8CFC, 0x8EC0, 0x9011, 0x90B1,
	0x9264, 0x92B6, 0x99D2, 0x9A45, 0x9CE9, 0x9DD7, 0x9F9C, 0x570B,
	0x5C40, 0x83CA, 0x97A0, 0x97AB, 0x9EB4, 0x541B, 0x7A98, 0x7FA4,
	0x88D9, 0x8ECD, 0x90E1, 0x5800, 0x5C48, 0x6398, 0x7A9F, 0x5BAE,
	0x5F13, 0x7A79, 0x7AAE, 0x828E, 0x8EAC, 0x5026, 0x5238, 0x52F8,
	0x5377, 0x5708, 0x62F3, 0x6372, 0x6B0A, 0x6DC3, 0x7737, 0x53A5,
	0x7357, 0x8568, 0x8E76, 0x95D5, 0x673A, 0x6AC3, 0x6F70, 0x8A6D,
	0x8ECC, 0x994B, 0xF906, 0x6677, 0x6B78, 0x8CB4,

	0x9B3C, 0xF907, 0x53EB, 0x572D, 0x594E, 0x63C6, 0x69FB, 0x73EA,
	0x7845, 0x7ABA, 0x7AC5, 0x7CFE, 0x8475, 0x898F, 0x8D73, 0x9035,
	0x95A8, 0x52FB, 0x5747, 0x7547, 0x7B60, 0x83CC, 0x921E, 0xF908,
	0x6A58, 0x514B, 0x524B, 0x5287, 0x621F, 0x68D8, 0x6975, 0x9699,
	0x50C5, 0x52A4, 0x52E4, 0x61C3, 0x65A4, 0x6839, 0x69FF, 0x747E,
	0x7B4B, 0x82B9, 0x83EB, 0x89B2, 0x8B39, 0x8FD1, 0x9949, 0xF909,
	0x4ECA, 0x5997, 0x64D2, 0x6611, 0x6A8E, 0x7434, 0x7981, 0x79BD,
	0x82A9, 0x887E, 0x887F, 0x895F, 0xF90A, 0x9326, 0x4F0B, 0x53CA,
	0x6025, 0x6271, 0x6C72, 0x7D1A, 0x7D66, 0x4E98, 0x5162, 0x77DC,
	0x80AF, 0x4F01, 0x4F0E, 0x5176, 0x5180, 0x55DC, 0x5668, 0x573B,
	0x57FA, 0x57FC, 0x5914, 0x5947, 0x5993, 0x5BC4, 0x5C90, 0x5D0E,
	0x5DF1, 0x5E7E, 0x5FCC, 0x6280, 0x65D7, 0x65E3,

	0x671E, 0x671F, 0x675E, 0x68CB, 0x68C4, 0x6A5F, 0x6B3A, 0x6C23,
	0x6C7D, 0x6C82, 0x6DC7, 0x7398, 0x7426, 0x742A, 0x7482, 0x74A3,
	0x7578, 0x757F, 0x7881, 0x78EF, 0x7941, 0x7947, 0x7948, 0x797A,
	0x7B95, 0x7D00, 0x7DBA, 0x7F88, 0x8006, 0x802D, 0x808C, 0x8A18,
	0x8B4F, 0x8C48, 0x8D77, 0x9321, 0x9324, 0x98E2, 0x9951, 0x9A0E,
	0x9A0F, 0x9A65, 0x9E92, 0x7DCA, 0x4F76, 0x5409, 0x62EE, 0x6854,
	0x91D1, 0x55AB, 0x513A, 0xF90B, 0xF90C, 0x5A1C, 0x61E6, 0xF90D,
	0x62CF, 0x62FF, 0xF90E, 0xF90F, 0xF910, 0xF911, 0xF912, 0xF913,
	0x90A3, 0xF914, 0xF915, 0xF916, 0xF917, 0xF918, 0x8AFE, 0xF919,
	0xF91A, 0xF91B, 0xF91C, 0x6696, 0xF91D, 0x7156, 0xF91E, 0xF91F,
	0x96E3, 0xF920, 0x634F, 0x637A, 0x5357, 0xF921, 0x678F, 0x6960,
	0x6E73, 0xF922, 0x7537, 0xF923, 0xF924, 0xF925,

	0x7D0D, 0xF926, 0xF927, 0x8872, 0x56CA, 0x5A18, 0xF928, 0xF929,
	0xF92A, 0xF92B, 0xF92C, 0x4E43, 0xF92D, 0x5167, 0x5948, 0x67F0,
	0x8010, 0xF92E, 0x5973, 0x5E74, 0x649A, 0x79CA, 0x5FF5, 0x606C,
	0x62C8, 0x637B, 0x5BE7, 0x5BD7, 0x52AA, 0xF92F, 0x5974, 0x5F29,
	0x6012, 0xF930, 0xF931, 0xF932, 0x7459, 0xF933, 0xF934, 0xF935,
	0xF936, 0xF937, 0xF938, 0x99D1, 0xF939, 0xF93A, 0xF93B, 0xF93C,
	0xF93D, 0xF93E, 0xF93F, 0xF940, 0xF941, 0xF942, 0xF943, 0x6FC3,
	0xF944, 0xF945, 0x81BF, 0x8FB2, 0x60F1, 0xF946, 0xF947, 0x8166,
	0xF948, 0xF949, 0x5C3F, 0xF94A, 0xF94B, 0xF94C, 0xF94D, 0xF94E,
	0xF94F, 0xF950, 0xF951, 0x5AE9, 0x8A25, 0x677B, 0x7D10, 0xF952,
	0xF953, 0xF954, 0xF955, 0xF956, 0xF957, 0x80FD, 0xF958, 0xF959,
	0x5C3C, 0x6CE5, 0x533F, 0x6EBA, 0x591A, 0x8336,

	0x4E39, 0x4EB6, 0x4F46, 0x55AE, 0x5718, 0x58C7, 0x5F56, 0x65B7,
	0x65E6, 0x6A80, 0x6BB5, 0x6E4D, 0x77ED, 0x7AEF, 0x7C1E, 0x7DDE,
	0x86CB, 0x8892, 0x9132, 0x935B, 0x64BB, 0x6FBE, 0x737A, 0x75B8,
	0x9054, 0x5556, 0x574D, 0x61BA, 0x64D4, 0x66C7, 0x6DE1, 0x6E5B,
	0x6F6D, 0x6FB9, 0x75F0, 0x8043, 0x81BD, 0x8541, 0x8983, 0x8AC7,
	0x8B5A, 0x931F, 0x6C93, 0x7553, 0x7B54, 0x8E0F, 0x905D, 0x5510,
	0x5802, 0x5858, 0x5E62, 0x6207, 0x649E, 0x68E0, 0x7576, 0x7CD6,
	0x87B3, 0x9EE8, 0x4EE3, 0x5788, 0x576E, 0x5927, 0x5C0D, 0x5CB1,
	0x5E36, 0x5F85, 0x6234, 0x64E1, 0x73B3, 0x81FA, 0x888B, 0x8CB8,
	0x968A, 0x9EDB, 0x5B85, 0x5FB7, 0x60B3, 0x5012, 0x5200, 0x5230,
	0x5716, 0x5835, 0x5857, 0x5C0E, 0x5C60, 0x5CF6, 0x5D8B, 0x5EA6,
	0x5F92, 0x60BC, 0x6311, 0x6389, 0x6417, 0x6843,

	0x68F9, 0x6AC2, 0x6DD8, 0x6E21, 0x6ED4, 0x6FE4, 0x71FE, 0x76DC,
	0x7779, 0x79B1, 0x7A3B, 0x8404, 0x89A9, 0x8CED, 0x8DF3, 0x8E48,
	0x9003, 0x9014, 0x9053, 0x90FD, 0x934D, 0x9676, 0x97DC, 0x6BD2,
	0x7006, 0x7258, 0x72A2, 0x7368, 0x7763, 0x79BF, 0x7BE4, 0x7E9B,
	0x8B80, 0x58A9, 0x60C7, 0x6566, 0x65FD, 0x66BE, 0x6C8C, 0x711E,
	0x71C9, 0x8C5A, 0x9813, 0x4E6D, 0x7A81, 0x4EDD, 0x51AC, 0x51CD,
	0x52D5, 0x540C, 0x61A7, 0x6771, 0x6850, 0x68DF, 0x6D1E, 0x6F7C,
	0x75BC, 0x77B3, 0x7AE5, 0x80F4, 0x8463, 0x9285, 0x515C, 0x6597,
	0x675C, 0x6793, 0x75D8, 0x7AC7, 0x8373, 0xF95A, 0x8C46, 0x9017,
	0x982D, 0x5C6F, 0x81C0, 0x829A, 0x9041, 0x906F, 0x920D, 0x5F97,
	0x5D9D, 0x6A59, 0x71C8, 0x767B, 0x7B49, 0x85E4, 0x8B04, 0x9127,
	0x9A30, 0x5587, 0x61F6, 0xF95B, 0x7669, 0x7F85,

	0x863F, 0x87BA, 0x88F8, 0x908F, 0xF95C, 0x6D1B, 0x70D9, 0x73DE,
	0x7D61, 0x843D, 0xF95D, 0x916A, 0x99F1, 0xF95E, 0x4E82, 0x5375,
	0x6B04, 0x6B12, 0x703E, 0x721B, 0x862D, 0x9E1E, 0x524C, 0x8FA3,
	0x5D50, 0x64E5, 0x652C, 0x6B16, 0x6FEB, 0x7C43, 0x7E9C, 0x85CD,
	0x8964, 0x89BD, 0x62C9, 0x81D8, 0x881F, 0x5ECA, 0x6717, 0x6D6A,
	0x72FC, 0x7405, 0x746F, 0x8782, 0x90DE, 0x4F86, 0x5D0D, 0x5FA0,
	0x840A, 0x51B7, 0x63A0, 0x7565, 0x4EAE, 0x5006, 0x5169, 0x51C9,
	0x6881, 0x6A11, 0x7CAE, 0x7CB1, 0x7CE7, 0x826F, 0x8AD2, 0x8F1B,
	0x91CF, 0x4FB6, 0x5137, 0x52F5, 0x5442, 0x5EEC, 0x616E, 0x623E,
	0x65C5, 0x6ADA, 0x6FFE, 0x792A, 0x85DC, 0x8823, 0x95AD, 0x9A62,
	0x9A6A, 0x9E97, 0x9ECE, 0x529B, 0x66C6, 0x6B77, 0x701D, 0x792B,
	0x8F62, 0x9742, 0x6190, 0x6200, 0x6523, 0x6F23,

	0x7149, 0x7489, 0x7DF4, 0x806F, 0x84EE, 0x8F26, 0x9023, 0x934A,
	0x51BD, 0x5217, 0x52A3, 0x6D0C, 0x70C8, 0x88C2, 0x5EC9, 0x6582,
	0x6BAE, 0x6FC2, 0x7C3E, 0x7375, 0x4EE4, 0x4F36, 0x56F9, 0xF95F,
	0x5CBA, 0x5DBA, 0x601C, 0x73B2, 0x7B2D, 0x7F9A, 0x7FCE, 0x8046,
	0x901E, 0x9234, 0x96F6, 0x9748, 0x9818, 0x9F61, 0x4F8B, 0x6FA7,
	0x79AE, 0x91B4, 0x96B7, 0x52DE, 0xF960, 0x6488, 0x64C4, 0x6AD3,
	0x6F5E, 0x7018, 0x7210, 0x76E7, 0x8001, 0x8606, 0x865C, 0x8DEF,
	0x8F05, 0x9732, 0x9B6F, 0x9DFA, 0x9E75, 0x788C, 0x797F, 0x7DA0,
	0x83C9, 0x9304, 0x9E7F, 0x9E93, 0x8AD6, 0x58DF, 0x5F04, 0x6727,
	0x7027, 0x74CF, 0x7C60, 0x807E, 0x5121, 0x7028, 0x7262, 0x78CA,
	0x8CC2, 0x8CDA, 0x8CF4, 0x96F7, 0x4E86, 0x50DA, 0x5BEE, 0x5ED6,
	0x6599, 0x71CE, 0x7642, 0x77AD, 0x804A, 0x84FC,

	0x907C, 0x9B27, 0x9F8D, 0x58D8, 0x5A41, 0x5C62, 0x6A13, 0x6DDA,
	0x6F0F, 0x763B, 0x7D2F, 0x7E37, 0x851E, 0x8938, 0x93E4, 0x964B,
	0x5289, 0x65D2, 0x67F3, 0x69B4, 0x6D41, 0x6E9C, 0x700F, 0x7409,
	0x7460, 0x7559, 0x7624, 0x786B, 0x8B2C, 0x985E, 0x516D, 0x622E,
	0x9678, 0x4F96, 0x502B, 0x5D19, 0x6DEA, 0x7DB8, 0x8F2A, 0x5F8B,
	0x6144, 0x6817, 0xF961, 0x9686, 0x52D2, 0x808B, 0x51DC, 0x51CC,
	0x695E, 0x7A1C, 0x7DBE, 0x83F1, 0x9675, 0x4FDA, 0x5229, 0x5398,
	0x540F, 0x550E, 0x5C65, 0x60A7, 0x674E, 0x68A8, 0x6D6C, 0x7281,
	0x72F8, 0x7406, 0x7483, 0xF962, 0x75E2, 0x7C6C, 0x7F79, 0x7FB8,
	0x8389, 0x88CF, 0x88E1, 0x91CC, 0x91D0, 0x96E2, 0x9BC9, 0x541D,
	0x6F7E, 0x71D0, 0x7498, 0x85FA, 0x8EAA, 0x96A3, 0x9C57, 0x9E9F,
	0x6797, 0x6DCB, 0x7433, 0x81E8, 0x9716, 0x782C,

	0x7ACB, 0x7B20, 0x7C92, 0x6469, 0x746A, 0x75F2, 0x78BC, 0x78E8,
	0x99AC, 0x9B54, 0x9EBB, 0x5BDE, 0x5E55, 0x6F20, 0x819C, 0x83AB,
	0x9088, 0x4E07, 0x534D, 0x5A29, 0x5DD2, 0x5F4E, 0x6162, 0x633D,
	0x6669, 0x66FC, 0x6EFF, 0x6F2B, 0x7063, 0x779E, 0x842C, 0x8513,
	0x883B, 0x8F13, 0x9945, 0x9C3B, 0x551C, 0x62B9, 0x672B, 0x6CAB,
	0x8309, 0x896A, 0x977A, 0x4EA1, 0x5984, 0x5FD8, 0x5FD9, 0x671B,
	0x7DB2, 0x7F54, 0x8292, 0x832B, 0x83BD, 0x8F1E, 0x9099, 0x57CB,
	0x59B9, 0x5A92, 0x5BD0, 0x6627, 0x679A, 0x6885, 0x6BCF, 0x7164,
	0x7F75, 0x8CB7, 0x8CE3, 0x9081, 0x9B45, 0x8108, 0x8C8A, 0x964C,
	0x9A40, 0x9EA5, 0x5B5F, 0x6C13, 0x731B, 0x76F2, 0x76DF, 0x840C,
	0x51AA, 0x8993, 0x514D, 0x5195, 0x52C9, 0x68C9, 0x6C94, 0x7704,
	0x7720, 0x7DBF, 0x7DEC, 0x9762, 0x9EB5, 0x6EC5,

	0x8511, 0x51A5, 0x540D, 0x547D, 0x660E, 0x669D, 0x6927, 0x6E9F,
	0x76BF, 0x7791, 0x8317, 0x84C2, 0x879F, 0x9169, 0x9298, 0x9CF4,
	0x8882, 0x4FAE, 0x5192, 0x52DF, 0x59C6, 0x5E3D, 0x6155, 0x6478,
	0x6479, 0x66AE, 0x67D0, 0x6A21, 0x6BCD, 0x6BDB, 0x725F, 0x7261,
	0x7441, 0x7738, 0x77DB, 0x8017, 0x82BC, 0x8305, 0x8B00, 0x8B28,
	0x8C8C, 0x6728, 0x6C90, 0x7267, 0x76EE, 0x7766, 0x7A46, 0x9DA9,
	0x6B7F, 0x6C92, 0x5922, 0x6726, 0x8499, 0x536F, 0x5893, 0x5999,
	0x5EDF, 0x63CF, 0x6634, 0x6773, 0x6E3A, 0x732B, 0x7AD7, 0x82D7,
	0x9328, 0x52D9, 0x5DEB, 0x61AE, 0x61CB, 0x620A, 0x62C7, 0x64AB,
	0x65E0, 0x6959, 0x6B66, 0x6BCB, 0x7121, 0x73F7, 0x755D, 0x7E46,
	0x821E, 0x8302, 0x856A, 0x8AA3, 0x8CBF, 0x9727, 0x9D61, 0x58A8,
	0x9ED8, 0x5011, 0x520E, 0x543B, 0x554F, 0x6587,

	0x6C76, 0x7D0A, 0x7D0B, 0x805E, 0x868A, 0x9580, 0x96EF, 0x52FF,
	0x6C95, 0x7269, 0x5473, 0x5A9A, 0x5C3E, 0x5D4B, 0x5F4C, 0x5FAE,
	0x672A, 0x68B6, 0x6963, 0x6E3C, 0x6E44, 0x7709, 0x7C73, 0x7F8E,
	0x8587, 0x8B0E, 0x8FF7, 0x9761, 0x9EF4, 0x5CB7, 0x60B6, 0x610D,
	0x61AB, 0x654F, 0x65FB, 0x65FC, 0x6C11, 0x6CEF, 0x739F, 0x73C9,
	0x7DE1, 0x9594, 0x5BC6, 0x871C, 0x8B10, 0x525D, 0x535A, 0x62CD,
	0x640F, 0x64B2, 0x6734, 0x6A38, 0x6CCA, 0x73C0, 0x749E, 0x7B94,
	0x7C95, 0x7E1B, 0x818A, 0x8236, 0x8584, 0x8FEB, 0x96F9, 0x99C1,
	0x4F34, 0x534A, 0x53CD, 0x53DB, 0x62CC, 0x642C, 0x6500, 0x6591,
	0x69C3, 0x6CEE, 0x6F58, 0x73ED, 0x7554, 0x7622, 0x76E4, 0x76FC,
	0x78D0, 0x78FB, 0x792C, 0x7D46, 0x822C, 0x87E0, 0x8FD4, 0x9812,
	0x98EF, 0x52C3, 0x62D4, 0x64A5, 0x6E24, 0x6F51,

	0x767C, 0x8DCB, 0x91B1, 0x9262, 0x9AEE, 0x9B43, 0x5023, 0x508D,
	0x574A, 0x59A8, 0x5C28, 0x5E47, 0x5F77, 0x623F, 0x653E, 0x65B9,
	0x65C1, 0x6609, 0x678B, 0x699C, 0x6EC2, 0x78C5, 0x7D21, 0x80AA,
	0x8180, 0x822B, 0x82B3, 0x84A1, 0x868C, 0x8A2A, 0x8B17, 0x90A6,
	0x9632, 0x9F90, 0x500D, 0x4FF3, 0xF963, 0x57F9, 0x5F98, 0x62DC,
	0x6392, 0x676F, 0x6E43, 0x7119, 0x76C3, 0x80CC, 0x80DA, 0x88F4,
	0x88F5, 0x8919, 0x8CE0, 0x8F29, 0x914D, 0x966A, 0x4F2F, 0x4F70,
	0x5E1B, 0x67CF, 0x6822, 0x767D, 0x767E, 0x9B44, 0x5E61, 0x6A0A,
	0x7169, 0x71D4, 0x756A, 0xF964, 0x7E41, 0x8543, 0x85E9, 0x98DC,
	0x4F10, 0x7B4F, 0x7F70, 0x95A5, 0x51E1, 0x5E06, 0x68B5, 0x6C3E,
	0x6C4E, 0x6CDB, 0x72AF, 0x7BC4, 0x8303, 0x6CD5, 0x743A, 0x50FB,
	0x5288, 0x58C1, 0x64D8, 0x6A97, 0x74A7, 0x7656,

	0x78A7, 0x8617, 0x95E2, 0x9739, 0xF965, 0x535E, 0x5F01, 0x8B8A,
	0x8FA8, 0x8FAF, 0x908A, 0x5225, 0x77A5, 0x9C49, 0x9F08, 0x4E19,
	0x5002, 0x5175, 0x5C5B, 0x5E77, 0x661E, 0x663A, 0x67C4, 0x68C5,
	0x70B3, 0x7501, 0x75C5, 0x79C9, 0x7ADD, 0x8F27, 0x9920, 0x9A08,
	0x4FDD, 0x5821, 0x5831, 0x5BF6, 0x666E, 0x6B65, 0x6D11, 0x6E7A,
	0x6F7D, 0x73E4, 0x752B, 0x83E9, 0x88DC, 0x8913, 0x8B5C, 0x8F14,
	0x4F0F, 0x50D5, 0x5310, 0x535C, 0x5B93, 0x5FA9, 0x670D, 0x798F,
	0x8179, 0x832F, 0x8514, 0x8907, 0x8986, 0x8F39, 0x8F3B, 0x99A5,
	0x9C12, 0x672C, 0x4E76, 0x4FF8, 0x5949, 0x5C01, 0x5CEF, 0x5CF0,
	0x6367, 0x68D2, 0x70FD, 0x71A2, 0x742B, 0x7E2B, 0x84EC, 0x8702,
	0x9022, 0x92D2, 0x9CF3, 0x4E0D, 0x4ED8, 0x4FEF, 0x5085, 0x5256,
	0x526F, 0x5426, 0x5490, 0x57E0, 0x592B, 0x5A66,

	0x5B5A, 0x5B75, 0x5BCC, 0x5E9C, 0xF966, 0x6276, 0x6577, 0x65A7,
	0x6D6E, 0x6EA5, 0x7236, 0x7B26, 0x7C3F, 0x7F36, 0x8150, 0x8151,
	0x819A, 0x8240, 0x8299, 0x83A9, 0x8A03, 0x8CA0, 0x8CE6, 0x8CFB,
	0x8D74, 0x8DBA, 0x90E8, 0x91DC, 0x961C, 0x9644, 0x99D9, 0x9CE7,
	0x5317, 0x5206, 0x5429, 0x5674, 0x58B3, 0x5954, 0x596E, 0x5FFF,
	0x61A4, 0x626E, 0x6610, 0x6C7E, 0x711A, 0x76C6, 0x7C89, 0x7CDE,
	0x7D1B, 0x82AC, 0x8CC1, 0x96F0, 0xF967, 0x4F5B, 0x5F17, 0x5F7F,
	0x62C2, 0x5D29, 0x670B, 0x68DA, 0x787C, 0x7E43, 0x9D6C, 0x4E15,
	0x5099, 0x5315, 0x532A, 0x5351, 0x5983, 0x5A62, 0x5E87, 0x60B2,
	0x618A, 0x6249, 0x6279, 0x6590, 0x6787, 0x69A7, 0x6BD4, 0x6BD6,
	0x6BD7, 0x6BD8, 0x6CB8, 0xF968, 0x7435, 0x75FA, 0x7812, 0x7891,
	0x79D5, 0x79D8, 0x7C83, 0x7DCB, 0x7FE1, 0x80A5,

	0x813E, 0x81C2, 0x83F2, 0x871A, 0x88E8, 0x8AB9, 0x8B6C, 0x8CBB,
	0x9119, 0x975E, 0x98DB, 0x9F3B, 0x56AC, 0x5B2A, 0x5F6C, 0x658C,
	0x6AB3, 0x6BAF, 0x6D5C, 0x6FF1, 0x7015, 0x725D, 0x73AD, 0x8CA7,
	0x8CD3, 0x983B, 0x6191, 0x6C37, 0x8058, 0x9A01, 0x4E4D, 0x4E8B,
	0x4E9B, 0x4ED5, 0x4F3A, 0x4F3C, 0x4F7F, 0x4FDF, 0x50FF, 0x53F2,
	0x53F8, 0x5506, 0x55E3, 0x56DB, 0x58EB, 0x5962, 0x5A11, 0x5BEB,
	0x5BFA, 0x5C04, 0x5DF3, 0x5E2B, 0x5F99, 0x601D, 0x6368, 0x659C,
	0x65AF, 0x67F6, 0x67FB, 0x68AD, 0x6B7B, 0x6C99, 0x6CD7, 0x6E23,
	0x7009, 0x7345, 0x7802, 0x793E, 0x7940, 0x7960, 0x79C1, 0x7BE9,
	0x7D17, 0x7D72, 0x8086, 0x820D, 0x838E, 0x84D1, 0x86C7, 0x88DF,
	0x8A50, 0x8A5E, 0x8B1D, 0x8CDC, 0x8D66, 0x8FAD, 0x90AA, 0x98FC,
	0x99DF, 0x9E9D, 0x524A, 0xF969, 0x6714, 0xF96A,

	0x5098, 0x522A, 0x5C71, 0x6563, 0x6C55, 0x73CA, 0x7523, 0x759D,
	0x7B97, 0x849C, 0x9178, 0x9730, 0x4E77, 0x6492, 0x6BBA, 0x715E,
	0x85A9, 0x4E09, 0xF96B, 0x6749, 0x68EE, 0x6E17, 0x829F, 0x8518,
	0x886B, 0x63F7, 0x6F81, 0x9212, 0x98AF, 0x4E0A, 0x50B7, 0x50CF,
	0x511F, 0x5546, 0x55AA, 0x5617, 0x5B40, 0x5C19, 0x5CE0, 0x5E38,
	0x5E8A, 0x5EA0, 0x5EC2, 0x60F3, 0x6851, 0x6A61, 0x6E58, 0x723D,
	0x7240, 0x72C0, 0x76F8, 0x7965, 0x7BB1, 0x7FD4, 0x88F3, 0x89F4,
	0x8A73, 0x8C61, 0x8CDE, 0x971C, 0x585E, 0x74BD, 0x8CFD, 0x55C7,
	0xF96C, 0x7A61, 0x7D22, 0x8272, 0x7272, 0x751F, 0x7525, 0xF96D,
	0x7B19, 0x5885, 0x58FB, 0x5DBC, 0x5E8F, 0x5EB6, 0x5F90, 0x6055,
	0x6292, 0x637F, 0x654D, 0x6691, 0x66D9, 0x66F8, 0x6816, 0x68F2,
	0x7280, 0x745E, 0x7B6E, 0x7D6E, 0x7DD6, 0x7F72,

	0x80E5, 0x8212, 0x85AF, 0x897F, 0x8A93, 0x901D, 0x92E4, 0x9ECD,
	0x9F20, 0x5915, 0x596D, 0x5E2D, 0x60DC, 0x6614, 0x6673, 0x6790,
	0x6C50, 0x6DC5, 0x6F5F, 0x77F3, 0x78A9, 0x84C6, 0x91CB, 0x932B,
	0x4ED9, 0x50CA, 0x5148, 0x5584, 0x5B0B, 0x5BA3, 0x6247, 0x657E,
	0x65CB, 0x6E32, 0x717D, 0x7401, 0x7444, 0x7487, 0x74BF, 0x766C,
	0x79AA, 0x7DDA, 0x7E55, 0x7FA8, 0x817A, 0x81B3, 0x8239, 0x861A,
	0x87EC, 0x8A75, 0x8DE3, 0x9078, 0x9291, 0x9425, 0x994D, 0x9BAE,
	0x5368, 0x5C51, 0x6954, 0x6CC4, 0x6D29, 0x6E2B, 0x820C, 0x859B,
	0x893B, 0x8A2D, 0x8AAA, 0x96EA, 0x9F67, 0x5261, 0x66B9, 0x6BB2,
	0x7E96, 0x87FE, 0x8D0D, 0x9583, 0x965D, 0x651D, 0x6D89, 0x71EE,
	0xF96E, 0x57CE, 0x59D3, 0x5BAC, 0x6027, 0x60FA, 0x6210, 0x661F,
	0x665F, 0x7329, 0x73F9, 0x76DB, 0x7701, 0x7B6C,

	0x8056, 0x8072, 0x8165, 0x8AA0, 0x9192, 0x4E16, 0x52E2, 0x6B72,
	0x6D17, 0x7A05, 0x7B39, 0x7D30, 0xF96F, 0x8CB0, 0x53EC, 0x562F,
	0x5851, 0x5BB5, 0x5C0F, 0x5C11, 0x5DE2, 0x6240, 0x6383, 0x6414,
	0x662D, 0x68B3, 0x6CBC, 0x6D88, 0x6EAF, 0x701F, 0x70A4, 0x71D2,
	0x7526, 0x758F, 0x758E, 0x7619, 0x7B11, 0x7BE0, 0x7C2B, 0x7D20,
	0x7D39, 0x852C, 0x856D, 0x8607, 0x8A34, 0x900D, 0x9061, 0x90B5,
	0x92B7, 0x97F6, 0x9A37, 0x4FD7, 0x5C6C, 0x675F, 0x6D91, 0x7C9F,
	0x7E8C, 0x8B16, 0x8D16, 0x901F, 0x5B6B, 0x5DFD, 0x640D, 0x84C0,
	0x905C, 0x98E1, 0x7387, 0x5B8B, 0x609A, 0x677E, 0x6DDE, 0x8A1F,
	0x8AA6, 0x9001, 0x980C, 0x5237, 0xF970, 0x7051, 0x788E, 0x9396,
	0x8870, 0x91D7, 0x4FEE, 0x53D7, 0x55FD, 0x56DA, 0x5782, 0x58FD,
	0x5AC2, 0x5B88, 0x5CAB, 0x5CC0, 0x5E25, 0x6101,

	0x620D, 0x624B, 0x6388, 0x641C, 0x6536, 0x6578, 0x6A39, 0x6B8A,
	0x6C34, 0x6D19, 0x6F31, 0x71E7, 0x72E9, 0x7378, 0x7407, 0x74B2,
	0x7626, 0x7761, 0x79C0, 0x7A57, 0x7AEA, 0x7CB9, 0x7D8F, 0x7DAC,
	0x7E61, 0x7F9E, 0x8129, 0x8331, 0x8490, 0x84DA, 0x85EA, 0x8896,
	0x8AB0, 0x8B90, 0x8F38, 0x9042, 0x9083, 0x916C, 0x9296, 0x92B9,
	0x968B, 0x96A7, 0x96A8, 0x96D6, 0x9700, 0x9808, 0x9996, 0x9AD3,
	0x9B1A, 0x53D4, 0x587E, 0x5919, 0x5B70, 0x5BBF, 0x6DD1, 0x6F5A,
	0x719F, 0x7421, 0x74B9, 0x8085, 0x83FD, 0x5DE1, 0x5F87, 0x5FAA,
	0x6042, 0x65EC, 0x6812, 0x696F, 0x6A53, 0x6B89, 0x6D35, 0x6DF3,
	0x73E3, 0x76FE, 0x77AC, 0x7B4D, 0x7D14, 0x8123, 0x821C, 0x8340,
	0x84F4, 0x8563, 0x8A62, 0x8AC4, 0x9187, 0x931E, 0x9806, 0x99B4,
	0x620C, 0x8853, 0x8FF0, 0x9265, 0x5D07, 0x5D27,

	0x5D69, 0x745F, 0x819D, 0x8768, 0x6FD5, 0x62FE, 0x7FD2, 0x8936,
	0x8972, 0x4E1E, 0x4E58, 0x50E7, 0x52DD, 0x5347, 0x627F, 0x6607,
	0x7E69, 0x8805, 0x965E, 0x4F8D, 0x5319, 0x5636, 0x59CB, 0x5AA4,
	0x5C38, 0x5C4E, 0x5C4D, 0x5E02, 0x5F11, 0x6043, 0x65BD, 0x662F,
	0x6642, 0x67BE, 0x67F4, 0x731C, 0x77E2, 0x793A, 0x7FC5, 0x8494,
	0x84CD, 0x8996, 0x8A66, 0x8A69, 0x8AE1, 0x8C55, 0x8C7A, 0x57F4,
	0x5BD4, 0x5F0F, 0x606F, 0x62ED, 0x690D, 0x6B96, 0x6E5C, 0x7184,
	0x7BD2, 0x8755, 0x8B58, 0x8EFE, 0x98DF, 0x98FE, 0x4F38, 0x4F81,
	0x4FE1, 0x547B, 0x5A20, 0x5BB8, 0x613C, 0x65B0, 0x6668, 0x71FC,
	0x7533, 0x795E, 0x7D33, 0x814E, 0x81E3, 0x8398, 0x85AA, 0x85CE,
	0x8703, 0x8A0A, 0x8EAB, 0x8F9B, 0xF971, 0x8FC5, 0x5931, 0x5BA4,
	0x5BE6, 0x6089, 0x5BE9, 0x5C0B, 0x5FC3, 0x6C81,

	0xF972, 0x6DF1, 0x700B, 0x751A, 0x82AF, 0x8AF6, 0x4EC0, 0x5341,
	0xF973, 0x96D9, 0x6C0F, 0x4E9E, 0x4FC4, 0x5152, 0x555E, 0x5A25,
	0x5CE8, 0x6211, 0x7259, 0x82BD, 0x83AA, 0x86FE, 0x8859, 0x8A1D,
	0x963F, 0x96C5, 0x9913, 0x9D09, 0x9D5D, 0x580A, 0x5CB3, 0x5DBD,
	0x5E44, 0x60E1, 0x6115, 0x63E1, 0x6A02, 0x6E25, 0x9102, 0x9354,
	0x984E, 0x9C10, 0x9F77, 0x5B89, 0x5CB8, 0x6309, 0x664F, 0x6848,
	0x773C, 0x96C1, 0x978D, 0x9854, 0x9B9F, 0x65A1, 0x8B01, 0x8ECB,
	0x95BC, 0x5535, 0x5CA9, 0x5DD6, 0x5EB5, 0x6697, 0x764C, 0x83F4,
	0x95C7, 0x58D3, 0x62BC, 0x72CE, 0x9D28, 0x4EF0, 0x592E, 0x600F,
	0x663B, 0x6B83, 0x79E7, 0x9D26, 0x5393, 0x54C0, 0x57C3, 0x5D16,
	0x611B, 0x66D6, 0x6DAF, 0x788D, 0x827E, 0x9698, 0x9744, 0x5384,
	0x627C, 0x6396, 0x6DB2, 0x7E0A, 0x814B, 0x984D,

	0x6AFB, 0x7F4C, 0x9DAF, 0x9E1A, 0x4E5F, 0x503B, 0x51B6, 0x591C,
	0x60F9, 0x63F6, 0x6930, 0x723A, 0x8036, 0xF974, 0x91CE, 0x5F31,
	0xF975, 0xF976, 0x7D04, 0x82E5, 0x846F, 0x84BB, 0x85E5, 0x8E8D,
	0xF977, 0x4F6F, 0xF978, 0xF979, 0x58E4, 0x5B43, 0x6059, 0x63DA,
	0x6518, 0x656D, 0x6698, 0xF97A, 0x694A, 0x6A23, 0x6D0B, 0x7001,
	0x716C, 0x75D2, 0x760D, 0x79B3, 0x7A70, 0xF97B, 0x7F8A, 0xF97C,
	0x8944, 0xF97D, 0x8B93, 0x91C0, 0x967D, 0xF97E, 0x990A, 0x5704,
	0x5FA1, 0x65BC, 0x6F01, 0x7600, 0x79A6, 0x8A9E, 0x99AD, 0x9B5A,
	0x9F6C, 0x5104, 0x61B6, 0x6291, 0x6A8D, 0x81C6, 0x5043, 0x5830,
	0x5F66, 0x7109, 0x8A00, 0x8AFA, 0x5B7C, 0x8616, 0x4FFA, 0x513C,
	0x56B4, 0x5944, 0x63A9, 0x6DF9, 0x5DAA, 0x696D, 0x5186, 0x4E88,
	0x4F59, 0xF97F, 0xF980, 0xF981, 0x5982, 0xF982,

	0xF983, 0x6B5F, 0x6C5D, 0xF984, 0x74B5, 0x7916, 0xF985, 0x8207,
	0x8245, 0x8339, 0x8F3F, 0x8F5D, 0xF986, 0x9918, 0xF987, 0xF988,
	0xF989, 0x4EA6, 0xF98A, 0x57DF, 0x5F79, 0x6613, 0xF98B, 0xF98C,
	0x75AB, 0x7E79, 0x8B6F, 0xF98D, 0x9006, 0x9A5B, 0x56A5, 0x5827,
	0x59F8, 0x5A1F, 0x5BB4, 0xF98E, 0x5EF6, 0xF98F, 0xF990, 0x6350,
	0x633B, 0xF991, 0x693D, 0x6C87, 0x6CBF, 0x6D8E, 0x6D93, 0x6DF5,
	0x6F14, 0xF992, 0x70DF, 0x7136, 0x7159, 0xF993, 0x71C3, 0x71D5,
	0xF994, 0x784F, 0x786F, 0xF995, 0x7B75, 0x7DE3, 0xF996, 0x7E2F,
	0xF997, 0x884D, 0x8EDF, 0xF998, 0xF999, 0xF99A, 0x925B, 0xF99B,
	0x9CF6, 0xF99C, 0xF99D, 0xF99E, 0x6085, 0x6D85, 0xF99F, 0x71B1,
	0xF9A0, 0xF9A1, 0x95B1, 0x53AD, 0xF9A2, 0xF9A3, 0xF9A4, 0x67D3,
	0xF9A5, 0x708E, 0x7130, 0x7430, 0x8276, 0x82D2,

	0xF9A6, 0x95BB, 0x9AE5, 0x9E7D, 0x66C4, 0xF9A7, 0x71C1, 0x8449,
	0xF9A8, 0xF9A9, 0x584B, 0xF9AA, 0xF9AB, 0x5DB8, 0x5F71, 0xF9AC,
	0x6620, 0x668E, 0x6979, 0x69AE, 0x6C38, 0x6CF3, 0x6E36, 0x6F41,
	0x6FDA, 0x701B, 0x702F, 0x7150, 0x71DF, 0x7370, 0xF9AD, 0x745B,
	0xF9AE, 0x74D4, 0x76C8, 0x7A4E, 0x7E93, 0xF9AF, 0xF9B0, 0x82F1,
	0x8A60, 0x8FCE, 0xF9B1, 0x9348, 0xF9B2, 0x9719, 0xF9B3, 0xF9B4,
	0x4E42, 0x502A, 0xF9B5, 0x5208, 0x53E1, 0x66F3, 0x6C6D, 0x6FCA,
	0x730A, 0x777F, 0x7A62, 0x82AE, 0x85DD, 0x8602, 0xF9B6, 0x88D4,
	0x8A63, 0x8B7D, 0x8C6B, 0xF9B7, 0x92B3, 0xF9B8, 0x9713, 0x9810,
	0x4E94, 0x4F0D, 0x4FC9, 0x50B2, 0x5348, 0x543E, 0x5433, 0x55DA,
	0x5862, 0x58BA, 0x5967, 0x5A1B, 0x5BE4, 0x609F, 0xF9B9, 0x61CA,
	0x6556, 0x65FF, 0x6664, 0x68A7, 0x6C5A, 0x6FB3,

	0x70CF, 0x71AC, 0x7352, 0x7B7D, 0x8708, 0x8AA4, 0x9C32, 0x9F07,
	0x5C4B, 0x6C83, 0x7344, 0x7389, 0x923A, 0x6EAB, 0x7465, 0x761F,
	0x7A69, 0x7E15, 0x860A, 0x5140, 0x58C5, 0x64C1, 0x74EE, 0x7515,
	0x7670, 0x7FC1, 0x9095, 0x96CD, 0x9954, 0x6E26, 0x74E6, 0x7AA9,
	0x7AAA, 0x81E5, 0x86D9, 0x8778, 0x8A1B, 0x5A49, 0x5B8C, 0x5B9B,
	0x68A1, 0x6900, 0x6D63, 0x73A9, 0x7413, 0x742C, 0x7897, 0x7DE9,
	0x7FEB, 0x8118, 0x8155, 0x839E, 0x8C4C, 0x962E, 0x9811, 0x66F0,
	0x5F80, 0x65FA, 0x6789, 0x6C6A, 0x738B, 0x502D, 0x5A03, 0x6B6A,
	0x77EE, 0x5916, 0x5D6C, 0x5DCD, 0x7325, 0x754F, 0xF9BA, 0xF9BB,
	0x50E5, 0x51F9, 0x582F, 0x592D, 0x5996, 0x59DA, 0x5BE5, 0xF9BC,
	0xF9BD, 0x5DA2, 0x62D7, 0x6416, 0x6493, 0x64FE, 0xF9BE, 0x66DC,
	0xF9BF, 0x6A48, 0xF9C0, 0x71FF, 0x7464, 0xF9C1,

	0x7A88, 0x7AAF, 0x7E47, 0x7E5E, 0x8000, 0x8170, 0xF9C2, 0x87EF,
	0x8981, 0x8B20, 0x9059, 0xF9C3, 0x9080, 0x9952, 0x617E, 0x6B32,
	0x6D74, 0x7E1F, 0x8925, 0x8FB1, 0x4FD1, 0x50AD, 0x5197, 0x52C7,
	0x57C7, 0x5889, 0x5BB9, 0x5EB8, 0x6142, 0x6995, 0x6D8C, 0x6E67,
	0x6EB6, 0x7194, 0x7462, 0x7528, 0x752C, 0x8073, 0x8338, 0x84C9,
	0x8E0A, 0x9394, 0x93DE, 0xF9C4, 0x4E8E, 0x4F51, 0x5076, 0x512A,
	0x53C8, 0x53CB, 0x53F3, 0x5B87, 0x5BD3, 0x5C24, 0x611A, 0x6182,
	0x65F4, 0x725B, 0x7397, 0x7440, 0x76C2, 0x7950, 0x7991, 0x79B9,
	0x7D06, 0x7FBD, 0x828B, 0x85D5, 0x865E, 0x8FC2, 0x9047, 0x90F5,
	0x91EA, 0x9685, 0x96E8, 0x96E9, 0x52D6, 0x5F67, 0x65ED, 0x6631,
	0x682F, 0x715C, 0x7A36, 0x90C1, 0x980A, 0x4E91, 0xF9C5, 0x6A52,
	0x6B9E, 0x6F90, 0x7189, 0x8018, 0x82B8, 0x8553,

	0x904B, 0x9695, 0x96F2, 0x97FB, 0x851A, 0x9B31, 0x4E90, 0x718A,
	0x96C4, 0x5143, 0x539F, 0x54E1, 0x5713, 0x5712, 0x57A3, 0x5A9B,
	0x5AC4, 0x5BC3, 0x6028, 0x613F, 0x63F4, 0x6C85, 0x6D39, 0x6E72,
	0x6E90, 0x7230, 0x733F, 0x7457, 0x82D1, 0x8881, 0x8F45, 0x9060,
	0xF9C6, 0x9662, 0x9858, 0x9D1B, 0x6708, 0x8D8A, 0x925E, 0x4F4D,
	0x5049, 0x50DE, 0x5371, 0x570D, 0x59D4, 0x5A01, 0x5C09, 0x6170,
	0x6690, 0x6E2D, 0x7232, 0x744B, 0x7DEF, 0x80C3, 0x840E, 0x8466,
	0x853F, 0x875F, 0x885B, 0x8918, 0x8B02, 0x9055, 0x97CB, 0x9B4F,
	0x4E73, 0x4F91, 0x5112, 0x516A, 0xF9C7, 0x552F, 0x55A9, 0x5B7A,
	0x5BA5, 0x5E7C, 0x5E7D, 0x5EBE, 0x60A0, 0x60DF, 0x6108, 0x6109,
	0x63C4, 0x6538, 0x6709, 0xF9C8, 0x67D4, 0x67DA, 0xF9C9, 0x6961,
	0x6962, 0x6CB9, 0x6D27, 0xF9CA, 0x6E38, 0xF9CB,

	0x6FE1, 0x7336, 0x7337, 0xF9CC, 0x745C, 0x7531, 0xF9CD, 0x7652,
	0xF9CE, 0xF9CF, 0x7DAD, 0x81FE, 0x8438, 0x88D5, 0x8A98, 0x8ADB,
	0x8AED, 0x8E30, 0x8E42, 0x904A, 0x903E, 0x907A, 0x9149, 0x91C9,
	0x936E, 0xF9D0, 0xF9D1, 0x5809, 0xF9D2, 0x6BD3, 0x8089, 0x80B2,
	0xF9D3, 0xF9D4, 0x5141, 0x596B, 0x5C39, 0xF9D5, 0xF9D6, 0x6F64,
	0x73A7, 0x80E4, 0x8D07, 0xF9D7, 0x9217, 0x958F, 0xF9D8, 0xF9D9,
	0xF9DA, 0xF9DB, 0x807F, 0x620E, 0x701C, 0x7D68, 0x878D, 0xF9DC,
	0x57A0, 0x6069, 0x6147, 0x6BB7, 0x8ABE, 0x9280, 0x96B1, 0x4E59,
	0x541F, 0x6DEB, 0x852D, 0x9670, 0x97F3, 0x98EE, 0x63D6, 0x6CE3,
	0x9091, 0x51DD, 0x61C9, 0x81BA, 0x9DF9, 0x4F9D, 0x501A, 0x5100,
	0x5B9C, 0x610F, 0x61FF, 0x64EC, 0x6905, 0x6BC5, 0x7591, 0x77E3,
	0x7FA9, 0x8264, 0x858F, 0x87FB, 0x8863, 0x8ABC,

	0x8B70, 0x91AB, 0x4E8C, 0x4EE5, 0x4F0A, 0xF9DD, 0xF9DE, 0x5937,
	0x59E8, 0xF9DF, 0x5DF2, 0x5F1B, 0x5F5B, 0x6021, 0xF9E0, 0xF9E1,
	0xF9E2, 0xF9E3, 0x723E, 0x73E5, 0xF9E4, 0x7570, 0x75CD, 0xF9E5,
	0x79FB, 0xF9E6, 0x800C, 0x8033, 0x8084, 0x82E1, 0x8351, 0xF9E7,
	0xF9E8, 0x8CBD, 0x8CB3, 0x9087, 0xF9E9, 0xF9EA, 0x98F4, 0x990C,
	0xF9EB, 0xF9EC, 0x7037, 0x76CA, 0x7FCA, 0x7FCC, 0x7FFC, 0x8B1A,
	0x4EBA, 0x4EC1, 0x5203, 0x5370, 0xF9ED, 0x54BD, 0x56E0, 0x59FB,
	0x5BC5, 0x5F15, 0x5FCD, 0x6E6E, 0xF9EE, 0xF9EF, 0x7D6A, 0x8335,
	0xF9F0, 0x8693, 0x8A8D, 0xF9F1, 0x976D, 0x9777, 0xF9F2, 0xF9F3,
	0x4E00, 0x4F5A, 0x4F7E, 0x58F9, 0x65E5, 0x6EA2, 0x9038, 0x93B0,
	0x99B9, 0x4EFB, 0x58EC, 0x598A, 0x59D9, 0x6041, 0xF9F4, 0xF9F5,
	0x7A14, 0xF9F6, 0x834F, 0x8CC3, 0x5165, 0x5344,

	0xF9F7, 0xF9F8, 0xF9F9, 0x4ECD, 0x5269, 0x5B55, 0x82BF, 0x4ED4,
	0x523A, 0x54A8, 0x59C9, 0x59FF, 0x5B50, 0x5B57, 0x5B5C, 0x6063,
	0x6148, 0x6ECB, 0x7099, 0x716E, 0x7386, 0x74F7, 0x75B5, 0x78C1,
	0x7D2B, 0x8005, 0x81EA, 0x8328, 0x8517, 0x85C9, 0x8AEE, 0x8CC7,
	0x96CC, 0x4F5C, 0x52FA, 0x56BC, 0x65AB, 0x6628, 0x707C, 0x70B8,
	0x7235, 0x7DBD, 0x828D, 0x914C, 0x96C0, 0x9D72, 0x5B71, 0x68E7,
	0x6B98, 0x6F7A, 0x76DE, 0x5C91, 0x66AB, 0x6F5B, 0x7BB4, 0x7C2A,
	0x8836, 0x96DC, 0x4E08, 0x4ED7, 0x5320, 0x5834, 0x58BB, 0x58EF,
	0x596C, 0x5C07, 0x5E33, 0x5E84, 0x5F35, 0x638C, 0x66B2, 0x6756,
	0x6A1F, 0x6AA3, 0x6B0C, 0x6F3F, 0x7246, 0xF9FA, 0x7350, 0x748B,
	0x7AE0, 0x7CA7, 0x8178, 0x81DF, 0x81E7, 0x838A, 0x846C, 0x8523,
	0x8594, 0x85CF, 0x88DD, 0x8D13, 0x91AC, 0x9577,

	0x969C, 0x518D, 0x54C9, 0x5728, 0x5BB0, 0x624D, 0x6750, 0x683D,
	0x6893, 0x6E3D, 0x6ED3, 0x707D, 0x7E21, 0x88C1, 0x8CA1, 0x8F09,
	0x9F4B, 0x9F4E, 0x722D, 0x7B8F, 0x8ACD, 0x931A, 0x4F47, 0x4F4E,
	0x5132, 0x5480, 0x59D0, 0x5E95, 0x62B5, 0x6775, 0x696E, 0x6A17,
	0x6CAE, 0x6E1A, 0x72D9, 0x732A, 0x75BD, 0x7BB8, 0x7D35, 0x82E7,
	0x83F9, 0x8457, 0x85F7, 0x8A5B, 0x8CAF, 0x8E87, 0x9019, 0x90B8,
	0x96CE, 0x9F5F, 0x52E3, 0x540A, 0x5AE1, 0x5BC2, 0x6458, 0x6575,
	0x6EF4, 0x72C4, 0xF9FB, 0x7684, 0x7A4D, 0x7B1B, 0x7C4D, 0x7E3E,
	0x7FDF, 0x837B, 0x8B2B, 0x8CCA, 0x8D64, 0x8DE1, 0x8E5F, 0x8FEA,
	0x8FF9, 0x9069, 0x93D1, 0x4F43, 0x4F7A, 0x50B3, 0x5168, 0x5178,
	0x524D, 0x526A, 0x5861, 0x587C, 0x5960, 0x5C08, 0x5C55, 0x5EDB,
	0x609B, 0x6230, 0x6813, 0x6BBF, 0x6C08, 0x6FB1,

	0x714E, 0x7420, 0x7530, 0x7538, 0x7551, 0x7672, 0x7B4C, 0x7B8B,
	0x7BAD, 0x7BC6, 0x7E8F, 0x8A6E, 0x8F3E, 0x8F49, 0x923F, 0x9293,
	0x9322, 0x942B, 0x96FB, 0x985A, 0x986B, 0x991E, 0x5207, 0x622A,
	0x6298, 0x6D59, 0x7664, 0x7ACA, 0x7BC0, 0x7D76, 0x5360, 0x5CBE,
	0x5E97, 0x6F38, 0x70B9, 0x7C98, 0x9711, 0x9B8E, 0x9EDE, 0x63A5,
	0x647A, 0x8776, 0x4E01, 0x4E95, 0x4EAD, 0x505C, 0x5075, 0x5448,
	0x59C3, 0x5B9A, 0x5E40, 0x5EAD, 0x5EF7, 0x5F81, 0x60C5, 0x633A,
	0x653F, 0x6574, 0x65CC, 0x6676, 0x6678, 0x67FE, 0x6968, 0x6A89,
	0x6B63, 0x6C40, 0x6DC0, 0x6DE8, 0x6E1F, 0x6E5E, 0x701E, 0x70A1,
	0x738E, 0x73FD, 0x753A, 0x775B, 0x7887, 0x798E, 0x7A0B, 0x7A7D,
	0x7CBE, 0x7D8E, 0x8247, 0x8A02, 0x8AEA, 0x8C9E, 0x912D, 0x914A,
	0x91D8, 0x9266, 0x92CC, 0x9320, 0x9706, 0x9756,

	0x975C, 0x9802, 0x9F0E, 0x5236, 0x5291, 0x557C, 0x5824, 0x5E1D,
	0x5F1F, 0x608C, 0x63D0, 0x68AF, 0x6FDF, 0x796D, 0x7B2C, 0x81CD,
	0x85BA, 0x88FD, 0x8AF8, 0x8E44, 0x918D, 0x9664, 0x969B, 0x973D,
	0x984C, 0x9F4A, 0x4FCE, 0x5146, 0x51CB, 0x52A9, 0x5632, 0x5F14,
	0x5F6B, 0x63AA, 0x64CD, 0x65E9, 0x6641, 0x66FA, 0x66F9, 0x671D,
	0x689D, 0x68D7, 0x69FD, 0x6F15, 0x6F6E, 0x7167, 0x71E5, 0x722A,
	0x74AA, 0x773A, 0x7956, 0x795A, 0x79DF, 0x7A20, 0x7A95, 0x7C97,
	0x7CDF, 0x7D44, 0x7E70, 0x8087, 0x85FB, 0x86A4, 0x8A54, 0x8ABF,
	0x8D99, 0x8E81, 0x9020, 0x906D, 0x91E3, 0x963B, 0x96D5, 0x9CE5,
	0x65CF, 0x7C07, 0x8DB3, 0x93C3, 0x5B58, 0x5C0A, 0x5352, 0x62D9,
	0x731D, 0x5027, 0x5B97, 0x5F9E, 0x60B0, 0x616B, 0x68D5, 0x6DD9,
	0x742E, 0x7A2E, 0x7D42, 0x7D9C, 0x7E31, 0x816B,

	0x8E2A, 0x8E35, 0x937E, 0x9418, 0x4F50, 0x5750, 0x5DE6, 0x5EA7,
	0x632B, 0x7F6A, 0x4E3B, 0x4F4F, 0x4F8F, 0x505A, 0x59DD, 0x80C4,
	0x546A, 0x5468, 0x55FE, 0x594F, 0x5B99, 0x5DDE, 0x5EDA, 0x665D,
	0x6731, 0x67F1, 0x682A, 0x6CE8, 0x6D32, 0x6E4A, 0x6F8D, 0x70B7,
	0x73E0, 0x7587, 0x7C4C, 0x7D02, 0x7D2C, 0x7DA2, 0x821F, 0x86DB,
	0x8A3B, 0x8A85, 0x8D70, 0x8E8A, 0x8F33, 0x9031, 0x914E, 0x9152,
	0x9444, 0x99D0, 0x7AF9, 0x7CA5, 0x4FCA, 0x5101, 0x51C6, 0x57C8,
	0x5BEF, 0x5CFB, 0x6659, 0x6A3D, 0x6D5A, 0x6E96, 0x6FEC, 0x710C,
	0x756F, 0x7AE3, 0x8822, 0x9021, 0x9075, 0x96CB, 0x99FF, 0x8301,
	0x4E2D, 0x4EF2, 0x8846, 0x91CD, 0x537D, 0x6ADB, 0x696B, 0x6C41,
	0x847A, 0x589E, 0x618E, 0x66FE, 0x62EF, 0x70DD, 0x7511, 0x75C7,
	0x7E52, 0x84B8, 0x8B49, 0x8D08, 0x4E4B, 0x53EA,

	0x54AB, 0x5730, 0x5740, 0x5FD7, 0x6301, 0x6307, 0x646F, 0x652F,
	0x65E8, 0x667A, 0x679D, 0x67B3, 0x6B62, 0x6C60, 0x6C9A, 0x6F2C,
	0x77E5, 0x7825, 0x7949, 0x7957, 0x7D19, 0x80A2, 0x8102, 0x81F3,
	0x829D, 0x82B7, 0x8718, 0x8A8C, 0xF9FC, 0x8D04, 0x8DBE, 0x9072,
	0x76F4, 0x7A19, 0x7A37, 0x7E54, 0x8077, 0x5507, 0x55D4, 0x5875,
	0x632F, 0x6422, 0x6649, 0x664B, 0x686D, 0x699B, 0x6B84, 0x6D25,
	0x6EB1, 0x73CD, 0x7468, 0x74A1, 0x755B, 0x75B9, 0x76E1, 0x771E,
	0x778B, 0x79E6, 0x7E09, 0x7E1D, 0x81FB, 0x852F, 0x8897, 0x8A3A,
	0x8CD1, 0x8EEB, 0x8FB0, 0x9032, 0x93AD, 0x9663, 0x9673, 0x9707,
	0x4F84, 0x53F1, 0x59EA, 0x5AC9, 0x5E19, 0x684E, 0x74C6, 0x75BE,
	0x79E9, 0x7A92, 0x81A3, 0x86ED, 0x8CEA, 0x8DCC, 0x8FED, 0x659F,
	0x6715, 0xF9FD, 0x57F7, 0x6F57, 0x7DDD, 0x8F2F,

	0x93F6, 0x96C6, 0x5FB5, 0x61F2, 0x6F84, 0x4E14, 0x4F98, 0x501F,
	0x53C9, 0x55DF, 0x5D6F, 0x5DEE, 0x6B21, 0x6B64, 0x78CB, 0x7B9A,
	0xF9FE, 0x8E49, 0x8ECA, 0x906E, 0x6349, 0x643E, 0x7740, 0x7A84,
	0x932F, 0x947F, 0x9F6A, 0x64B0, 0x6FAF, 0x71E6, 0x74A8, 0x74DA,
	0x7AC4, 0x7C12, 0x7E82, 0x7CB2, 0x7E98, 0x8B9A, 0x8D0A, 0x947D,
	0x9910, 0x994C, 0x5239, 0x5BDF, 0x64E6, 0x672D, 0x7D2E, 0x50ED,
	0x53C3, 0x5879, 0x6158, 0x6159, 0x61FA, 0x65AC, 0x7AD9, 0x8B92,
	0x8B96, 0x5009, 0x5021, 0x5275, 0x5531, 0x5A3C, 0x5EE0, 0x5F70,
	0x6134, 0x655E, 0x660C, 0x6636, 0x66A2, 0x69CD, 0x6EC4, 0x6F32,
	0x7316, 0x7621, 0x7A93, 0x8139, 0x8259, 0x83D6, 0x84BC, 0x50B5,
	0x57F0, 0x5BC0, 0x5BE8, 0x5F69, 0x63A1, 0x7826, 0x7DB5, 0x83DC,
	0x8521, 0x91C7, 0x91F5, 0x518A, 0x67F5, 0x7B56,

	0x8CAC, 0x51C4, 0x59BB, 0x60BD, 0x8655, 0x501C, 0xF9FF, 0x5254,
	0x5C3A, 0x617D, 0x621A, 0x62D3, 0x64F2, 0x65A5, 0x6ECC, 0x7620,
	0x810A, 0x8E60, 0x965F, 0x96BB, 0x4EDF, 0x5343, 0x5598, 0x5929,
	0x5DDD, 0x64C5, 0x6CC9, 0x6DFA, 0x7394, 0x7A7F, 0x821B, 0x85A6,
	0x8CE4, 0x8E10, 0x9077, 0x91E7, 0x95E1, 0x9621, 0x97C6, 0x51F8,
	0x54F2, 0x5586, 0x5FB9, 0x64A4, 0x6F88, 0x7DB4, 0x8F1F, 0x8F4D,
	0x9435, 0x50C9, 0x5C16, 0x6CBE, 0x6DFB, 0x751B, 0x77BB, 0x7C3D,
	0x7C64, 0x8A79, 0x8AC2, 0x581E, 0x59BE, 0x5E16, 0x6377, 0x7252,
	0x758A, 0x776B, 0x8ADC, 0x8CBC, 0x8F12, 0x5EF3, 0x6674, 0x6DF8,
	0x807D, 0x83C1, 0x8ACB, 0x9751, 0x9BD6, 0xFA00, 0x5243, 0x66FF,
	0x6D95, 0x6EEF, 0x7DE0, 0x8AE6, 0x902E, 0x905E, 0x9AD4, 0x521D,
	0x527F, 0x54E8, 0x6194, 0x6284, 0x62DB, 0x68A2,

	0x6912, 0x695A, 0x6A35, 0x7092, 0x7126, 0x785D, 0x7901, 0x790E,
	0x79D2, 0x7A0D, 0x8096, 0x8278, 0x82D5, 0x8349, 0x8549, 0x8C82,
	0x8D85, 0x9162, 0x918B, 0x91AE, 0x4FC3, 0x56D1, 0x71ED, 0x77D7,
	0x8700, 0x89F8, 0x5BF8, 0x5FD6, 0x6751, 0x90A8, 0x53E2, 0x585A,
	0x5BF5, 0x60A4, 0x6181, 0x6460, 0x7E3D, 0x8070, 0x8525, 0x9283,
	0x64AE, 0x50AC, 0x5D14, 0x6700, 0x589C, 0x62BD, 0x63A8, 0x690E,
	0x6978, 0x6A1E, 0x6E6B, 0x76BA, 0x79CB, 0x82BB, 0x8429, 0x8ACF,
	0x8DA8, 0x8FFD, 0x9112, 0x914B, 0x919C, 0x9310, 0x9318, 0x939A,
	0x96DB, 0x9A36, 0x9C0D, 0x4E11, 0x755C, 0x795D, 0x7AFA, 0x7B51,
	0x7BC9, 0x7E2E, 0x84C4, 0x8E59, 0x8E74, 0x8EF8, 0x9010, 0x6625,
	0x693F, 0x7443, 0x51FA, 0x672E, 0x9EDC, 0x5145, 0x5FE0, 0x6C96,
	0x87F2, 0x885D, 0x8877, 0x60B4, 0x81B5, 0x8403,

	0x8D05, 0x53D6, 0x5439, 0x5634, 0x5A36, 0x5C31, 0x708A, 0x7FE0,
	0x805A, 0x8106, 0x81ED, 0x8DA3, 0x9189, 0x9A5F, 0x9DF2, 0x5074,
	0x4EC4, 0x53A0, 0x60FB, 0x6E2C, 0x5C64, 0x4F88, 0x5024, 0x55E4,
	0x5CD9, 0x5E5F, 0x6065, 0x6894, 0x6CBB, 0x6DC4, 0x71BE, 0x75D4,
	0x75F4, 0x7661, 0x7A1A, 0x7A49, 0x7DC7, 0x7DFB, 0x7F6E, 0x81F4,
	0x86A9, 0x8F1C, 0x96C9, 0x99B3, 0x9F52, 0x5247, 0x52C5, 0x98ED,
	0x89AA, 0x4E03, 0x67D2, 0x6F06, 0x4FB5, 0x5BE2, 0x6795, 0x6C88,
	0x6D78, 0x741B, 0x7827, 0x91DD, 0x937C, 0x87C4, 0x79E4, 0x7A31,
	0x5FEB, 0x4ED6, 0x54A4, 0x553E, 0x58AE, 0x59A5, 0x60F0, 0x6253,
	0x62D6, 0x6736, 0x6955, 0x8235, 0x9640, 0x99B1, 0x99DD, 0x502C,
	0x5353, 0x5544, 0x577C, 0xFA01, 0x6258, 0xFA02, 0x64E2, 0x666B,
	0x67DD, 0x6FC1, 0x6FEF, 0x7422, 0x7438, 0x8A17,

	0x9438, 0x5451, 0x5606, 0x5766, 0x5F48, 0x619A, 0x6B4E, 0x7058,
	0x70AD, 0x7DBB, 0x8A95, 0x596A, 0x812B, 0x63A2, 0x7708, 0x803D,
	0x8CAA, 0x5854, 0x642D, 0x69BB, 0x5B95, 0x5E11, 0x6E6F, 0xFA03,
	0x8569, 0x514C, 0x53F0, 0x592A, 0x6020, 0x614B, 0x6B86, 0x6C70,
	0x6CF0, 0x7B1E, 0x80CE, 0x82D4, 0x8DC6, 0x90B0, 0x98B1, 0xFA04,
	0x64C7, 0x6FA4, 0x6491, 0x6504, 0x514E, 0x5410, 0x571F, 0x8A0E,
	0x615F, 0x6876, 0xFA05, 0x75DB, 0x7B52, 0x7D71, 0x901A, 0x5806,
	0x69CC, 0x817F, 0x892A, 0x9000, 0x9839, 0x5078, 0x5957, 0x59AC,
	0x6295, 0x900F, 0x9B2A, 0x615D, 0x7279, 0x95D6, 0x5761, 0x5A46,
	0x5DF4, 0x628A, 0x64AD, 0x64FA, 0x6777, 0x6CE2, 0x6D3E, 0x722C,
	0x7436, 0x7834, 0x7F77, 0x82AD, 0x8DDB, 0x9817, 0x5224, 0x5742,
	0x677F, 0x7248, 0x74E3, 0x8CA9, 0x8FA6, 0x9211,

	0x962A, 0x516B, 0x53ED, 0x634C, 0x4F69, 0x5504, 0x6096, 0x6557,
	0x6C9B, 0x6D7F, 0x724C, 0x72FD, 0x7A17, 0x8987, 0x8C9D, 0x5F6D,
	0x6F8E, 0x70F9, 0x81A8, 0x610E, 0x4FBF, 0x504F, 0x6241, 0x7247,
	0x7BC7, 0x7DE8, 0x7FE9, 0x904D, 0x97AD, 0x9A19, 0x8CB6, 0x576A,
	0x5E73, 0x67B0, 0x840D, 0x8A55, 0x5420, 0x5B16, 0x5E63, 0x5EE2,
	0x5F0A, 0x6583, 0x80BA, 0x853D, 0x9589, 0x965B, 0x4F48, 0x5305,
	0x530D, 0x530F, 0x5486, 0x54FA, 0x5703, 0x5E03, 0x6016, 0x629B,
	0x62B1, 0x6355, 0xFA06, 0x6CE1, 0x6D66, 0x75B1, 0x7832, 0x80DE,
	0x812F, 0x82DE, 0x8461, 0x84B2, 0x888D, 0x8912, 0x900B, 0x92EA,
	0x98FD, 0x9B91, 0x5E45, 0x66B4, 0x66DD, 0x7011, 0x7206, 0xFA07,
	0x4FF5, 0x527D, 0x5F6A, 0x6153, 0x6753, 0x6A19, 0x6F02, 0x74E2,
	0x7968, 0x8868, 0x8C79, 0x98C7, 0x98C4, 0x9A43,

	0x54C1, 0x7A1F, 0x6953, 0x8AF7, 0x8C4A, 0x98A8, 0x99AE, 0x5F7C,
	0x62AB, 0x75B2, 0x76AE, 0x88AB, 0x907F, 0x9642, 0x5339, 0x5F3C,
	0x5FC5, 0x6CCC, 0x73CC, 0x7562, 0x758B, 0x7B46, 0x82FE, 0x999D,
	0x4E4F, 0x903C, 0x4E0B, 0x4F55, 0x53A6, 0x590F, 0x5EC8, 0x6630,
	0x6CB3, 0x7455, 0x8377, 0x8766, 0x8CC0, 0x9050, 0x971E, 0x9C15,
	0x58D1, 0x5B78, 0x8650, 0x8B14, 0x9DB4, 0x5BD2, 0x6068, 0x608D,
	0x65F1, 0x6C57, 0x6F22, 0x6FA3, 0x701A, 0x7F55, 0x7FF0, 0x9591,
	0x9592, 0x9650, 0x97D3, 0x5272, 0x8F44, 0x51FD, 0x542B, 0x54B8,
	0x5563, 0x558A, 0x6ABB, 0x6DB5, 0x7DD8, 0x8266, 0x929C, 0x9677,
	0x9E79, 0x5408, 0x54C8, 0x76D2, 0x86E4, 0x95A4, 0x95D4, 0x965C,
	0x4EA2, 0x4F09, 0x59EE, 0x5AE6, 0x5DF7, 0x6052, 0x6297, 0x676D,
	0x6841, 0x6C86, 0x6E2F, 0x7F38, 0x809B, 0x822A,

	0xFA08, 0xFA09, 0x9805, 0x4EA5, 0x5055, 0x54B3, 0x5793, 0x595A,
	0x5B69, 0x5BB3, 0x61C8, 0x6977, 0x6D77, 0x7023, 0x87F9, 0x89E3,
	0x8A72, 0x8AE7, 0x9082, 0x99ED, 0x9AB8, 0x52BE, 0x6838, 0x5016,
	0x5E78, 0x674F, 0x8347, 0x884C, 0x4EAB, 0x5411, 0x56AE, 0x73E6,
	0x9115, 0x97FF, 0x9909, 0x9957, 0x9999, 0x5653, 0x589F, 0x865B,
	0x8A31, 0x61B2, 0x6AF6, 0x737B, 0x8ED2, 0x6B47, 0x96AA, 0x9A57,
	0x5955, 0x7200, 0x8D6B, 0x9769, 0x4FD4, 0x5CF4, 0x5F26, 0x61F8,
	0x665B, 0x6CEB, 0x70AB, 0x7384, 0x73B9, 0x73FE, 0x7729, 0x774D,
	0x7D43, 0x7D62, 0x7E23, 0x8237, 0x8852, 0xFA0A, 0x8CE2, 0x9249,
	0x986F, 0x5B51, 0x7A74, 0x8840, 0x9801, 0x5ACC, 0x4FE0, 0x5354,
	0x593E, 0x5CFD, 0x633E, 0x6D79, 0x72F9, 0x8105, 0x8107, 0x83A2,
	0x92CF, 0x9830, 0x4EA8, 0x5144, 0x5211, 0x578B,

	0x5F62, 0x6CC2, 0x6ECE, 0x7005, 0x7050, 0x70AF, 0x7192, 0x73E9,
	0x7469, 0x834A, 0x87A2, 0x8861, 0x9008, 0x90A2, 0x93A3, 0x99A8,
	0x516E, 0x5F57, 0x60E0, 0x6167, 0x66B3, 0x8559, 0x8E4A, 0x91AF,
	0x978B, 0x4E4E, 0x4E92, 0x547C, 0x58D5, 0x58FA, 0x597D, 0x5CB5,
	0x5F27, 0x6236, 0x6248, 0x660A, 0x6667, 0x6BEB, 0x6D69, 0x6DCF,
	0x6E56, 0x6EF8, 0x6F94, 0x6FE0, 0x6FE9, 0x705D, 0x72D0, 0x7425,
	0x745A, 0x74E0, 0x7693, 0x795C, 0x7CCA, 0x7E1E, 0x80E1, 0x82A6,
	0x846B, 0x84BF, 0x864E, 0x865F, 0x8774, 0x8B77, 0x8C6A, 0x93AC,
	0x9800, 0x9865, 0x60D1, 0x6216, 0x9177, 0x5A5A, 0x660F, 0x6DF7,
	0x6E3E, 0x743F, 0x9B42, 0x5FFD, 0x60DA, 0x7B0F, 0x54C4, 0x5F18,
	0x6C5E, 0x6CD3, 0x6D2A, 0x70D8, 0x7D05, 0x8679, 0x8A0C, 0x9D3B,
	0x5316, 0x548C, 0x5B05, 0x6A3A, 0x706B, 0x7575,

	0x798D, 0x79BE, 0x82B1, 0x83EF, 0x8A71, 0x8B41, 0x8CA8, 0x9774,
	0xFA0B, 0x64F4, 0x652B, 0x78BA, 0x78BB, 0x7A6B, 0x4E38, 0x559A,
	0x5950, 0x5BA6, 0x5E7B, 0x60A3, 0x63DB, 0x6B61, 0x6665, 0x6853,
	0x6E19, 0x7165, 0x74B0, 0x7D08, 0x9084, 0x9A69, 0x9C25, 0x6D3B,
	0x6ED1, 0x733E, 0x8C41, 0x95CA, 0x51F0, 0x5E4C, 0x5FA8, 0x604D,
	0x60F6, 0x6130, 0x614C, 0x6643, 0x6644, 0x69A5, 0x6CC1, 0x6E5F,
	0x6EC9, 0x6F62, 0x714C, 0x749C, 0x7687, 0x7BC1, 0x7C27, 0x8352,
	0x8757, 0x9051, 0x968D, 0x9EC3, 0x532F, 0x56DE, 0x5EFB, 0x5F8A,
	0x6062, 0x6094, 0x61F7, 0x6666, 0x6703, 0x6A9C, 0x6DEE, 0x6FAE,
	0x7070, 0x736A, 0x7E6A, 0x81BE, 0x8334, 0x86D4, 0x8AA8, 0x8CC4,
	0x5283, 0x7372, 0x5B96, 0x6A6B, 0x9404, 0x54EE, 0x5686, 0x5B5D,
	0x6548, 0x6585, 0x66C9, 0x689F, 0x6D8D, 0x6DC6,

	0x723B, 0x80B4, 0x9175, 0x9A4D, 0x4FAF, 0x5019, 0x539A, 0x540E,
	0x543C, 0x5589, 0x55C5, 0x5E3F, 0x5F8C, 0x673D, 0x7166, 0x73DD,
	0x9005, 0x52DB, 0x52F3, 0x5864, 0x58CE, 0x7104, 0x718F, 0x71FB,
	0x85B0, 0x8A13, 0x6688, 0x85A8, 0x55A7, 0x6684, 0x714A, 0x8431,
	0x5349, 0x5599, 0x6BC1, 0x5F59, 0x5FBD, 0x63EE, 0x6689, 0x7147,
	0x8AF1, 0x8F1D, 0x9EBE, 0x4F11, 0x643A, 0x70CB, 0x7566, 0x8667,
	0x6064, 0x8B4E, 0x9DF8, 0x5147, 0x51F6, 0x5308, 0x6D36, 0x80F8,
	0x9ED1, 0x6615, 0x6B23, 0x7098, 0x75D5, 0x5403, 0x5C79, 0x7D07,
	0x8A16, 0x6B20, 0x6B3D, 0x6B46, 0x5438, 0x6070, 0x6D3D, 0x7FD5,
	0x8208, 0x50D6, 0x51DE, 0x559C, 0x566B, 0x56CD, 0x59EC, 0x5B09,
	0x5E0C, 0x6199, 0x6198, 0x6231, 0x665E, 0x66E6, 0x7199, 0x71B9,
	0x71BA, 0x72A7, 0x79A7, 0x7A00, 0x7FB2, 0x8A70

#if 0
	/* Undefined. XXX Who needs these? */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 
#endif
};

