/* Table for converting UTF-16 characters to KSC-5601 characters.
   Written by Bang Jun-Young, 2000.

   This table is in public domain and may be used for any purpose. */

/* NOTE: KSC-5601 has been replaced by the new standard KSX-1001 which 
   defines the same character sets. However, the name of KSX-1001 isn't
   popular as much as KSC-5601, so I've decided to keep the old name. */

const unsigned short utf16_ksc5601_table[2350] = {
	/* 2350 (= 94 * 25) Hangul syllables. There's no unified way to 
	   convert Unicode Hangul characters undefined in KSC-5601 to 
	   KSC-5601 characters. */
	0xb0a1, 0xb0a2, 0xb0a3, 0xb0a4, 0xb0a5, 0xb0a6, 0xb0a7, 0xb0a8,
	0xb0a9, 0xb0aa, 0xb0ab, 0xb0ac, 0xb0ad, 0xb0ae, 0xb0af, 0xb0b0,
	0xb0b1, 0xb0b2, 0xb0b3, 0xb0b4, 0xb0b5, 0xb0b6, 0xb0b7, 0xb0b8,
	0xb0b9, 0xb0ba, 0xb0bb, 0xb0bc, 0xb0bd, 0xb0be, 0xb0bf, 0xb0c0,
	0xb0c1, 0xb0c2, 0xb0c3, 0xb0c4, 0xb0c5, 0xb0c6, 0xb0c7, 0xb0c8,
	0xb0c9, 0xb0ca, 0xb0cb, 0xb0cc, 0xb0cd, 0xb0ce, 0xb0cf, 0xb0d0,
	0xb0d1, 0xb0d2, 0xb0d3, 0xb0d4, 0xb0d5, 0xb0d6, 0xb0d7, 0xb0d8,
	0xb0d9, 0xb0da, 0xb0db, 0xb0dc, 0xb0dd, 0xb0de, 0xb0df, 0xb0e0,
	0xb0e1, 0xb0e2, 0xb0e3, 0xb0e4, 0xb0e5, 0xb0e6, 0xb0e7, 0xb0e8,
	0xb0e9, 0xb0ea, 0xb0eb, 0xb0ec, 0xb0ed, 0xb0ee, 0xb0ef, 0xb0f0,
	0xb0f1, 0xb0f2, 0xb0f3, 0xb0f4, 0xb0f5, 0xb0f6, 0xb0f7, 0xb0f8,
	0xb0f9, 0xb0fa, 0xb0fb, 0xb0fc, 0xb0fd, 0xb0fe, 0xb1a1, 0xb1a2,
	0xb1a3, 0xb1a4, 0xb1a5, 0xb1a6, 0xb1a7, 0xb1a8, 0xb1a9, 0xb1aa,
	0xb1ab, 0xb1ac, 0xb1ad, 0xb1ae, 0xb1af, 0xb1b0, 0xb1b1, 0xb1b2,
	0xb1b3, 0xb1b4, 0xb1b5, 0xb1b6, 0xb1b7, 0xb1b8, 0xb1b9, 0xb1ba,
	0xb1bb, 0xb1bc, 0xb1bd, 0xb1be, 0xb1bf, 0xb1c0, 0xb1c1, 0xb1c2,
	0xb1c3, 0xb1c4, 0xb1c5, 0xb1c6, 0xb1c7, 0xb1c8, 0xb1c9, 0xb1ca,
	0xb1cb, 0xb1cc, 0xb1cd, 0xb1ce, 0xb1cf, 0xb1d0, 0xb1d1, 0xb1d2,
	0xb1d3, 0xb1d4, 0xb1d5, 0xb1d6, 0xb1d7, 0xb1d8, 0xb1d9, 0xb1da,
	0xb1db, 0xb1dc, 0xb1dd, 0xb1de, 0xb1df, 0xb1e0, 0xb1e1, 0xb1e2,
	0xb1e3, 0xb1e4, 0xb1e5, 0xb1e6, 0xb1e7, 0xb1e8, 0xb1e9, 0xb1ea,
	0xb1eb, 0xb1ec, 0xb1ed, 0xb1ee, 0xb1ef, 0xb1f0, 0xb1f1, 0xb1f2,
	0xb1f3, 0xb1f4, 0xb1f5, 0xb1f6, 0xb1f7, 0xb1f8, 0xb1f9, 0xb1fa,
	0xb1fb, 0xb1fc, 0xb1fd, 0xb1fe, 0xb2a1, 0xb2a2, 0xb2a3, 0xb2a4,
	0xb2a5, 0xb2a6, 0xb2a7, 0xb2a8, 0xb2a9, 0xb2aa, 0xb2ab, 0xb2ac,
	0xb2ad, 0xb2ae, 0xb2af, 0xb2b0, 0xb2b1, 0xb2b2, 0xb2b3, 0xb2b4,
	0xb2b5, 0xb2b6, 0xb2b7, 0xb2b8, 0xb2b9, 0xb2ba, 0xb2bb, 0xb2bc,
	0xb2bd, 0xb2be, 0xb2bf, 0xb2c0, 0xb2c1, 0xb2c2, 0xb2c3, 0xb2c4,
	0xb2c5, 0xb2c6, 0xb2c7, 0xb2c8, 0xb2c9, 0xb2ca, 0xb2cb, 0xb2cc,
	0xb2cd, 0xb2ce, 0xb2cf, 0xb2d0, 0xb2d1, 0xb2d2, 0xb2d3, 0xb2d4,
	0xb2d5, 0xb2d6, 0xb2d7, 0xb2d8, 0xb2d9, 0xb2da, 0xb2db, 0xb2dc,
	0xb2dd, 0xb2de, 0xb2df, 0xb2e0, 0xb2e1, 0xb2e2, 0xb2e3, 0xb2e4,
	0xb2e5, 0xb2e6, 0xb2e7, 0xb2e8, 0xb2e9, 0xb2ea, 0xb2eb, 0xb2ec,
	0xb2ed, 0xb2ee, 0xb2ef, 0xb2f0, 0xb2f1, 0xb2f2, 0xb2f3, 0xb2f4,
	0xb2f5, 0xb2f6, 0xb2f7, 0xb2f8, 0xb2f9, 0xb2fa, 0xb2fb, 0xb2fc,
	0xb2fd, 0xb2fe, 0xb3a1, 0xb3a2, 0xb3a3, 0xb3a4, 0xb3a5, 0xb3a6,
	0xb3a7, 0xb3a8, 0xb3a9, 0xb3aa, 0xb3ab, 0xb3ac, 0xb3ad, 0xb3ae,
	0xb3af, 0xb3b0, 0xb3b1, 0xb3b2, 0xb3b3, 0xb3b4, 0xb3b5, 0xb3b6,
	0xb3b7, 0xb3b8, 0xb3b9, 0xb3ba, 0xb3bb, 0xb3bc, 0xb3bd, 0xb3be,
	0xb3bf, 0xb3c0, 0xb3c1, 0xb3c2, 0xb3c3, 0xb3c4, 0xb3c5, 0xb3c6,
	0xb3c7, 0xb3c8, 0xb3c9, 0xb3ca, 0xb3cb, 0xb3cc, 0xb3cd, 0xb3ce,
	0xb3cf, 0xb3d0, 0xb3d1, 0xb3d2, 0xb3d3, 0xb3d4, 0xb3d5, 0xb3d6,
	0xb3d7, 0xb3d8, 0xb3d9, 0xb3da, 0xb3db, 0xb3dc, 0xb3dd, 0xb3de,
	0xb3df, 0xb3e0, 0xb3e1, 0xb3e2, 0xb3e3, 0xb3e4, 0xb3e5, 0xb3e6,
	0xb3e7, 0xb3e8, 0xb3e9, 0xb3ea, 0xb3eb, 0xb3ec, 0xb3ed, 0xb3ee,
	0xb3ef, 0xb3f0, 0xb3f1, 0xb3f2, 0xb3f3, 0xb3f4, 0xb3f5, 0xb3f6,
	0xb3f7, 0xb3f8, 0xb3f9, 0xb3fa, 0xb3fb, 0xb3fc, 0xb3fd, 0xb3fe,
	0xb4a1, 0xb4a2, 0xb4a3, 0xb4a4, 0xb4a5, 0xb4a6, 0xb4a7, 0xb4a8,
	0xb4a9, 0xb4aa, 0xb4ab, 0xb4ac, 0xb4ad, 0xb4ae, 0xb4af, 0xb4b0,
	0xb4b1, 0xb4b2, 0xb4b3, 0xb4b4, 0xb4b5, 0xb4b6, 0xb4b7, 0xb4b8,
	0xb4b9, 0xb4ba, 0xb4bb, 0xb4bc, 0xb4bd, 0xb4be, 0xb4bf, 0xb4c0,
	0xb4c1, 0xb4c2, 0xb4c3, 0xb4c4, 0xb4c5, 0xb4c6, 0xb4c7, 0xb4c8,
	0xb4c9, 0xb4ca, 0xb4cb, 0xb4cc, 0xb4cd, 0xb4ce, 0xb4cf, 0xb4d0,
	0xb4d1, 0xb4d2, 0xb4d3, 0xb4d4, 0xb4d5, 0xb4d6, 0xb4d7, 0xb4d8,
	0xb4d9, 0xb4da, 0xb4db, 0xb4dc, 0xb4dd, 0xb4de, 0xb4df, 0xb4e0,
	0xb4e1, 0xb4e2, 0xb4e3, 0xb4e4, 0xb4e5, 0xb4e6, 0xb4e7, 0xb4e8,
	0xb4e9, 0xb4ea, 0xb4eb, 0xb4ec, 0xb4ed, 0xb4ee, 0xb4ef, 0xb4f0,
	0xb4f1, 0xb4f2, 0xb4f3, 0xb4f4, 0xb4f5, 0xb4f6, 0xb4f7, 0xb4f8,
	0xb4f9, 0xb4fa, 0xb4fb, 0xb4fc, 0xb4fd, 0xb4fe, 0xb5a1, 0xb5a2,
	0xb5a3, 0xb5a4, 0xb5a5, 0xb5a6, 0xb5a7, 0xb5a8, 0xb5a9, 0xb5aa,
	0xb5ab, 0xb5ac, 0xb5ad, 0xb5ae, 0xb5af, 0xb5b0, 0xb5b1, 0xb5b2,
	0xb5b3, 0xb5b4, 0xb5b5, 0xb5b6, 0xb5b7, 0xb5b8, 0xb5b9, 0xb5ba,
	0xb5bb, 0xb5bc, 0xb5bd, 0xb5be, 0xb5bf, 0xb5c0, 0xb5c1, 0xb5c2,
	0xb5c3, 0xb5c4, 0xb5c5, 0xb5c6, 0xb5c7, 0xb5c8, 0xb5c9, 0xb5ca,
	0xb5cb, 0xb5cc, 0xb5cd, 0xb5ce, 0xb5cf, 0xb5d0, 0xb5d1, 0xb5d2,
	0xb5d3, 0xb5d4, 0xb5d5, 0xb5d6, 0xb5d7, 0xb5d8, 0xb5d9, 0xb5da,
	0xb5db, 0xb5dc, 0xb5dd, 0xb5de, 0xb5df, 0xb5e0, 0xb5e1, 0xb5e2,
	0xb5e3, 0xb5e4, 0xb5e5, 0xb5e6, 0xb5e7, 0xb5e8, 0xb5e9, 0xb5ea,
	0xb5eb, 0xb5ec, 0xb5ed, 0xb5ee, 0xb5ef, 0xb5f0, 0xb5f1, 0xb5f2,
	0xb5f3, 0xb5f4, 0xb5f5, 0xb5f6, 0xb5f7, 0xb5f8, 0xb5f9, 0xb5fa,
	0xb5fb, 0xb5fc, 0xb5fd, 0xb5fe, 0xb6a1, 0xb6a2, 0xb6a3, 0xb6a4,
	0xb6a5, 0xb6a6, 0xb6a7, 0xb6a8, 0xb6a9, 0xb6aa, 0xb6ab, 0xb6ac,
	0xb6ad, 0xb6ae, 0xb6af, 0xb6b0, 0xb6b1, 0xb6b2, 0xb6b3, 0xb6b4,
	0xb6b5, 0xb6b6, 0xb6b7, 0xb6b8, 0xb6b9, 0xb6ba, 0xb6bb, 0xb6bc,
	0xb6bd, 0xb6be, 0xb6bf, 0xb6c0, 0xb6c1, 0xb6c2, 0xb6c3, 0xb6c4,
	0xb6c5, 0xb6c6, 0xb6c7, 0xb6c8, 0xb6c9, 0xb6ca, 0xb6cb, 0xb6cc,
	0xb6cd, 0xb6ce, 0xb6cf, 0xb6d0, 0xb6d1, 0xb6d2, 0xb6d3, 0xb6d4,
	0xb6d5, 0xb6d6, 0xb6d7, 0xb6d8, 0xb6d9, 0xb6da, 0xb6db, 0xb6dc,
	0xb6dd, 0xb6de, 0xb6df, 0xb6e0, 0xb6e1, 0xb6e2, 0xb6e3, 0xb6e4,
	0xb6e5, 0xb6e6, 0xb6e7, 0xb6e8, 0xb6e9, 0xb6ea, 0xb6eb, 0xb6ec,
	0xb6ed, 0xb6ee, 0xb6ef, 0xb6f0, 0xb6f1, 0xb6f2, 0xb6f3, 0xb6f4,
	0xb6f5, 0xb6f6, 0xb6f7, 0xb6f8, 0xb6f9, 0xb6fa, 0xb6fb, 0xb6fc,
	0xb6fd, 0xb6fe, 0xb7a1, 0xb7a2, 0xb7a3, 0xb7a4, 0xb7a5, 0xb7a6,
	0xb7a7, 0xb7a8, 0xb7a9, 0xb7aa, 0xb7ab, 0xb7ac, 0xb7ad, 0xb7ae,
	0xb7af, 0xb7b0, 0xb7b1, 0xb7b2, 0xb7b3, 0xb7b4, 0xb7b5, 0xb7b6,
	0xb7b7, 0xb7b8, 0xb7b9, 0xb7ba, 0xb7bb, 0xb7bc, 0xb7bd, 0xb7be,
	0xb7bf, 0xb7c0, 0xb7c1, 0xb7c2, 0xb7c3, 0xb7c4, 0xb7c5, 0xb7c6,
	0xb7c7, 0xb7c8, 0xb7c9, 0xb7ca, 0xb7cb, 0xb7cc, 0xb7cd, 0xb7ce,
	0xb7cf, 0xb7d0, 0xb7d1, 0xb7d2, 0xb7d3, 0xb7d4, 0xb7d5, 0xb7d6,
	0xb7d7, 0xb7d8, 0xb7d9, 0xb7da, 0xb7db, 0xb7dc, 0xb7dd, 0xb7de,
	0xb7df, 0xb7e0, 0xb7e1, 0xb7e2, 0xb7e3, 0xb7e4, 0xb7e5, 0xb7e6,
	0xb7e7, 0xb7e8, 0xb7e9, 0xb7ea, 0xb7eb, 0xb7ec, 0xb7ed, 0xb7ee,
	0xb7ef, 0xb7f0, 0xb7f1, 0xb7f2, 0xb7f3, 0xb7f4, 0xb7f5, 0xb7f6,
	0xb7f7, 0xb7f8, 0xb7f9, 0xb7fa, 0xb7fb, 0xb7fc, 0xb7fd, 0xb7fe,
	0xb8a1, 0xb8a2, 0xb8a3, 0xb8a4, 0xb8a5, 0xb8a6, 0xb8a7, 0xb8a8,
	0xb8a9, 0xb8aa, 0xb8ab, 0xb8ac, 0xb8ad, 0xb8ae, 0xb8af, 0xb8b0,
	0xb8b1, 0xb8b2, 0xb8b3, 0xb8b4, 0xb8b5, 0xb8b6, 0xb8b7, 0xb8b8,
	0xb8b9, 0xb8ba, 0xb8bb, 0xb8bc, 0xb8bd, 0xb8be, 0xb8bf, 0xb8c0,
	0xb8c1, 0xb8c2, 0xb8c3, 0xb8c4, 0xb8c5, 0xb8c6, 0xb8c7, 0xb8c8,
	0xb8c9, 0xb8ca, 0xb8cb, 0xb8cc, 0xb8cd, 0xb8ce, 0xb8cf, 0xb8d0,
	0xb8d1, 0xb8d2, 0xb8d3, 0xb8d4, 0xb8d5, 0xb8d6, 0xb8d7, 0xb8d8,
	0xb8d9, 0xb8da, 0xb8db, 0xb8dc, 0xb8dd, 0xb8de, 0xb8df, 0xb8e0,
	0xb8e1, 0xb8e2, 0xb8e3, 0xb8e4, 0xb8e5, 0xb8e6, 0xb8e7, 0xb8e8,
	0xb8e9, 0xb8ea, 0xb8eb, 0xb8ec, 0xb8ed, 0xb8ee, 0xb8ef, 0xb8f0,
	0xb8f1, 0xb8f2, 0xb8f3, 0xb8f4, 0xb8f5, 0xb8f6, 0xb8f7, 0xb8f8,
	0xb8f9, 0xb8fa, 0xb8fb, 0xb8fc, 0xb8fd, 0xb8fe, 0xb9a1, 0xb9a2,
	0xb9a3, 0xb9a4, 0xb9a5, 0xb9a6, 0xb9a7, 0xb9a8, 0xb9a9, 0xb9aa,
	0xb9ab, 0xb9ac, 0xb9ad, 0xb9ae, 0xb9af, 0xb9b0, 0xb9b1, 0xb9b2,
	0xb9b3, 0xb9b4, 0xb9b5, 0xb9b6, 0xb9b7, 0xb9b8, 0xb9b9, 0xb9ba,
	0xb9bb, 0xb9bc, 0xb9bd, 0xb9be, 0xb9bf, 0xb9c0, 0xb9c1, 0xb9c2,
	0xb9c3, 0xb9c4, 0xb9c5, 0xb9c6, 0xb9c7, 0xb9c8, 0xb9c9, 0xb9ca,
	0xb9cb, 0xb9cc, 0xb9cd, 0xb9ce, 0xb9cf, 0xb9d0, 0xb9d1, 0xb9d2,
	0xb9d3, 0xb9d4, 0xb9d5, 0xb9d6, 0xb9d7, 0xb9d8, 0xb9d9, 0xb9da,
	0xb9db, 0xb9dc, 0xb9dd, 0xb9de, 0xb9df, 0xb9e0, 0xb9e1, 0xb9e2,
	0xb9e3, 0xb9e4, 0xb9e5, 0xb9e6, 0xb9e7, 0xb9e8, 0xb9e9, 0xb9ea,
	0xb9eb, 0xb9ec, 0xb9ed, 0xb9ee, 0xb9ef, 0xb9f0, 0xb9f1, 0xb9f2,
	0xb9f3, 0xb9f4, 0xb9f5, 0xb9f6, 0xb9f7, 0xb9f8, 0xb9f9, 0xb9fa,
	0xb9fb, 0xb9fc, 0xb9fd, 0xb9fe, 0xbaa1, 0xbaa2, 0xbaa3, 0xbaa4,
	0xbaa5, 0xbaa6, 0xbaa7, 0xbaa8, 0xbaa9, 0xbaaa, 0xbaab, 0xbaac,
	0xbaad, 0xbaae, 0xbaaf, 0xbab0, 0xbab1, 0xbab2, 0xbab3, 0xbab4,
	0xbab5, 0xbab6, 0xbab7, 0xbab8, 0xbab9, 0xbaba, 0xbabb, 0xbabc,
	0xbabd, 0xbabe, 0xbabf, 0xbac0, 0xbac1, 0xbac2, 0xbac3, 0xbac4,
	0xbac5, 0xbac6, 0xbac7, 0xbac8, 0xbac9, 0xbaca, 0xbacb, 0xbacc,
	0xbacd, 0xbace, 0xbacf, 0xbad0, 0xbad1, 0xbad2, 0xbad3, 0xbad4,
	0xbad5, 0xbad6, 0xbad7, 0xbad8, 0xbad9, 0xbada, 0xbadb, 0xbadc,
	0xbadd, 0xbade, 0xbadf, 0xbae0, 0xbae1, 0xbae2, 0xbae3, 0xbae4,
	0xbae5, 0xbae6, 0xbae7, 0xbae8, 0xbae9, 0xbaea, 0xbaeb, 0xbaec,
	0xbaed, 0xbaee, 0xbaef, 0xbaf0, 0xbaf1, 0xbaf2, 0xbaf3, 0xbaf4,
	0xbaf5, 0xbaf6, 0xbaf7, 0xbaf8, 0xbaf9, 0xbafa, 0xbafb, 0xbafc,
	0xbafd, 0xbafe, 0xbba1, 0xbba2, 0xbba3, 0xbba4, 0xbba5, 0xbba6,
	0xbba7, 0xbba8, 0xbba9, 0xbbaa, 0xbbab, 0xbbac, 0xbbad, 0xbbae,
	0xbbaf, 0xbbb0, 0xbbb1, 0xbbb2, 0xbbb3, 0xbbb4, 0xbbb5, 0xbbb6,
	0xbbb7, 0xbbb8, 0xbbb9, 0xbbba, 0xbbbb, 0xbbbc, 0xbbbd, 0xbbbe,
	0xbbbf, 0xbbc0, 0xbbc1, 0xbbc2, 0xbbc3, 0xbbc4, 0xbbc5, 0xbbc6,
	0xbbc7, 0xbbc8, 0xbbc9, 0xbbca, 0xbbcb, 0xbbcc, 0xbbcd, 0xbbce,
	0xbbcf, 0xbbd0, 0xbbd1, 0xbbd2, 0xbbd3, 0xbbd4, 0xbbd5, 0xbbd6,
	0xbbd7, 0xbbd8, 0xbbd9, 0xbbda, 0xbbdb, 0xbbdc, 0xbbdd, 0xbbde,
	0xbbdf, 0xbbe0, 0xbbe1, 0xbbe2, 0xbbe3, 0xbbe4, 0xbbe5, 0xbbe6,
	0xbbe7, 0xbbe8, 0xbbe9, 0xbbea, 0xbbeb, 0xbbec, 0xbbed, 0xbbee,
	0xbbef, 0xbbf0, 0xbbf1, 0xbbf2, 0xbbf3, 0xbbf4, 0xbbf5, 0xbbf6,
	0xbbf7, 0xbbf8, 0xbbf9, 0xbbfa, 0xbbfb, 0xbbfc, 0xbbfd, 0xbbfe,
	0xbca1, 0xbca2, 0xbca3, 0xbca4, 0xbca5, 0xbca6, 0xbca7, 0xbca8,
	0xbca9, 0xbcaa, 0xbcab, 0xbcac, 0xbcad, 0xbcae, 0xbcaf, 0xbcb0,
	0xbcb1, 0xbcb2, 0xbcb3, 0xbcb4, 0xbcb5, 0xbcb6, 0xbcb7, 0xbcb8,
	0xbcb9, 0xbcba, 0xbcbb, 0xbcbc, 0xbcbd, 0xbcbe, 0xbcbf, 0xbcc0,
	0xbcc1, 0xbcc2, 0xbcc3, 0xbcc4, 0xbcc5, 0xbcc6, 0xbcc7, 0xbcc8,
	0xbcc9, 0xbcca, 0xbccb, 0xbccc, 0xbccd, 0xbcce, 0xbccf, 0xbcd0,
	0xbcd1, 0xbcd2, 0xbcd3, 0xbcd4, 0xbcd5, 0xbcd6, 0xbcd7, 0xbcd8,
	0xbcd9, 0xbcda, 0xbcdb, 0xbcdc, 0xbcdd, 0xbcde, 0xbcdf, 0xbce0,
	0xbce1, 0xbce2, 0xbce3, 0xbce4, 0xbce5, 0xbce6, 0xbce7, 0xbce8,
	0xbce9, 0xbcea, 0xbceb, 0xbcec, 0xbced, 0xbcee, 0xbcef, 0xbcf0,
	0xbcf1, 0xbcf2, 0xbcf3, 0xbcf4, 0xbcf5, 0xbcf6, 0xbcf7, 0xbcf8,
	0xbcf9, 0xbcfa, 0xbcfb, 0xbcfc, 0xbcfd, 0xbcfe, 0xbda1, 0xbda2,
	0xbda3, 0xbda4, 0xbda5, 0xbda6, 0xbda7, 0xbda8, 0xbda9, 0xbdaa,
	0xbdab, 0xbdac, 0xbdad, 0xbdae, 0xbdaf, 0xbdb0, 0xbdb1, 0xbdb2,
	0xbdb3, 0xbdb4, 0xbdb5, 0xbdb6, 0xbdb7, 0xbdb8, 0xbdb9, 0xbdba,
	0xbdbb, 0xbdbc, 0xbdbd, 0xbdbe, 0xbdbf, 0xbdc0, 0xbdc1, 0xbdc2,
	0xbdc3, 0xbdc4, 0xbdc5, 0xbdc6, 0xbdc7, 0xbdc8, 0xbdc9, 0xbdca,
	0xbdcb, 0xbdcc, 0xbdcd, 0xbdce, 0xbdcf, 0xbdd0, 0xbdd1, 0xbdd2,
	0xbdd3, 0xbdd4, 0xbdd5, 0xbdd6, 0xbdd7, 0xbdd8, 0xbdd9, 0xbdda,
	0xbddb, 0xbddc, 0xbddd, 0xbdde, 0xbddf, 0xbde0, 0xbde1, 0xbde2,
	0xbde3, 0xbde4, 0xbde5, 0xbde6, 0xbde7, 0xbde8, 0xbde9, 0xbdea,
	0xbdeb, 0xbdec, 0xbded, 0xbdee, 0xbdef, 0xbdf0, 0xbdf1, 0xbdf2,
	0xbdf3, 0xbdf4, 0xbdf5, 0xbdf6, 0xbdf7, 0xbdf8, 0xbdf9, 0xbdfa,
	0xbdfb, 0xbdfc, 0xbdfd, 0xbdfe, 0xbea1, 0xbea2, 0xbea3, 0xbea4,
	0xbea5, 0xbea6, 0xbea7, 0xbea8, 0xbea9, 0xbeaa, 0xbeab, 0xbeac,
	0xbead, 0xbeae, 0xbeaf, 0xbeb0, 0xbeb1, 0xbeb2, 0xbeb3, 0xbeb4,
	0xbeb5, 0xbeb6, 0xbeb7, 0xbeb8, 0xbeb9, 0xbeba, 0xbebb, 0xbebc,
	0xbebd, 0xbebe, 0xbebf, 0xbec0, 0xbec1, 0xbec2, 0xbec3, 0xbec4,
	0xbec5, 0xbec6, 0xbec7, 0xbec8, 0xbec9, 0xbeca, 0xbecb, 0xbecc,
	0xbecd, 0xbece, 0xbecf, 0xbed0, 0xbed1, 0xbed2, 0xbed3, 0xbed4,
	0xbed5, 0xbed6, 0xbed7, 0xbed8, 0xbed9, 0xbeda, 0xbedb, 0xbedc,
	0xbedd, 0xbede, 0xbedf, 0xbee0, 0xbee1, 0xbee2, 0xbee3, 0xbee4,
	0xbee5, 0xbee6, 0xbee7, 0xbee8, 0xbee9, 0xbeea, 0xbeeb, 0xbeec,
	0xbeed, 0xbeee, 0xbeef, 0xbef0, 0xbef1, 0xbef2, 0xbef3, 0xbef4,
	0xbef5, 0xbef6, 0xbef7, 0xbef8, 0xbef9, 0xbefa, 0xbefb, 0xbefc,
	0xbefd, 0xbefe, 0xbfa1, 0xbfa2, 0xbfa3, 0xbfa4, 0xbfa5, 0xbfa6,
	0xbfa7, 0xbfa8, 0xbfa9, 0xbfaa, 0xbfab, 0xbfac, 0xbfad, 0xbfae,
	0xbfaf, 0xbfb0, 0xbfb1, 0xbfb2, 0xbfb3, 0xbfb4, 0xbfb5, 0xbfb6,
	0xbfb7, 0xbfb8, 0xbfb9, 0xbfba, 0xbfbb, 0xbfbc, 0xbfbd, 0xbfbe,
	0xbfbf, 0xbfc0, 0xbfc1, 0xbfc2, 0xbfc3, 0xbfc4, 0xbfc5, 0xbfc6,
	0xbfc7, 0xbfc8, 0xbfc9, 0xbfca, 0xbfcb, 0xbfcc, 0xbfcd, 0xbfce,
	0xbfcf, 0xbfd0, 0xbfd1, 0xbfd2, 0xbfd3, 0xbfd4, 0xbfd5, 0xbfd6,
	0xbfd7, 0xbfd8, 0xbfd9, 0xbfda, 0xbfdb, 0xbfdc, 0xbfdd, 0xbfde,
	0xbfdf, 0xbfe0, 0xbfe1, 0xbfe2, 0xbfe3, 0xbfe4, 0xbfe5, 0xbfe6,
	0xbfe7, 0xbfe8, 0xbfe9, 0xbfea, 0xbfeb, 0xbfec, 0xbfed, 0xbfee,
	0xbfef, 0xbff0, 0xbff1, 0xbff2, 0xbff3, 0xbff4, 0xbff5, 0xbff6,
	0xbff7, 0xbff8, 0xbff9, 0xbffa, 0xbffb, 0xbffc, 0xbffd, 0xbffe,
	0xc0a1, 0xc0a2, 0xc0a3, 0xc0a4, 0xc0a5, 0xc0a6, 0xc0a7, 0xc0a8,
	0xc0a9, 0xc0aa, 0xc0ab, 0xc0ac, 0xc0ad, 0xc0ae, 0xc0af, 0xc0b0,
	0xc0b1, 0xc0b2, 0xc0b3, 0xc0b4, 0xc0b5, 0xc0b6, 0xc0b7, 0xc0b8,
	0xc0b9, 0xc0ba, 0xc0bb, 0xc0bc, 0xc0bd, 0xc0be, 0xc0bf, 0xc0c0,
	0xc0c1, 0xc0c2, 0xc0c3, 0xc0c4, 0xc0c5, 0xc0c6, 0xc0c7, 0xc0c8,
	0xc0c9, 0xc0ca, 0xc0cb, 0xc0cc, 0xc0cd, 0xc0ce, 0xc0cf, 0xc0d0,
	0xc0d1, 0xc0d2, 0xc0d3, 0xc0d4, 0xc0d5, 0xc0d6, 0xc0d7, 0xc0d8,
	0xc0d9, 0xc0da, 0xc0db, 0xc0dc, 0xc0dd, 0xc0de, 0xc0df, 0xc0e0,
	0xc0e1, 0xc0e2, 0xc0e3, 0xc0e4, 0xc0e5, 0xc0e6, 0xc0e7, 0xc0e8,
	0xc0e9, 0xc0ea, 0xc0eb, 0xc0ec, 0xc0ed, 0xc0ee, 0xc0ef, 0xc0f0,
	0xc0f1, 0xc0f2, 0xc0f3, 0xc0f4, 0xc0f5, 0xc0f6, 0xc0f7, 0xc0f8,
	0xc0f9, 0xc0fa, 0xc0fb, 0xc0fc, 0xc0fd, 0xc0fe, 0xc1a1, 0xc1a2,
	0xc1a3, 0xc1a4, 0xc1a5, 0xc1a6, 0xc1a7, 0xc1a8, 0xc1a9, 0xc1aa,
	0xc1ab, 0xc1ac, 0xc1ad, 0xc1ae, 0xc1af, 0xc1b0, 0xc1b1, 0xc1b2,
	0xc1b3, 0xc1b4, 0xc1b5, 0xc1b6, 0xc1b7, 0xc1b8, 0xc1b9, 0xc1ba,
	0xc1bb, 0xc1bc, 0xc1bd, 0xc1be, 0xc1bf, 0xc1c0, 0xc1c1, 0xc1c2,
	0xc1c3, 0xc1c4, 0xc1c5, 0xc1c6, 0xc1c7, 0xc1c8, 0xc1c9, 0xc1ca,
	0xc1cb, 0xc1cc, 0xc1cd, 0xc1ce, 0xc1cf, 0xc1d0, 0xc1d1, 0xc1d2,
	0xc1d3, 0xc1d4, 0xc1d5, 0xc1d6, 0xc1d7, 0xc1d8, 0xc1d9, 0xc1da,
	0xc1db, 0xc1dc, 0xc1dd, 0xc1de, 0xc1df, 0xc1e0, 0xc1e1, 0xc1e2,
	0xc1e3, 0xc1e4, 0xc1e5, 0xc1e6, 0xc1e7, 0xc1e8, 0xc1e9, 0xc1ea,
	0xc1eb, 0xc1ec, 0xc1ed, 0xc1ee, 0xc1ef, 0xc1f0, 0xc1f1, 0xc1f2,
	0xc1f3, 0xc1f4, 0xc1f5, 0xc1f6, 0xc1f7, 0xc1f8, 0xc1f9, 0xc1fa,
	0xc1fb, 0xc1fc, 0xc1fd, 0xc1fe, 0xc2a1, 0xc2a2, 0xc2a3, 0xc2a4,
	0xc2a5, 0xc2a6, 0xc2a7, 0xc2a8, 0xc2a9, 0xc2aa, 0xc2ab, 0xc2ac,
	0xc2ad, 0xc2ae, 0xc2af, 0xc2b0, 0xc2b1, 0xc2b2, 0xc2b3, 0xc2b4,
	0xc2b5, 0xc2b6, 0xc2b7, 0xc2b8, 0xc2b9, 0xc2ba, 0xc2bb, 0xc2bc,
	0xc2bd, 0xc2be, 0xc2bf, 0xc2c0, 0xc2c1, 0xc2c2, 0xc2c3, 0xc2c4,
	0xc2c5, 0xc2c6, 0xc2c7, 0xc2c8, 0xc2c9, 0xc2ca, 0xc2cb, 0xc2cc,
	0xc2cd, 0xc2ce, 0xc2cf, 0xc2d0, 0xc2d1, 0xc2d2, 0xc2d3, 0xc2d4,
	0xc2d5, 0xc2d6, 0xc2d7, 0xc2d8, 0xc2d9, 0xc2da, 0xc2db, 0xc2dc,
	0xc2dd, 0xc2de, 0xc2df, 0xc2e0, 0xc2e1, 0xc2e2, 0xc2e3, 0xc2e4,
	0xc2e5, 0xc2e6, 0xc2e7, 0xc2e8, 0xc2e9, 0xc2ea, 0xc2eb, 0xc2ec,
	0xc2ed, 0xc2ee, 0xc2ef, 0xc2f0, 0xc2f1, 0xc2f2, 0xc2f3, 0xc2f4,
	0xc2f5, 0xc2f6, 0xc2f7, 0xc2f8, 0xc2f9, 0xc2fa, 0xc2fb, 0xc2fc,
	0xc2fd, 0xc2fe, 0xc3a1, 0xc3a2, 0xc3a3, 0xc3a4, 0xc3a5, 0xc3a6,
	0xc3a7, 0xc3a8, 0xc3a9, 0xc3aa, 0xc3ab, 0xc3ac, 0xc3ad, 0xc3ae,
	0xc3af, 0xc3b0, 0xc3b1, 0xc3b2, 0xc3b3, 0xc3b4, 0xc3b5, 0xc3b6,
	0xc3b7, 0xc3b8, 0xc3b9, 0xc3ba, 0xc3bb, 0xc3bc, 0xc3bd, 0xc3be,
	0xc3bf, 0xc3c0, 0xc3c1, 0xc3c2, 0xc3c3, 0xc3c4, 0xc3c5, 0xc3c6,
	0xc3c7, 0xc3c8, 0xc3c9, 0xc3ca, 0xc3cb, 0xc3cc, 0xc3cd, 0xc3ce,
	0xc3cf, 0xc3d0, 0xc3d1, 0xc3d2, 0xc3d3, 0xc3d4, 0xc3d5, 0xc3d6,
	0xc3d7, 0xc3d8, 0xc3d9, 0xc3da, 0xc3db, 0xc3dc, 0xc3dd, 0xc3de,
	0xc3df, 0xc3e0, 0xc3e1, 0xc3e2, 0xc3e3, 0xc3e4, 0xc3e5, 0xc3e6,
	0xc3e7, 0xc3e8, 0xc3e9, 0xc3ea, 0xc3eb, 0xc3ec, 0xc3ed, 0xc3ee,
	0xc3ef, 0xc3f0, 0xc3f1, 0xc3f2, 0xc3f3, 0xc3f4, 0xc3f5, 0xc3f6,
	0xc3f7, 0xc3f8, 0xc3f9, 0xc3fa, 0xc3fb, 0xc3fc, 0xc3fd, 0xc3fe,
	0xc4a1, 0xc4a2, 0xc4a3, 0xc4a4, 0xc4a5, 0xc4a6, 0xc4a7, 0xc4a8,
	0xc4a9, 0xc4aa, 0xc4ab, 0xc4ac, 0xc4ad, 0xc4ae, 0xc4af, 0xc4b0,
	0xc4b1, 0xc4b2, 0xc4b3, 0xc4b4, 0xc4b5, 0xc4b6, 0xc4b7, 0xc4b8,
	0xc4b9, 0xc4ba, 0xc4bb, 0xc4bc, 0xc4bd, 0xc4be, 0xc4bf, 0xc4c0,
	0xc4c1, 0xc4c2, 0xc4c3, 0xc4c4, 0xc4c5, 0xc4c6, 0xc4c7, 0xc4c8,
	0xc4c9, 0xc4ca, 0xc4cb, 0xc4cc, 0xc4cd, 0xc4ce, 0xc4cf, 0xc4d0,
	0xc4d1, 0xc4d2, 0xc4d3, 0xc4d4, 0xc4d5, 0xc4d6, 0xc4d7, 0xc4d8,
	0xc4d9, 0xc4da, 0xc4db, 0xc4dc, 0xc4dd, 0xc4de, 0xc4df, 0xc4e0,
	0xc4e1, 0xc4e2, 0xc4e3, 0xc4e4, 0xc4e5, 0xc4e6, 0xc4e7, 0xc4e8,
	0xc4e9, 0xc4ea, 0xc4eb, 0xc4ec, 0xc4ed, 0xc4ee, 0xc4ef, 0xc4f0,
	0xc4f1, 0xc4f2, 0xc4f3, 0xc4f4, 0xc4f5, 0xc4f6, 0xc4f7, 0xc4f8,
	0xc4f9, 0xc4fa, 0xc4fb, 0xc4fc, 0xc4fd, 0xc4fe, 0xc5a1, 0xc5a2,
	0xc5a3, 0xc5a4, 0xc5a5, 0xc5a6, 0xc5a7, 0xc5a8, 0xc5a9, 0xc5aa,
	0xc5ab, 0xc5ac, 0xc5ad, 0xc5ae, 0xc5af, 0xc5b0, 0xc5b1, 0xc5b2,
	0xc5b3, 0xc5b4, 0xc5b5, 0xc5b6, 0xc5b7, 0xc5b8, 0xc5b9, 0xc5ba,
	0xc5bb, 0xc5bc, 0xc5bd, 0xc5be, 0xc5bf, 0xc5c0, 0xc5c1, 0xc5c2,
	0xc5c3, 0xc5c4, 0xc5c5, 0xc5c6, 0xc5c7, 0xc5c8, 0xc5c9, 0xc5ca,
	0xc5cb, 0xc5cc, 0xc5cd, 0xc5ce, 0xc5cf, 0xc5d0, 0xc5d1, 0xc5d2,
	0xc5d3, 0xc5d4, 0xc5d5, 0xc5d6, 0xc5d7, 0xc5d8, 0xc5d9, 0xc5da,
	0xc5db, 0xc5dc, 0xc5dd, 0xc5de, 0xc5df, 0xc5e0, 0xc5e1, 0xc5e2,
	0xc5e3, 0xc5e4, 0xc5e5, 0xc5e6, 0xc5e7, 0xc5e8, 0xc5e9, 0xc5ea,
	0xc5eb, 0xc5ec, 0xc5ed, 0xc5ee, 0xc5ef, 0xc5f0, 0xc5f1, 0xc5f2,
	0xc5f3, 0xc5f4, 0xc5f5, 0xc5f6, 0xc5f7, 0xc5f8, 0xc5f9, 0xc5fa,
	0xc5fb, 0xc5fc, 0xc5fd, 0xc5fe, 0xc6a1, 0xc6a2, 0xc6a3, 0xc6a4,
	0xc6a5, 0xc6a6, 0xc6a7, 0xc6a8, 0xc6a9, 0xc6aa, 0xc6ab, 0xc6ac,
	0xc6ad, 0xc6ae, 0xc6af, 0xc6b0, 0xc6b1, 0xc6b2, 0xc6b3, 0xc6b4,
	0xc6b5, 0xc6b6, 0xc6b7, 0xc6b8, 0xc6b9, 0xc6ba, 0xc6bb, 0xc6bc,
	0xc6bd, 0xc6be, 0xc6bf, 0xc6c0, 0xc6c1, 0xc6c2, 0xc6c3, 0xc6c4,
	0xc6c5, 0xc6c6, 0xc6c7, 0xc6c8, 0xc6c9, 0xc6ca, 0xc6cb, 0xc6cc,
	0xc6cd, 0xc6ce, 0xc6cf, 0xc6d0, 0xc6d1, 0xc6d2, 0xc6d3, 0xc6d4,
	0xc6d5, 0xc6d6, 0xc6d7, 0xc6d8, 0xc6d9, 0xc6da, 0xc6db, 0xc6dc,
	0xc6dd, 0xc6de, 0xc6df, 0xc6e0, 0xc6e1, 0xc6e2, 0xc6e3, 0xc6e4,
	0xc6e5, 0xc6e6, 0xc6e7, 0xc6e8, 0xc6e9, 0xc6ea, 0xc6eb, 0xc6ec,
	0xc6ed, 0xc6ee, 0xc6ef, 0xc6f0, 0xc6f1, 0xc6f2, 0xc6f3, 0xc6f4,
	0xc6f5, 0xc6f6, 0xc6f7, 0xc6f8, 0xc6f9, 0xc6fa, 0xc6fb, 0xc6fc,
	0xc6fd, 0xc6fe, 0xc7a1, 0xc7a2, 0xc7a3, 0xc7a4, 0xc7a5, 0xc7a6,
	0xc7a7, 0xc7a8, 0xc7a9, 0xc7aa, 0xc7ab, 0xc7ac, 0xc7ad, 0xc7ae,
	0xc7af, 0xc7b0, 0xc7b1, 0xc7b2, 0xc7b3, 0xc7b4, 0xc7b5, 0xc7b6,
	0xc7b7, 0xc7b8, 0xc7b9, 0xc7ba, 0xc7bb, 0xc7bc, 0xc7bd, 0xc7be,
	0xc7bf, 0xc7c0, 0xc7c1, 0xc7c2, 0xc7c3, 0xc7c4, 0xc7c5, 0xc7c6,
	0xc7c7, 0xc7c8, 0xc7c9, 0xc7ca, 0xc7cb, 0xc7cc, 0xc7cd, 0xc7ce,
	0xc7cf, 0xc7d0, 0xc7d1, 0xc7d2, 0xc7d3, 0xc7d4, 0xc7d5, 0xc7d6,
	0xc7d7, 0xc7d8, 0xc7d9, 0xc7da, 0xc7db, 0xc7dc, 0xc7dd, 0xc7de,
	0xc7df, 0xc7e0, 0xc7e1, 0xc7e2, 0xc7e3, 0xc7e4, 0xc7e5, 0xc7e6,
	0xc7e7, 0xc7e8, 0xc7e9, 0xc7ea, 0xc7eb, 0xc7ec, 0xc7ed, 0xc7ee,
	0xc7ef, 0xc7f0, 0xc7f1, 0xc7f2, 0xc7f3, 0xc7f4, 0xc7f5, 0xc7f6,
	0xc7f7, 0xc7f8, 0xc7f9, 0xc7fa, 0xc7fb, 0xc7fc, 0xc7fd, 0xc7fe,
	0xc8a1, 0xc8a2, 0xc8a3, 0xc8a4, 0xc8a5, 0xc8a6, 0xc8a7, 0xc8a8,
	0xc8a9, 0xc8aa, 0xc8ab, 0xc8ac, 0xc8ad, 0xc8ae, 0xc8af, 0xc8b0,
	0xc8b1, 0xc8b2, 0xc8b3, 0xc8b4, 0xc8b5, 0xc8b6, 0xc8b7, 0xc8b8,
	0xc8b9, 0xc8ba, 0xc8bb, 0xc8bc, 0xc8bd, 0xc8be, 0xc8bf, 0xc8c0,
	0xc8c1, 0xc8c2, 0xc8c3, 0xc8c4, 0xc8c5, 0xc8c6, 0xc8c7, 0xc8c8,
	0xc8c9, 0xc8ca, 0xc8cb, 0xc8cc, 0xc8cd, 0xc8ce, 0xc8cf, 0xc8d0,
	0xc8d1, 0xc8d2, 0xc8d3, 0xc8d4, 0xc8d5, 0xc8d6, 0xc8d7, 0xc8d8,
	0xc8d9, 0xc8da, 0xc8db, 0xc8dc, 0xc8dd, 0xc8de, 0xc8df, 0xc8e0,
	0xc8e1, 0xc8e2, 0xc8e3, 0xc8e4, 0xc8e5, 0xc8e6, 0xc8e7, 0xc8e8,
	0xc8e9, 0xc8ea, 0xc8eb, 0xc8ec, 0xc8ed, 0xc8ee, 0xc8ef, 0xc8f0,
	0xc8f1, 0xc8f2, 0xc8f3, 0xc8f4, 0xc8f5, 0xc8f6, 0xc8f7, 0xc8f8,
	0xc8f9, 0xc8fa, 0xc8fb, 0xc8fc, 0xc8fd, 0xc8fe
};

