/*
 * Copyright (C) 2000 Bang Jun-Young
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THE AUTHOR ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION,
 * AND DISCLAIM ANY LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER
 * RESULTING FROM THE USE OF THIS SOFTWARE.
 */

#define UNI_HANGUL_FIRST 	0xac00
#define UNI_HANGUL_LAST		0xd7a3

extern const unsigned short utf16_ksc5601_table[2350];

int
utf16_to_ksc5601(int ch)
{
	/* Use binary search to search for a match. */

	int left = 0, middle, right = 2349;

	if (ch < UNI_HANGUL_FIRST || ch > UNI_HANGUL_LAST)
		/* Out of range. */
		return 0;

	while (left <= right) {
		middle = (left + right) >> 1;	/* For speed; (>>1)==(/2) */
		if (ch > utf16_ksc5601_table[middle])
			left = middle + 1;
		else if (ch < utf16_ksc5601_table[middle])
			right = middle + 1;
		else
			/* We've found it! */
			return utf16_ksc5601_table[middle];
	}

	/* Not found a match. */
	return 0;	
}

