/* -- updatedd: error.h --
 *
 * Copyright (c) 2002, 2003 Philipp Benner <philipp@philippb.tk>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * The GNU C Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with the GNU C Library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307 USA.
 */

#include <stdarg.h>

extern int std_err(int mode, const char *msg, ...);
extern void log_err(int mode, const char *msg, ...);
extern int vstd_err(int mode, const char *msg, va_list az);
extern void vlog_err(int mode, const char *msg, va_list az);

/* do exit(EXIT_FAILURE); */

#define EXIT		(1<<5)

/* error_type */

#define PERR		(1<<3)
#define HERR		(2<<3)

/*
 * priorities/facilities are encoded into a single 32-bit quantity, where the
 * bottom 3 bits are the priority (0-7) and the top 28 bits are the facility
 * (0-big number).  Both the priorities and the facilities map roughly
 * one-to-one to strings in the syslogd(8) source code.  This mapping is
 * included in this file.
 *
 * priorities (these are ordered)
 */

#define	EMERG		0	/* system is unusable				*/
#define	ALERT		1	/* action must be taken immediately		*/
#define	CRIT		2	/* critical conditions				*/
#define	ERROR		3	/* error conditions				*/
#define	WARNING		4	/* warning conditions				*/
#define	NOTICE		5	/* normal but significant condition		*/
#define	INFO		6	/* informational				*/
#define	DEBUGINFO	7	/* debug-level messages				*/
