#!/usr/bin/perl -w

sub print_plugins($);

print "\nUpdatedd Plugins Configuration\n\n";
my $make_file = "src/plugins/plugins.make";
my $conf_file = ".plugins.conf";
my @buffer;
my @table;

open(INPUT, $conf_file) or die "cannot open $conf_file\n";
while(<INPUT>) {
	chomp;
	push @buffer, $_;
}
close(INPUT) or die "cannot close $conf_file\n";

for($i = 0; $buffer[$i]; $i++) {
	my ($service, $url, $status) = split /[ \t\n',']{1,}/, $buffer[$i];
	$ptr = [$service, $url, $status];
	push @table, $ptr;
}
print_plugins(STDOUT);

print "\nTo change the status (on/off) of a plugin, \n" .
      "type the plugin name. You can specify more than one\n" .
      "plugin by seperating each with a space.\n" .
      "To finish the plugins configuration just press enter.\n";

print "\ninput: ";
while (<>) {

	last if $_ eq "\n";

	chomp;
	@input = split /[ \t',']{1,}/;

	for($i = 0; $input[$i]; $i++) {

		SEARCH: for($n = 0; $table[$n]; $n++) {

			if( $input[$i] =~ /^$table[$n][0]$/i ) {

				if( $table[$n][2] eq "on" ) {
					$table[$n][2] = "off";
				}
				elsif( $table[$n][2] eq "off" ) {
					$table[$n][2] = "on";
				}
				last SEARCH;
			}
		}
	}
	print_plugins(STDOUT);
	print "\ninput: ";

}

print "\nWhich plugin should be the default one?\n";

my $default = -1;
for($default = $i = 0; $table[$i]; $i++) {
	if($table[$i][2] eq "on") {
		$default = $i;
		last;
	}
}
if($default == -1) {
	print "you don't want to use any plugin?\n";
	exit 1;
}
print "[$table[$default][0]]: ";

INPUT_DEFAULT: while(<>) {

	last INPUT_DEFAULT if /^[\n]{1}?/;

	for($i = 0; $table[$i]; $i++) {
		if( $_ =~ /^$table[$i][0]$/i && $table[$i][2] =~ /^on$/ ) {
			$default = $i;
			last INPUT_DEFAULT;
		}
	}
	print "[$table[$default][0]]: ";
}

#
# Write configuration to config files
#

open(CONF_FILE, ">$conf_file")
	or die "Could not open $conf_file!\n";
print_plugins(CONF_FILE);
close(CONF_FILE) or die "cannot close $conf_file\n";

open(MAKE_FILE, ">$make_file")
	or die "Could not open $make_file!\n";
printf(MAKE_FILE "LIB_FILES =");
for($i = 0; $table[$i]; $i++) {
	if( $table[$i][2] eq "on" ) {
		printf(MAKE_FILE " $table[$i][0].o");
	}
}
printf(MAKE_FILE "\nDEFAULT_PLUGIN = $table[$default][0]\n");
close(MAKE_FILE) or die "cannot close $make_file\n";

print "Done\n";

#
# subroutines
#

sub print_plugins($) {

	my $file = shift;

	for($i = 0; $table[$i]; $i++) {
		printf($file "%-10s %-15s %-3s\n",
		    $table[$i][0], $table[$i][1], $table[$i][2]);
	}

}
