#!/bin/bash

CONF_FILE=.plugins.conf
TMP_FILE=/tmp/plugins_conf
MAKEFILE=src/plugins/plugins.make
MYPATH="/bin /sbin /usr/bin /usr/sbin /usr/local/bin /usr/local/sbin"

#
# check for dialog
#
for dir in $MYPATH; do
	if [ -x $dir/dialog ]; then
		DIALOG=$dir/dialog
	fi
done

if [ -z $DIALOG ]; then
	echo "dialog seems not to be installed"
	exit 1
fi

#
# select plugins which should be compiled
#
buffer=( $(cat $CONF_FILE) )
$DIALOG --clear --shadow --checklist "Updatedd Plugins Configuration" 15 40 10 ${buffer[*]} 2>$TMP_FILE
if [ $? != 0 ]; then
	exit 1
fi
active_plugins=( `cat $TMP_FILE` )
rm -f $TMP_FILE

index=${#buffer[@]}-1
count=0
while [ $index != "-1" ]; do

	buffer[$index]="off"
	for i in ${active_plugins[*]}; do
		if [ $i == \"${buffer[$index-2]}\" ]; then
			buffer[$index]="on"
			let "count++"
		fi
	done

	let "index -= 3"

done

if [ $count == 0 ]; then
	$DIALOG --clear --shadow --msgbox "You have to select at least one plugin!" 5 45
	exit 1
fi

#
# default plugin selection
#
index=${#buffer[@]}
count=0
while [ $index != $count ]; do

	if [ ${buffer[$count+2]} == "on" ]; then
		plugin_selection[$count]=${buffer[$count]}
		plugin_selection[$count+1]=${buffer[$count+1]}
	fi

	let "count += 3"

done

$DIALOG --clear --shadow --menu "Default Plugin Selection" 15 40 10 ${plugin_selection[*]} 2>$TMP_FILE
if [ $? != 0 ]; then
	exit 1
fi
default_plugin=`cat $TMP_FILE`
rm -f $TMP_FILE

#
# write configuration to config file
#
rm -f $CONF_FILE
count=0
while [ $index != $count ]; do

	printf "%-10s %-15s %-3s\n" ${buffer[$count]} ${buffer[count+1]} ${buffer[count+2]} >> $CONF_FILE
	let "count += 3"

done

#
# write configuration to make file
#
count=0
echo -n "LIB_FILES =" > $MAKEFILE
while [ $index != $count ]; do

	if [ ${buffer[$count+2]} = "on" ]; then
		echo -n " ${buffer[$count]}.o" >> $MAKEFILE
	fi
	let "count += 3"

done

echo >> $MAKEFILE
echo "DEFAULT_PLUGIN = $default_plugin" >> $MAKEFILE

exit 0
