/* -- updatedd: updatedd.c --
 *
 * Copyright (c) 2002, 2003 Philipp Benner <philipp@philippb.tk>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * The GNU C Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with the GNU C Library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307 USA.
 *
 */

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <dlfcn.h>
#include <sys/types.h>
#include <dirent.h>
#include <error.h>
#include <version.h>

#define MAXLIBS		10
#define MAXDATA		256

#ifndef __linux__
# define LIB_FUNC	"_dyndns"
#else
# define LIB_FUNC	"dyndns"
#endif

typedef void (*fptr)(int, char**);

fptr load_library(char *modul);
char * get_service(int argc, char *argv[], char *service[]);

char *
  savestring(char *old_string)
{
	char *string;
	int len;

	if(strlen(old_string) >= MAXDATA)
		std_err(ERROR | EXIT, "%s: service name is too long", old_string);

	len = strlen(old_string) + 1;
	if((string = (char *)malloc(len * sizeof(char))) == NULL)
		std_err(ERROR | EXIT | PERR, "malloc() failed");
	(void)memset(string, 0, len);
	(void)strcpy(string, old_string);

	return string;
}

void
  list_services(char *service[])
{

	struct dirent *dir_info;
	DIR *dir;
	int c;

	for(c=0; c < MAXLIBS; c++)
		service[c] = NULL;

	if((dir = opendir(LIBPATH)) == NULL)
		std_err(ERROR | EXIT, "no such file or directory: %s",
			LIBPATH);
	for(c=0; (dir_info = readdir(dir)) != NULL;) {
		for(; strstr(dir_info->d_name, ".so") && c < MAXLIBS; c++) {
		/* cut ".so" and save the module name */
			dir_info->d_name[strlen(dir_info->d_name) - 3] = '\0';
			service[c] = savestring(dir_info->d_name);
		}
	}

}

int
  main(int argc, char *argv[])
{

	char *lib, *service[MAXLIBS], *default_lib = NULL;
	fptr dyndns;
	int c;

	list_services(service);

	for(c=0; service[c] != NULL; c++) {
		if(strcmp(service[c], "default") == 0)
			default_lib = service[c];
	}
	if(default_lib == NULL)
		std_err(ERROR | EXIT, "no default service");

	if((lib = get_service(argc, argv, service)) == NULL)
		lib = default_lib;

	dyndns = load_library(lib);
	for(c=0; service[c]; c++)
		free(service[c]);
	(*dyndns)(argc, argv);

	return 0;

}

char *
  get_service(int argc, char *argv[], char *service[])
{

	int c, i;

	for(c = 1; c < argc; c++) {

		if(strcmp(argv[c], "-L") == 0 ||
		   strcmp(argv[c], "--list-services") == 0)
			{

				(void)printf("\n\t \033[0;32;1m  Services\033[0m\n\t|\n");
				for(c=0; service[c]; c++)
					(void)printf("\t|  %s\n", service[c]);
				(void)printf("\n");
				exit(EXIT_SUCCESS);
			}
	}

	for(c = 1; c < argc; c++) {

		if(strcmp(argv[c], "-S") == 0 ||
		   strcmp(argv[c], "--service") == 0)
			{
				if((c+=1) >= argc)
					return NULL;
				for(i=0; service[i] != NULL; i++) {
					if(strcmp(argv[c], service[i]) == 0)
						return service[i];
				}
			}
	}

	return NULL;

}

fptr
  load_library(char *lib)
{

	const char *c_error;
	void *handle;
	void *function;
	char path[256];

	(void)memset(path, 0, sizeof(path));
	(void)snprintf(path, sizeof(path)-1, "%s/%s.so", LIBPATH, lib);

	if((handle = dlopen(path, RTLD_LAZY)) == NULL)
		std_err(ERROR | EXIT, "%s: could not open library", path);

	function = dlsym(handle, LIB_FUNC);
	if((c_error = dlerror()) != NULL)
		std_err(ERROR | EXIT, "%s: %s", c_error, path);

	return (fptr)function;

}
