#!/usr/local/bin/perl
# Display a form for replying to or composing an email

require './mailbox-lib.pl';

&ReadParse();
&set_module_index($in{'folder'});
@folders = &list_folders();
$folder = $folders[$in{'folder'}];
if ($in{'new'}) {
	# Composing a new email
	$html_edit = 1 if ($userconfig{'html_edit'} == 2);
	$sig = &get_signature();
	if ($html_edit) {
		$sig =~ s/\n/<br>\n/g;
		$quote = "<html><body>$sig</body></html>";
		}
	else {
		$quote = "\n\n$sig" if ($sig);
		}
	$to = $in{'to'};
	&mail_page_header($text{'compose_title'},
			  undef,
			  $html_edit ? "onload='initEditor()'" : "");
	}
else {
	# Replying or forwarding
	if ($in{'mailforward'} ne '') {
		# Forwarding multiple .. get the messages
		@mailforwardboth = split(/\0/, $in{'mailforward'});
		@fwdmail = &messages_from_indexes($folder, \@mailforwardboth);
		@fwdmail || &error($text{'reply_efwdnone'});
		$mail = $fwdmail[0];
		}
	else {
		# Replying or forwarding one .. get it
		@mail = &mailbox_list_mails_sorted(
				$in{'idx'}, $in{'idx'}, $folder, 0, undef);
		$mail = &find_message_by_index(\@mail, $folder, $in{'idx'}, $in{'mid'});
		$mail || &error($text{'view_egone'});
		&decode_and_sub();
		}
	$viewlink = "view_mail.cgi?idx=$in{'idx'}&folder=$in{'folder'}&mid=".
		    &urlize($in{'mid'});
	$mail || &error($text{'mail_eexists'});

	if ($in{'delete'}) {
		# Just delete the email
		if (!$in{'confirm'} && &need_delete_warn($folder)) {
			# Need to ask for confirmation before deleting
			&mail_page_header($text{'confirm_title'});
			print &check_clicks_function();

			print "<form action=reply_mail.cgi>\n";
			foreach $i (keys %in) {
				foreach $v (split(/\0/, $in{$i})) {
					print &ui_hidden($i, $v),"\n";
					}
				}
			print "<center><b>$text{'confirm_warn3'}<br>\n";
			if ($userconfig{'delete_warn'} ne 'y') {
				print "$text{'confirm_warn2'}<p>\n"
				}
			elsif ($folder->{'type'} == 0) {
				print "$text{'confirm_warn4'}<p>\n"
				}
			print "</b><p><input type=submit name=confirm ",
			      "value='$text{'confirm_ok'}' ",
			      "onClick='return check_clicks(form)'></center></form>\n";
			
			&mail_page_footer(
				$viewlink,
				$text{'view_return'},
				"index.cgi?folder=$in{'folder'}",
				$text{'index'});
			exit;
			}
		&lock_folder($folder);
		&mailbox_delete_mail($folder, $mail);
		&unlock_folder($folder);
		&pop3_logout_all();
		&redirect_to_previous();
		exit;
		}
	elsif ($in{'print'}) {
		# Extract the mail body
		($textbody, $htmlbody, $body) =
			&find_body($mail, $userconfig{'view_html'});

		# Output HTML header
		&PrintHeader();
		print "<html><head>\n";
		print "<title>",&html_escape(&decode_mimewords(
			$mail->{'header'}->{'subject'})),"</title></head>\n";
		print "<body bgcolor=#ffffff onLoad='window.print()'>\n";

		# Display the headers
		print "<table width=100% border=1>\n";
		print "<tr $tb> <td><b>$text{'view_headers'}</b></td> </tr>\n";
		print "<tr $cb> <td><table width=100%>\n";
		print "<tr> <td><b>$text{'mail_from'}</b></td> ",
		      "<td>",&eucconv_and_escape($mail->{'header'}->{'from'}),"</td> </tr>\n";
		print "<tr> <td><b>$text{'mail_to'}</b></td> ",
		      "<td>",&eucconv_and_escape($mail->{'header'}->{'to'}),"</td> </tr>\n";
		print "<tr> <td><b>$text{'mail_cc'}</b></td> ",
		      "<td>",&eucconv_and_escape($mail->{'header'}->{'cc'}),"</td> </tr>\n"
			if ($mail->{'header'}->{'cc'});
		print "<tr> <td><b>$text{'mail_date'}</b></td> ",
		      "<td>",&eucconv_and_escape(&html_escape($mail->{'header'}->{'date'})),
		      "</td> </tr>\n";
		print "<tr> <td><b>$text{'mail_subject'}</b></td> ",
		      "<td>",&eucconv_and_escape(&decode_mimewords(
			$mail->{'header'}->{'subject'})),"</td> </tr>\n";
		print "</table></td></tr></table><p>\n";

		# Just display the mail body for printing
		if ($body eq $textbody) {
			print "<table border width=100%><tr $cb><td><pre>";
			foreach $l (&wrap_lines($body->{'data'},
						$userconfig{'wrap_width'})) {
				print &eucconv_and_escape($l),"\n";
				}
			print "</pre></td></tr></table>\n";
			}
		elsif ($body eq $htmlbody) {
			print "<table border width=100%><tr><td>\n";
			print &safe_html($body->{'data'});
			print "</td></tr></table>\n";
			}

		print "</body></html>\n";
		exit;
		}
	elsif ($in{'mark1'} || $in{'mark2'}) {
		# Just mark the message
		&open_read_hash();
		$mode = $in{'mark1'} ? $in{'mode1'} : $in{'mode2'};
		if ($mode) {
			$read{$mail->{'header'}->{'message-id'}} = $mode;
			}
		else {
			delete($read{$mail->{'header'}->{'message-id'}});
			}
		&redirect_to_previous();
		exit;
		}
	elsif ($in{'move1'} || $in{'move2'}) {
		# Move to another folder
		&error_setup($text{'reply_errm'});
		$mfolder = $folders[$in{'move1'} ? $in{'mfolder1'} : $in{'mfolder2'}];
		$mfolder->{'noadd'} && &error($text{'delete_enoadd'});
		&lock_folder($folder);
		&lock_folder($mfolder);
		&mailbox_move_mail($folder, $mfolder, $mail);
		&unlock_folder($mfolder);
		&unlock_folder($folder);
		&redirect_to_previous();
		exit;
		}
	elsif ($in{'copy1'} || $in{'copy2'}) {
		# Copy to another folder
		&error_setup($text{'reply_errc'});
		$mfolder = $folders[$in{'copy1'} ? $in{'mfolder1'} : $in{'mfolder2'}];
		$qerr = &would_exceed_quota($mfolder, $mail);
		&error($qerr) if ($qerr);
		&lock_folder($folder);
		&lock_folder($mfolder);
		&mailbox_copy_mail($folder, $mfolder, $mail);
		&unlock_folder($mfolder);
		&unlock_folder($folder);
		&redirect_to_previous();
		exit;
		}
	elsif ($in{'detach'} && $config{'server_attach'} == 2) {
		# Detach some attachment to a directory on the server
		&error_setup($text{'detach_err'});
		$in{'dir'} || &error($text{'detach_edir'});
		$in{'dir'} = "$remote_user_info[7]/$in{'dir'}"
			if ($in{'dir'} !~ /^\//);

		if ($in{'attach'} eq '*') {
			# Detaching all attachments (except the body and any
			# signature) under their filenames
			@dattach = grep { $_->{'idx'} ne $in{'bindex'} &&
					  $_->{'header'}->{'content-type'} !~
					  	/^multipart\//i }
					@{$mail->{'attach'}};
			if (defined($in{'sindex'})) {
				@dattach = grep { $_->{'idx'} ne $in{'sindex'} }
						@dattach;
				}
			}
		else {
			# Just one attachment
			@dattach = ( $mail->{'attach'}->[$in{'attach'}] );
			}

		local @paths;
		foreach $attach (@dattach) {
			local $path;
			if (-d $in{'dir'}) {
				# Just write to the filename in the directory
				local $fn;
				if ($attach->{'filename'}) {
					$fn = &decode_mimewords(
						$attach->{'filename'});
					$fn =~ s/^.*[\/\\]//;
					}
				else {
					$attach->{'type'} =~ /\/(\S+)$/;
					$fn = "file.$1";
					}
				$path = "$in{'dir'}/$fn";
				}
			else {
				# Assume a full path was given
				$path = $in{'dir'};
				}
			push(@paths, $path);
			}

		for($i=0; $i<@dattach; $i++) {
			# Try to write the files
			open(FILE, ">$paths[$i]") ||
				&error(&text('detach_eopen',
					     "<tt>$paths[$i]</tt>", $!));
			(print FILE $dattach[$i]->{'data'}) ||
				&error(&text('detach_ewrite',
					     "<tt>$paths[$i]</tt>", $!));
			close(FILE) ||
				&error(&text('detach_ewrite',
					     "<tt>$paths[$i]</tt>", $!));
			}

		# Show a message about the new files
		&mail_page_header($text{'detach_title'});

		for($i=0; $i<@dattach; $i++) {
			local $sz = (int(length($dattach[$i]->{'data'}) /
					 1000)+1)." Kb";
			print "<p>",&text('detach_ok',
					  "<tt>$paths[$i]</tt>", $sz),"<p>\n";
			}

		&mail_page_footer(
			$viewlink, $text{'view_return'},
			"index.cgi?folder=$in{'folder'}", $text{'mail_return'});
		exit;
		}
	elsif ($in{'black'} || $in{'white'}) {
		# Add sender to SpamAssassin black/write list, and tell user
		$mode = $in{'black'} ? "black" : "white";
		&mail_page_header($text{$mode.'_title'});

		&foreign_require("spam", "spam-lib.pl");
		local $conf = &spam::get_config();
		local @from = map { @{$_->{'words'}} }
			    	  &spam::find($mode."list_from", $conf);
		local %already = map { $_, 1 } @from;
		local ($spamfrom) = &address_parts($mail->{'header'}->{'from'});
		if ($already{$spamfrom}) {
			print &text($mode.'_already',
					  "<tt>$spamfrom</tt>"),"</b><p>\n";
			}
		else {
			push(@from, $spamfrom);
			&spam::save_directives($conf, $mode.'list_from',
					       \@from, 1);
			&flush_file_lines();
			print &text($mode.'_done',
					  "<tt>$spamfrom</tt>"),"</b><p>\n";
			}

		&mail_page_footer(
			$viewlink, $text{'view_return'},
			"index.cgi?folder=$in{'folder'}", $text{'mail_return'});
		exit;
		}
	elsif ($in{'razor'} || $in{'ham'}) {
		# Report message to Razor as spam/ham and tell user
		$mode = $in{'razor'} ? "razor" : "ham";
		&mail_page_header($text{$mode.'_title'});

		print "<b>",$text{$mode.'_report'},"</b>\n";
		print "<pre>";
		local $temp = &transname();
		&send_mail($mail, $temp, 0, 1);
		local $cmd = $mode eq "razor" ? &spam_report_cmd() 
					      : &ham_report_cmd();
		open(OUT, "$cmd <$temp 2>&1 |");
		local $error;
		while(<OUT>) {
			print &html_escape($_);
			$error++ if (/failed/i);
			}
		close(OUT);
		unlink($temp);
		print "</pre>\n";
		$deleted = 0;
		if ($? || $error) {
			print "<b>",$text{'razor_err'},"</b><p>\n";
			}
		else {
			if ($userconfig{'spam_del'} && $mode eq "razor") {
				# Delete message too
				&lock_folder($folder);
				&mailbox_delete_mail($folder, $mail);
				&unlock_folder($folder);
				print "<b>$text{'razor_deleted'}</b><p>\n";
				$deleted = 1;
				}
			else {
				print "<b>",$text{'razor_done'},"</b><p>\n";
				}
			}

		&mail_page_footer(
			$deleted ? ( ) : 
			( $viewlink, $text{'view_return'} ),
			"index.cgi?folder=$in{'folder'}", $text{'mail_return'});
		exit;
		}
	elsif ($in{'dsn'}) {
		# Send DSN to sender
		dbmopen(%dsn, "$user_module_config_directory/dsn", 0600);
		$dsnaddr = &send_delivery_notification($mail, undef, 1);
		if ($dsnaddr) {
			$mid = $mail->{'header'}->{'message-id'};
                        $dsn{$mid} = time()." ".$dsnaddr;
                        }
		dbmclose(%dsn);
		&redirect_to_previous();
		exit;
		}

	if (!@fwdmail) {
		&parse_mail($mail);
		&decrypt_attachments($mail);
		@attach = @{$mail->{'attach'}};
		}


	if ($in{'enew'}) {
		# Editing an existing message, so keep same fields
		$to = $mail->{'header'}->{'to'};
		$rto = $mail->{'header'}->{'reply-to'};
		$from = $mail->{'header'}->{'from'};
		$cc = $mail->{'header'}->{'cc'};
		$ouser = $1 if ($from =~ /^(\S+)\@/);
		}
	else {
		if (!$in{'forward'} && !@fwdmail) {
			# Replying to a message, so set To: field
			$to = $mail->{'header'}->{'reply-to'};
			$to = $mail->{'header'}->{'from'} if (!$to);
			}
		if ($in{'rall'}) {
			# If replying to all, add any addresses in the original
			# To: or Cc: to our new Cc: address.
			$cc = $mail->{'header'}->{'to'};
			$cc .= ", ".$mail->{'header'}->{'cc'}
				if ($mail->{'header'}->{'cc'});
			}
		}

	# Work out new subject, depending on whether we are replying
	# our forwarding a message (or neither)
	local $qu = !$in{'enew'} &&
		    (!$in{'forward'} || !$userconfig{'fwd_mode'});
	$subject = &html_escape(&decode_mimewords(
				$mail->{'header'}->{'subject'}));
	$subject = "Re: ".$subject if ($subject !~ /^Re/i && !$in{'forward'} &&
				       !@fwdmail && !$in{'enew'});
	$subject = "Fwd: ".$subject if ($subject !~ /^Fwd/i &&
					($in{'forward'} || @fwdmail));

	# Construct the initial mail text
	$sig = &get_signature();
	($quote, $html_edit, $body) = &quoted_message($mail, $qu, $sig,
						      $in{'body'});
	if ($in{'forward'} || $in{'enew'}) {
		@attach = grep { $_ ne $body } @attach;
		}
	else {
		undef(@attach);
		}

	&mail_page_header(
		$in{'forward'} || @fwdmail ? $text{'forward_title'} :
		$in{'enew'} ? $text{'enew_title'} :
			      $text{'reply_title'},
		undef,
		$html_edit ? "onload='initEditor()'" : "");
	}

print "<form action=send_mail.cgi method=post enctype=multipart/form-data>\n";

# Output various hidden fields
print "<input type=hidden name=ouser value='$ouser'>\n";
print "<input type=hidden name=idx value='$in{'idx'}'>\n";
print "<input type=hidden name=mid value='$in{'mid'}'>\n";
print "<input type=hidden name=folder value='$in{'folder'}'>\n";
print "<input type=hidden name=new value='$in{'new'}'>\n";
print "<input type=hidden name=enew value='$in{'enew'}'>\n";
foreach $s (@sub) {
	print "<input type=hidden name=sub value='$s'>\n";
	}
if ($in{'reply'}) {
	print "<input type=hidden name=rid value='".
		&html_escape($mail->{'header'}->{'message-id'})."'>\n";
	}

print "<table width=100% border=1>\n";
print "<tr> <td $tb><b>$text{'reply_headers'}</b></td> </tr>\n";
print "<tr> <td $cb><table width=100%>\n";
print "<tr> <td><b>$text{'mail_from'}</b></td>\n";
if ($from) {
	# Got From address
	@froms = ( $from );
	}
else {
	# Work out From: address
	local ($froms, $doms) = &list_from_addresses();
	@froms = @$froms;
	}

@faddrs = grep { $_->[3] } &list_addresses();
($defaddr) = grep { $_->[3] == 2 } @faddrs;
if ($folder->{'fromaddr'}) {
	# Folder has a specified From: address
	($defaddr) = &split_addresses($folder->{'fromaddr'});
	}
if ($config{'edit_from'} == 1) {
	# User can enter any from address he wants
	if ($defaddr) {
		# Address book contains a default from address
		$froms[0] = $defaddr->[1] ? "\"$defaddr->[1]\" <$defaddr->[0]>"
					  : $defaddr->[0];
		}
	print "<td nowrap><input name=from size=40 style='width:90%' value='",
		&html_escape($froms[0]),"'>&nbsp;",
		@faddrs ? &address_button("from", 0, 1) : "","</td>\n";
	}
elsif ($config{'edit_from'} == 2) {
	# Only the real name and username part is editable
	local ($real, $user, $dom);
	local ($sp) = $defaddr || &split_addresses($froms[0]);
	$real = $sp->[1];
	if ($sp->[0] =~ /^(\S+)\@(\S+)$/) {
		$user = $1; $dom = $2;
		}
	else {
		$user = $sp->[0];
		}
	print "<td><input name=real size=15 value='".&html_escape($real)."'>\n";
	print "&lt;<input name=user size=10 value='$user'>\@";
	if (@$doms > 1) {
		print "<select name=dom>\n";
		foreach $d (@$doms) {
			print "<option>$d\n";
			}
		print "</select>&gt;\n";
		}
	else {
		print "$dom&gt;\n";
		print "<input type=hidden name=dom value='$dom'>\n";
		}
	print &address_button("user", 0, 2, "real") if (@faddrs);
	print "</td>\n";
	}
else {
	# A fixed From address, or a choice of fixed options
	if (@froms > 1) {
		print "<td><select name=from>\n";
		foreach $f (@froms) {
			printf "<option>%s\n", &html_escape($f);
			}
		print "</select></td>\n";
		}
	else {
		print "<td><tt>",&html_escape($froms[0]),"</tt></td>\n";
		print "<input type=hidden name=from value='",
		      &html_escape($froms[0]),"'></td>\n";
		}
	}
$to = &html_escape($to);
if ($userconfig{'reply_to'} ne 'x') {
	# Show Reply-To: and To: fields
	$rto = &html_escape($userconfig{'reply_to'})
		if ($userconfig{'reply_to'} ne '*');
	print "<td><b>$text{'mail_replyto'}</b></td> <td nowrap>",
	      "<input name=replyto size=40 value=\"$rto\" style='width:90%'> ",
	      @faddrs ? &address_button("replyto", 0, 1) : "","</td> </tr>\n";

	print "<td><b>$text{'mail_to'}</b></td> <td colspan=3 nowrap>",
	      "<input name=to size=70 value=\"$to\" style='width:90%'> ",
	      &address_button("to"),"</td> </tr>\n";
	}
else {
	# Just show To: field
	print "<td><b>$text{'mail_to'}</b></td> <td nowrap>",
	      "<input name=to size=40 value=\"$to\" style='width:90%'> ",
	      &address_button("to"),"</td> </tr>\n";
	}
$cc = &html_escape($cc);
print "<tr> <td><b>$text{'mail_cc'}</b></td> <td nowrap>",
      "<input name=cc size=40 value=\"$cc\" style='width:90%'> ",
      &address_button("cc"),"</td>\n";
print "<td><b>$text{'mail_bcc'}</b></td> <td nowrap>",
      "<input name=bcc size=40 value='$userconfig{'bcc_to'}' style='width:90%'> ",
      &address_button("bcc"),"</td> </tr>\n";
print "<tr> <td><b>$text{'mail_subject'}</b></td> <td nowrap>",
      "<input name=subject size=40 value=\"$subject\" style='width:90%'></td>\n";
print "<td><b>$text{'mail_pri'}</b></td> ",
      "<td><table cellpadding=0 cellspacing=0 width=100%>\n",
      "<tr><td align=left><select name=pri>\n",
      "<option value=1>$text{'mail_highest'}\n",
      "<option value=2>$text{'mail_high'}\n",
      "<option value='' selected>$text{'mail_normal'}\n",
      "<option value=4>$text{'mail_low'}\n",
      "<option value=5>$text{'mail_lowest'}\n",
      "</select></td>\n",
      "<td align=right><input type=submit value=\"$text{'reply_send'}\">\n",
      "&nbsp;&nbsp;",
      "<input type=submit name=draft value=\"$text{'reply_draft'}\"></td>\n",
      "</tr></table></td></tr>\n";

# Ask for signing and encryption
if (&has_command("gpg") && &foreign_check("gnupg")) {
	&foreign_require("gnupg", "gnupg-lib.pl");
	local @keys = &foreign_call("gnupg", "list_keys");
	if (@keys) {
		print "<tr> <td colspan=2><b>$text{'mail_sign'}</b>\n";
		print "<select name=sign>\n";
		print "<option selected value=''>$text{'mail_nosign'}\n";
		foreach $k (@keys) {
			next if (!$k->{'secret'});
			local $n = $k->{'name'}->[0];
			$n = substr($n, 0, 40)."..." if (length($n) > 40);
			printf "<option value=%d>%s\n",
				$k->{'index'}, &html_escape($n);
			}
		print "</select></td>\n";

		print "<td colspan=2><b>$text{'mail_crypt'}</b>\n";
		print "<select name=crypt>\n";
		print "<option selected value=''> $text{'mail_nocrypt'}\n";
		print "<option value=-1> $text{'mail_samecrypt'}\n";
		foreach $k (@keys) {
			local $n = $k->{'name'}->[0];
			$n = substr($n, 0, 40)."..." if (length($n) > 40);
			printf "<option value=%d>%s\n",
				$k->{'index'}, &html_escape($n);
			}
		print "</select></td> </tr>\n";
		}
	}

print "<tr>\n";
if ($userconfig{'req_dsn'} == 2) {
	# Ask for a disposition (read) status
	print "<td colspan=2>\n";
	print "<b>$text{'reply_dsn'}</b>\n";
	print &ui_radio("dsn", 0, [ [ 1, $text{'yes'} ],
				    [ 0, $text{'no'} ] ]);
	print "</td>\n";
	}

if ($userconfig{'req_del'} == 2) {
	# Ask for a delivery status
	print "<td colspan=2>\n";
	print "<b>$text{'reply_del'}</b>\n";
	print &ui_radio("del", 0, [ [ 1, $text{'yes'} ],
				    [ 0, $text{'no'} ] ]);
	print "</td>\n";
	}
print "</tr>\n";

# Ask if should add to address book
print "<tr>\n";
print "<td colspan=2>\n";
print "<b>$text{'reply_aboot'}</b>\n";
print &ui_radio("abook", $userconfig{'add_abook'},
		[ [ 1, $text{'yes'} ], [ 0, $text{'no'} ] ]);
print "</td>\n";
print "</tr>\n";

print "</table></td></tr></table><p>\n";

# Output message body input
print "<table width=100% border=1>\n",
      "<tr $tb> <td><b>$text{'reply_body'}</b></td> </tr>",
      "<tr $cb> <td>";
if ($html_edit) {
	# Output HTML editor textarea
	print <<EOF;
<script type="text/javascript">
  _editor_url = "/$module_name/htmlarea/";
  _editor_lang = "en";
</script>
<script type="text/javascript" src="htmlarea/htmlarea.js"></script>

<script type="text/javascript">
var editor = null;
function initEditor() {
  editor = new HTMLArea("body");
  editor.generate();
  return false;
}
</script>
EOF
	print "<textarea rows=20 cols=80 style='width:100%' name=body id=body>",
	      &html_escape($quote),"</textarea>\n";
	}
else {
	# Show text editing area
	print "<textarea rows=20 cols=80 style='width:100%' name=body $config{'wrap_mode'}>",
	      &html_escape($quote),"</textarea>\n";
	}
if (&has_command("ispell") && !$userconfig{'nospell'}) {
	print "<br>\n";
	print &ui_checkbox("spell", 1, $text{'reply_spell'},
			   $userconfig{'spell_check'}),"\n";
	}
print "</td></tr></table><p>\n";
print "<input type=hidden name=html_edit value='$html_edit'>\n";

# Display forwarded attachments
if (@attach) {
	print "<table width=100% border=1>\n";
	print "<tr> <td $tb><b>$text{'reply_attach'}</b></td> </tr>\n";
	print "<tr> <td $cb>\n";
	foreach $a (@attach) {
		push(@titles, "<input type=checkbox name=forward value=$a->{'idx'} checked> ".($a->{'filename'} ? $a->{'filename'} : $a->{'type'}));
		push(@links, "detach.cgi?idx=$in{'idx'}&mid=".&urlize($in{'mid'})."&folder=$in{'folder'}&attach=$a->{'idx'}$subs");
		push(@icons, "images/boxes.gif");
		}
	&icons_table(\@links, \@titles, \@icons, 8);
	print "</td></tr></table><p>\n";
	}

# Display forwarded mails
if (@fwdmail) {
	print "<table width=100% border=1>\n";
	print "<tr> <td $tb><b>$text{'reply_mailforward'}</b></td> </tr>\n";
	print "<tr> <td $cb>\n";
	foreach $f (@fwdmail) {
		push(@titles, &simplify_subject($f->{'header'}->{'subject'}));
		push(@links, "view_mail.cgi?idx=$f->{'sortidx'}&folder=$in{'folder'}&mid=".&urlize($f->{'header'}->{'message-id'}));
		push(@icons, "images/boxes.gif");
		print &ui_hidden("mailforward",
			 "$f->{'sortidx'}/$f->{'header'}->{'message-id'}");
		}
	&icons_table(\@links, \@titles, \@icons, 8);
	print "</td></tr></table><p>\n";
	}

# Add form for more attachments
print "<table width=100% border=1>\n";
print "<tr $tb> <td colspan=3><b>$text{'reply_attach2'}</b></td> </tr>\n";

print "<tr $cb> <td><input type=file size=20 name=attach0></td>\n";
print "<td><input type=file size=20 name=attach1></td>\n";
print "<td><input type=file size=20 name=attach2></td> </tr>\n";

print "<tr $cb> <td><input type=file size=20 name=attach3></td>\n";
print "<td><input type=file size=20 name=attach4></td>\n";
print "<td><input type=file size=20 name=attach5></td> </tr>\n";

if ($config{'server_attach'}) {
	print "<tr $cb> <td><input name=file0 size=20> ",
		&file_chooser_button("file0"),"</td>\n";
	print "<td><input name=file1 size=20> ",
		&file_chooser_button("file1"),"</td>\n";
	print "<td><input name=file2 size=20> ",
		&file_chooser_button("file2"),"</td> </tr>\n";
	}

print "</table><p>\n";
print "<input type=submit value=\"$text{'reply_send'}\">&nbsp;&nbsp;\n";
print "<input type=submit name=draft value=\"$text{'reply_draft'}\"><br>\n";
print "</form>\n";

&mail_page_footer("index.cgi?folder=$in{'folder'}", $text{'mail_return'});
&pop3_logout_all();

sub decode_and_sub
{
return if (!$mail);
&notes_decode($mail, $folder);
&parse_mail($mail);
@sub = split(/\0/, $in{'sub'});
$subs = join("", map { "&sub=$_" } @sub);
foreach $s (@sub) {
	# We are looking at a mail within a mail ..
	&decrypt_attachments($mail);
	local $amail = &extract_mail(
			$mail->{'attach'}->[$s]->{'data'});
	&parse_mail($amail);
	$mail = $amail;
	}
($deccode, $decmessage) = &decrypt_attachments($mail);
}

sub redirect_to_previous
{
local $perpage = $folder->{'perpage'} || $userconfig{'perpage'};
local $s = int($in{'idx'} / $perpage) * $perpage;
if ($userconfig{'open_mode'}) {
	&redirect($viewlink);
	}
else {
	&redirect("index.cgi?folder=$in{'folder'}&start=$s");
	}
}

