
/* these are the only formats commonly supported by hardware,
 * but we could add more if needed, including different byte
 * swaps, non-linear depth buffers, and memory tiled buffers.
 *
 * We make no pretense at supporting color index rendering.
 */
typedef enum {
	CB_15BIT,
	CB_16BIT,
	CB_32BIT_BGRA
} cbFormat_t;

typedef enum {
	DB_16BIT,
	DB_32BIT,
	DB_24BIT_SB_8BIT	// the stencil buffer is in the LOW ORDER bits
} dbFormat_t;

#define PACKCOLOR555(r,g,b,a) \
  ((((r) & 0xf8) << 7) | (((g) & 0xf8) << 2) | (((b) & 0xf8) >> 3) | \
    ((a) ? 0x8000 : 0))

#define PACKCOLOR565(r,g,b) \
  ((((r) & 0xf8) << 8) | (((g) & 0xfc) << 3) | (((b) & 0xf8) >> 3))

#define PACKCOLOR888(r,g,b) \
  (((r) << 16) | ((g) << 8) | (b))

#define PACKCOLOR8888(r,g,b,a) \
  (((a) << 24) | ((r) << 16) | ((g) << 8) | (b))

#define PACKCOLOR4444(r,g,b,a) \
  ((((a) & 0xf0) << 8) | (((r) & 0xf0) << 4) | ((g) & 0xf0) | ((b) >> 4))

/*
 * This sets all the buffer access functions in ctx->Driver
 * so that Mesa can perform software rendering into the given
 * buffers.  This is needed for fallbacks (anti-aliased lines,
 * etc) in all cases, and for primary rendering when in a 
 * virtual memory buffer.
 *
 * hwFinish is a function pointer to a routine that will wait
 * until all hardware rendering is completed, allowing the cpu
 * to safely read buffer contents.
 *
 * This is per-context, so contexts with different
 * color or depth bits can coexist.
 * This should be called every time a buffer is bound, because
 * the same context can be bound to different depth buffers at
 * different times.
 *
 * pitch is in PIXELS, not bytes
 */
void SetDriverBufferFunctions( GLcontext *ctx, void (*hwFinish)(void),
	GLubyte *colorBuffer, int colorPitch, int colorHeight, cbFormat_t colorFormat,
	GLubyte *depthBuffer, int depthPitch, int depthHeight, dbFormat_t depthFormat );
	
/*
 * Mesa doesn't handle buffer clears automatically through the span functions
 */
GLbitfield FallbackBufferClear( GLcontext *ctx, GLbitfield mask, GLboolean all,
		     GLint x, GLint y, GLint width, GLint height ); 

/*
 * This will clear and set all ctx->Driver values for a software only
 * rendering.  Must be followed by a call to SetDriverBufferFunctions.
 */
void SetSoftwareDriverFunctions( GLcontext *ctx );

/*
 * SUGGESTIONS FOR NEW STRUCTURE, NOT IMPLEMENTED!
 *
 * Now that we have a couple driver's worth of hindsight and there is talk of
 * supporting additional chipsets, I think it is important to take a clear look
 * at exactly what we are asking of the drivers, and look at ways of minimizing
 * code and required duties of the drivers.
 *
 * The old serverglx code has been largely bypassed because it suffered from
 * a few flaws: no support for hardware syncing, no hardware front buffer
 * rendering, no support for deeper depth, no support for non-linear buffer
 * arrangements, extranious support for pixmaps, poor definitions of ordering
 * and guarantees, etc
 *
 * Drivers should have minimal interaction with the X server.  Some interaction
 * is needed in the hardware init functions, but it shouldn't be needed
 * anywhere else.  This will make the drivers much easier to move to other
 * environments, like a raw fbdev, GGI, or DRI mesa environment.
 *
 * Common code is responsible for all mesa context creations / deletions /
 * bindings.  The hardware drivers are completely optional to the common code,
 * which can deal with pure software rendering all by itself.
 *
 *
hwFuncs_t *[Mga|Mach64|I810|S3Virge]Init( void *directRenderingData );
 * Driver and hardware initialization.  If this is the X server,
 * directRenderingData will be NULL, otherwise it will be driver-private data
 * generated by the X server in (*BeginDirectRendering)().
 *
 * Returns a static structure of function pointers to the other driver
 * functions.
 *
 * If the proper X server symbols aren't present, or the hardware isn't the
 * correct type, NULL will be returned.
 *
 * Multiple linked drivers will be called in sequence until one returns
 * a valid set of driver pointers.
 *
 * I think this is an improvement over having all the symbol checking code
 * in common code as it currently is.  The common code will only need a
 * list of driver init functions, not any logic to determine which should
 * be called, or which symbols need to be looked for.
 *  
 * Creates all visuals by calling back into UtahGLXCreateVisual() as many
 * times as needed.  The driver is responsible for creating all visuals,
 * including ones with any desired software buffers, like stencil and
 * accumulation.
 *
 * If no drivers initialize, the common code will set up its own set of
 * visuals and provide software rendering.
 *
 *
void (*HWShutdown)( void )
 * Called when the X server or direct rendering client shuts down.  Should
 * release any AGP/MTRR/mapped files/etc so that a direct client can expect
 * to start back up again on the same client process.
 *   
hwBuffer_t *(*CreateBuffer)( int width, int height, const GLvisual *visual );
 * At buffer creation time, the driver has an oportunity to attempt to allocate
 * hardware buffers.  If it fails, it takes no other action and the system
 * handles allocating software buffers.
 *
 * A buffer will be software-only if its required buffers (color and depth)
 * cannot be allocated in hardware working space.  We allow the stencil buffer
 * to be software with a hardware depth and color, because we can fall to
 * software rendering whenver GL_STENCIL is enabled.  We do not support
 * software alpha buffers, because there is no simple enable to check for all
 * uses.
 * 
 * If the GLX_NOHW flag is set, common code takes care of everything without
 * invoking the driver at all.
 *
 * Common code will take care of automatically noticing changes in window
 * size at the time of DisplayBuffer and calling unbind/destroy/create/bind,
 * unlike the current approach of checking during driver glViewport calls.
 *
void (*DestroyBuffer)( hwBuffer_t *buf );
 * The driver buffer destruction code is only called for valid hardware
 * buffers. It is guaranteed to not be the currently bound buffer. 
 *
void (*BindContext)( GLcontext *ctx, hwBuffer_t *buf );
 * At context / buffer binding time, common code can check to see if the new
 * buffer is software-only, and handle it without any driver interaction.
 *
 * If a given context becomes software only, it will stay software only with no
 * interaction with the hardware driver until it is bound to a different
 * buffer.
 *
 * For hardware buffers, the driver sets up its mesa driver pointers and does a
 * complete hardware state initialization for the context.
 * 
 * Drivers will want to call the common SetDriverBufferFunctions() to get all
 * the common span rendering functions needed for software fallbacks, like
 * anti aliased line drawing.  The common FallbackBufferClear function will
 * take care of any software buffers during clearing.
 *
 * The only way any of a driver's mesa DD functions will be entered is if the
 * most recent bind was to a hardware buffer.  There is no need to do any
 * validity checking.  
 *
 * Unlike the old glx, this will only be called if it differs from the current
 * condition.
 *
 * BindContext( NULL, NULL ) will be called before destroying either ctx or
 * buf, or before the common code binds to a software buffer.  If a driver had
 * to mess with the api function pointers directly, it must change them back
 * at that point.
 *
 * Common code will issue a glFlush() before this call if there is a current
 * bind, guaranteeing any hardware rendering will complete and faked front
 * buffer rendering will be displayed, even if it is switching to a software
 * buffer.
 *
 * Common code will issue a gl_make_current() to mesa after this call returns.
 *
 * Therre is no explicit (*CreateContext)( GLcontext *ctx ) call to allow a
 * hardware driver to cache context specific hardware data.  BindContext could
 * create private structures and delete them in DestroyContextHardwareData,
 * but I have come to the conclusion that there really isn't much benefit to
 * context hardware data.
 * 
 * Register values should NOT be cached in the context.  Basically, anything
 * that is stored in a context is a bug waiting to happen when a buffer
 * switches between software and hardware buffers.  Register values can be
 * cached in the driver struct, but they must be completely updated on each
 * context bind.  The cost is so low (we do it on EVERY state update on mach64)
 * that there isn't any win to keep them cached in a context structure and
 * only invalidate with DestroyContextHardwareData().
 *
 * Note that textures WILL have their own private driver data struct, and
 * must be watched for in DestroyContextHardwareData().
 *
 * The current mga driver changes a couple variables directly in the mesa
 * context, like ctx->NrPipelineStages and ctx->TriangleCaps.  Mesa's design
 * should probably be changed so that a driver never changes anything outside
 * the Driver struct. 
 *
void (*DestroyContextHardwareData)( GLcontext *ctx );
 * If a context that was hardware accelerated is about to be destroyed or bound
 * to a software buffer, all maintained hardware state must be purged, because
 * the driver will not be given any more update notices.
 * 
 * It is possible for textures to become stale if a context is bound to a
 * software buffer and texsubimage calls are made while hardware textures
 * exist.
 *
 * In the future, when mesa supports driver-only copies of textures, this will
 * be where the textures are copied back down to virtual memory.
 *
 * If a hardware driver has messed with any mesa context values, like pipeline
 * stages, it must put them back to default mesa values here.  Can we have
 * common code take care of this somehow?
 *
void (*DisplayBuffer)( hwBuffer_t *buf, int numBoxes, box_t *boxes );
 * Is guaranteed to only happen when buf is currently bound.  This is almost
 * never going to be a true "swap buffers", so I thought it better to change
 * the name.
 * 
 * The interaction with the X server's clip boxes is handled by common code,
 * so the driver doesn't need to know anything about windows. 
 *
GLboolean (*BeginDirectRendering)( void **directRenderingData, 
	int *dataLength )
 * The X server will receive this when a client requests to begin direct
 * rendering.
 *
 * Common code will have already rejected the attempt if there is another
 * direct client already running.
 * 
 * Any existing indirect rendering contexts will be forced to software buffers
 * before entering this call.  They can continue to run, and new contexts can
 * be created, but they will remain software only.
 *
 * If direct rendering is allowed, the driver-private data will be sent to the
 * client, where it will be passed to [Mga|Mach64|I810|S3Virge]Init().
 *
 * directRenderingData will be freed by the common code.
 *
void (*DirectRenderingData)( void *clientData, int numBoxes, box_t *boxes,
	void **responseData, int *responseLength );
 * The X server instance of the driver receives this call when the client
 * instance calls UtahGLXSendDirectData() with it's driver-private data.
 * This should contain information about the current dma buffer and enough
 * information about the current hwBuffer_t to allow the driver to fake up
 * a call to DisplayBuffer if desired.
 *
 * numBoxes and boxes are provided by the common code on every call, but some
 * DirectRenderingData calls will just be buffer flushes, and will ignore it.
 *
 * The common code will return responseData to the client, then free it.
 *
 * The server will NOT have any active context or buffer, as everything is
 * being done on the client's side.  
 *
void (*EndDirectRendering)( void );
 * If the driver had to give up any hardware priviledges to allow direct
 * rendering, it should reaquire them now.  All hardware state is undefined.
 */
 
 /*
 
 drivers need a common call to force a DisplayBuffer for FB rendering.
 
 vertex buffers will be flushed before DisplayBuffer by infrastructure
 */
