/*
 * GLX Hardware Device Driver for Intel 810
 * Copyright (C) 1999 Keith Whitwell
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * KEITH WHITWELL, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR 
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 *    Keith Whitwell <keithw@precisioninsight.com>
 *
 * based on matrox driver by
 *    Wittawat Yamwong <Wittawat.Yamwong@stud.uni-hannover.de>
 * and others.
 */

/* $Id: i810buf.h,v 1.1 1999/12/13 12:47:44 keithw Exp $ */

#ifndef I810BUF_INC
#define I810BUF_INC

#include "i810common.h"
#include "i810_3d_reg.h"
#include "types.h"
#include "mm.h"

#define VALID_I810_BUFFER(b) (b)


struct i810_dest_buffer 
{
   int refcount;
   PMemBlock MemBlock;
   GLuint Setup[I810_DEST_SETUP_SIZE];

   int Format;
   int Width;			/* in pixels */
   int Height; 
   int Pitch;  
   int BytesPerPixel;
   int Size;
   int Drawable;
   char *BufAddr;
   struct i810_z_buffer *ZBuffer;
};

struct i810_z_buffer 
{
   int refcount;
   PMemBlock MemBlock;

   int Format;
   char *BufAddr;

   int Pitch;
};



/* Don't bother trying to hide the differences between these types of
 * buffer.
 */
struct i810_dest_buffer *i810CreateDestBuffer(int Format, 
					      int Width, 
					      int Height);
void i810DestroyDestBuffer(struct i810_dest_buffer *buf);



/* Parent is a dest-buffer, supplies geometry info.
 */
struct i810_z_buffer *i810CreateZBuffer( struct i810_dest_buffer *parent );
void i810FreeZBuffer(struct i810_z_buffer *buf);





#endif
