
#include "mach64glx.h"
#include "fog.h"	// for the fog coord pipeline stage

/*

Optimized fastpaths and compiled vertex arrays (CVA) can be set
up here, but we only need to make one small tweak to enable fog
coordinates to be set up the way we want them.

*/

GLuint mach64DDRegisterPipelineStages( struct gl_pipeline_stage *out,
				    const struct gl_pipeline_stage *in,
				    GLuint nr )
{
   GLuint i, o;

   for (i = o = 0 ; i < nr ; i++) {
      switch (in[i].ops) {
	 /* Completely replace Mesa's fog processing to generate fog
	  * coordinates instead of messing with colors.
	  */
      case PIPE_OP_FOG:
      	/* not that ctx->TriangleCaps |= DD_CLIP_FOG_COORD; also must be set */
	 out[o] = gl_fog_coord_stage;
	 o++;
	 break;
      default:
	 out[o++] = in[i];
	 break;
      }
   }

   return o;
}


