C:::::      ,,,,,COMBGN..
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine COMBGN(nproc,myproc,ntids,tids,exenam,err)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COMBGN   is the initialization routine for interprocessor  ***
C**      communication (e.g.  mapping of the logical process        ***
C**      numbering to the physical process(or) numbering)           ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
      integer           nproc,myproc,ntids,tids(ntids),err
      character*(*)     exenam
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   LIST OF FORMAL PARAMETERS :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C NAME   I TYPE I I/O I     MEANING
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C nproc  I  I   I o   I number of processors (or processes)
C--------I------I-----I------------------------------------------------
C myproc I  I   I out I logical own process(or) number
C--------I------I-----I------------------------------------------------
C tids   I  I   I out I all physical process(or) numbers
C--------I------I-----I------------------------------------------------
C ntids  I  I   I in  I dimension of array tids          
C--------I------I-----I------------------------------------------------
C exenam I  S   I --  I Dummy-string
C--------I------I-----I------------------------------------------------
C err    I  I   I out I error number
C        I      I     I =0     : no error
C        I      I     I =10301 : ntids is lower than nproc
C        I      I     I <> 0   : error code of the parallel system
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                                                                 ***
      include   'mpif.h'
      integer   i,rank
C**                                                                 ***
C**                                                                 ***
C**** START OF CALCULATION :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      err=0
C**                                                                 ***
C**   MPI:                                                          ***
C**                                                                 ***
      call MPI_INIT(err)
      call MPI_COMM_RANK(MPI_COMM_WORLD,rank,err)
      call MPI_COMM_SIZE(MPI_COMM_WORLD,nproc,err)

      myproc = rank + 1

      if (nproc .le. 0 .or. nproc .gt. ntids) then
        err = 10301
        print *,' The array <tids> is too small dimensioned or'
        print *,' the parameter nproc is set to a value < 1'
        goto 999
      endif

      do 100 i=1,nproc 
        tids(i) = i-1
  100 continue

C**
C**** END OF CALCULATION
C**   ------------------
C**
 999  r e t u r n
C-----END OF COMBGN---------------------------------------------------
      e    n    d
