c***********************************************************************
c        1         2         3         4         5         6         7 *
c***********************************************************************
c**                                                                  ***
c**                                                                  ***
      subroutine LINOUT(l,MAT,lmat,index,lindex,lsym,info,ia1,nvt,
     &                  ilin,unit,ierr)
c**                                                                  ***
c**                                                                  ***
c***********************************************************************
c**                                                                  ***
c**    L I N O U T   saves a matrix in LINSOL-format                 ***
c**                                                                  ***
c***********************************************************************
c**                                                                  ***
c**    Copyright Universitaet Karlsruhe, 1996                        ***
c**    Programmer : H. Haefner                                       ***
c**                                                                  ***
c***********************************************************************
c**                                                                  ***
       implicit none
c**                                                                  *** 
c***********************************************************************
c**                                                                  ***
c**    formal parameters :                                           ***
c**                                                                  ***
c***********************************************************************
       include 'const.h'
       integer l,lmat,lindex,nvt,ia1,unit,ierr
       integer info(ia1,ia2),index(lindex),ilin(nilin)
       double precision MAT(lmat)
       logical lsym
c***********************************************************************
c**                                                                  ***
c**    list of formal parameters :                                   ***
c**                                                                  ***
c**                                                                  ***
c---------I------I-----I------------------------------------------------
c name    I type I i/o I meaning
c---------I------I-----I------------------------------------------------
c l       I int  I in  I dimension of the matrix
c---------I------I-----I------------------------------------------------
c lmat    I int  I in  I number of nonzero elements
c---------I------I-----I------------------------------------------------
c lindex  I int  I in  I number of indices
c---------I------I-----I------------------------------------------------
c nvt     I int  I in  I total number of vector-terms
c---------I------I-----I------------------------------------------------
c ia1     I int  I in  I 1.dimension of info-array
c---------I------I-----I------------------------------------------------
c ia2     I int  I in  I 2.dimension of info-array
c---------I------I-----I------------------------------------------------
c info    I int  I in  I array with matrix-structure-information
c---------I------I-----I------------------------------------------------
c index   I int  I in  I array with indices
c---------I------I-----I------------------------------------------------
c MAT     I real I in  I array with nonzero matrix-elements
c---------I------I-----I------------------------------------------------
c lsym    I l    I in  I indicates if matrix is symmetrical
c---------I------I-----I------------------------------------------------
c lout    I int  I in  I standard output unit 
c---------I------I-----I------------------------------------------------
c unit    I int  I in  I i/o-unit to write to
c---------I------I-----I------------------------------------------------
c ierr    I int  I out I error-indication
c---------I------I-----I------------------------------------------------
c**                                                                  ***
c**                                                                  ***
c**    local variables :                                             ***
c**                                                                  ***
       integer nvecs(ntyp),i,j,lout
c**                                                                  ***
c**                                                                  ***
c***********************************************************************
c**    start of calculation                                          ***
c***********************************************************************
c**                                                                  
       write(unit,*) lmat,lindex,l,lsym,nvt
c**
c**    calculate the number of each storage-typ
c**
       do 1 i=1,ntyp
         nvecs(i)=0
1      continue
       do 2 i=1,nvt
	 if (info(i,1) .eq. 1 .or. info(i,1) .eq. 10)
     &     nvecs(1)=nvecs(1)+1
	 if (info(i,1) .eq. 2 .or. info(i,1) .eq. 20)
     &     nvecs(2)=nvecs(2)+1
	 if (info(i,1) .eq. 3 .or. info(i,1) .eq. 30)
     &     nvecs(3)=nvecs(3)+1
	 if (info(i,1) .eq. 4 .or. info(i,1) .eq. 40)
     &     nvecs(4)=nvecs(4)+1
	 if (info(i,1) .eq. 5 .or. info(i,1) .eq. 50)
     &     nvecs(5)=nvecs(5)+1
	 if (info(i,1) .eq. 6 .or. info(i,1) .eq. 60)
     &     nvecs(6)=nvecs(6)+1
	 if (info(i,1) .eq. 7 .or. info(i,1) .eq. 70)
     &     nvecs(7)=nvecs(7)+1
	 if (info(i,1) .eq. 8 .or. info(i,1) .eq. 80)
     &     nvecs(8)=nvecs(8)+1
	 if (info(i,1) .eq. 9 .or. info(i,1) .eq. 90)
     &     nvecs(9)=nvecs(9)+1
	 if (info(i,1) .eq. 11 .or. info(i,1) .eq. 100)
     &     nvecs(11)=nvecs(11)+1
2      continue

       lout = ilin(12)
       do 3 i=1,9
         if (ilin(13) .gt. 0) then
           if (ilin(17) .eq. 1) write(lout,1000) nvecs(i),i
         endif
         if (ilin(13) .lt. 0) then
           write(lout,1000) nvecs(i),i
         endif
3      continue
       if (ilin(13) .gt. 0) then
         if (ilin(17) .eq. 1) write(lout,1000) nvecs(ntyp),ntyp
       endif
       if (ilin(13) .lt. 0) then
         write(lout,1000) nvecs(ntyp),ntyp
       endif
c**
c**    write main-diagonal if storage-typ used
c**
       do 10 i=1,nvt
         if (info(i,1) .eq. 1 .or. info(i,1) .eq. 10) then   
           write(unit,*) 1,1
           write(unit,*) (MAT(info(i,2)+j), j=1,l)
         endif
10     continue
c**
c**    write diagonals if storage-typ used
c**
       if (nvecs(2).gt.0) then
         write(unit,*) 2,nvecs(2)
         do 20 i=1,nvt
           if (info(i,1) .eq. 2 .or. info(i,1) .eq. 20) then
             write(unit,*) info(i,3),info(i,4),info(i,5)
             write(unit,*) (MAT(info(i,2)+j), j=1,info(i,3))
           endif
20       continue
       endif
c**
c**    write packed-diagonals if storage-typ used
c**
       if (nvecs(3).gt.0) then
         write(unit,*) 3,nvecs(3)
         do 30 i=1,nvt
           if (info(i,1) .eq. 3 .or. info(i,1) .eq. 30) then
             write(unit,*) info(i,3),info(i,4),info(i,5)
             write(unit,*) (index(info(i,6)+j), j=1,info(i,3))
             write(unit,*) (MAT(info(i,2)+j), j=1,info(i,3))
           endif
30       continue
       endif
c**
c**    write row-format if storage-typ used
c**
       if (nvecs(4).gt.0) then
         write(unit,*) 4,nvecs(4)
         do 40 i=1,nvt
           if (info(i,1) .eq. 4 .or. info(i,1) .eq. 40) then
             write(unit,*) info(i,3),info(i,4),info(i,5)
             write(unit,*) (index(info(i,6)+j), j=1,info(i,3))
             write(unit,*) (MAT(info(i,2)+j), j=1,info(i,3))
           endif
40       continue
       endif
c**
c**    write column-format if storage-typ used
c**
       if (nvecs(5).gt.0) then
         write(unit,*) 5,nvecs(5)
         do 50 i=1,nvt
           if (info(i,1) .eq. 5 .or. info(i,1) .eq. 50) then
             write(unit,*) info(i,3),info(i,4),info(i,5)
             write(unit,*) (index(info(i,7)+j), j=1,info(i,3))
             write(unit,*) (MAT(info(i,2)+j), j=1,info(i,3))
           endif
50       continue
       endif
c**
c**    write sky-format if storage-typ used
c**
       if (nvecs(6).gt.0) then
         write(unit,*) 6,nvecs(6)
         do 60 i=1,nvt
           if (info(i,1) .eq. 6 .or. info(i,1) .eq. 60) then
             write(unit,*) info(i,3)
             write(unit,*) (index(info(i,6)+j), j=1,info(i,3))
             write(unit,*) (index(info(i,7)+j), j=1,info(i,3))
             write(unit,*) (MAT(info(i,2)+j), j=1,info(i,3))
           endif
60       continue
       endif
c**
c**    write full-row-format if storage-typ used
c**
       if (nvecs(7).gt.0) then
         write(unit,*) 7,nvecs(7)
         do 70 i=1,nvt
           if (info(i,1) .eq. 7 .or. info(i,1) .eq. 70) then
             write(unit,*) info(i,3),info(i,4),info(i,5)
             write(unit,*) (MAT(info(i,2)+j), j=1,info(i,3))
           endif
70       continue
       endif
c**
c**    write full-column-format if storage-typ used
c**
       if (nvecs(8).gt.0) then
         write(unit,*) 8,nvecs(8)
         do 80 i=1,nvt
           if (info(i,1) .eq. 8 .or. info(i,1) .eq. 80) then
             write(unit,*) info(i,3),info(i,4),info(i,5)
             write(unit,*) (MAT(info(i,2)+j), j=1,info(i,3))
           endif
80       continue
       endif
c**
c**    write packed row-format if storage-typ used
c**
       if (nvecs(9).gt.0) then
         write(unit,*) 9,nvecs(9)
         do 90 i=1,nvt
           if (info(i,1) .eq. 9 .or. info(i,1) .eq. 90) then
             write(unit,*) info(i,3),info(i,4),info(i,5)
             write(unit,*) (index(info(i,6)+j), j=1,info(i,3))
             write(unit,*) (MAT(info(i,2)+j), j=1,info(i,3))
           endif
90       continue
       endif
c**
c**    write packed column-format if storage-typ used
c**
       if (nvecs(11).gt.0) then
         write(unit,*) 11,nvecs(11)
         do 110 i=1,nvt
           if (info(i,1) .eq. 11 .or. info(i,1) .eq. 100) then
             write(unit,*) info(i,3),info(i,4),info(i,5)
             write(unit,*) (index(info(i,7)+j), j=1,info(i,3))
             write(unit,*) (MAT(info(i,2)+j), j=1,info(i,3))
           endif
110       continue
       endif

 1000 format('    - writing ',i6,'-times storage pattern ',i6)
      r e t u r n
C-----END OF LINOUT---------------------------------------------------
      e    n    d
