C:::::      ,,,,,MPIMAX.....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine MPIMAX(iwork,imax,l)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      M P I M A X   performs the computation of the local        ***
C**                    maximum norm.                                ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COPYRIGHT UNIVERSITAET KARLSRUHE, 1994                     ***
c**      PROGRAMMER:    H. Haefner                                  ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      include 'bytes.h'
      integer l
      integer iwork(l/iint),imax(l/iint)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   LIST OF FORMAL PARAMETERS :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C NAME   I TYPE I I/O I     MEANING
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C iwork  I  I   I in  I  work array with received maximum norms
C        I      I     I                            array: iwork(l/iint)
C--------I------I-----I------------------------------------------------
C imax   I  I   I i/o I  input : local maximum norms
C        I      I     I  output: computed maximum norms from local and
C        I      I     I          received norms     array: imax(l/iint)
C--------I------I-----I------------------------------------------------
C l      I  I   I in  I  length of the above mentioned arrays in Bytes
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                                                                 ***
C**        LOCAL PARAMETERS :                                       ***
C**        ----------------                                         ***
C**                                                                 ***
      integer i
C**                                                                 ***
C----------------------------------------------------------------------
C
C
C**** START OF CALCULATION :
C     ---------------------
C
      do 10 i=1,l/iint
        imax(i)=max(imax(i),iwork(i))
 10   continue
 
C
C**** END OF CALCULATION
C     ------------------
C
      r e t u r n
C-----END OF MPIMAX---------------------------------------------------
      e    n    d
