C:::::      ,,,,,MPSNDA...
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine  MPSNDA(totid,msgtyp,lmsg,msg,mid,err)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      MPSNDA asynchronous send of character*1 array msg          ***
C**             to the processes/or totid.                          ***
C**             msg may not be reused until the call of MPSNDW.     ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      integer           totid,msgtyp,lmsg,mid,err

      character*1       msg(lmsg)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   LIST OF FORMAL PARAMETERS :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C NAME   I TYPE I I/O I     MEANING
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C totid  I  I   I in  I  id of the target process
C--------I------I-----I------------------------------------------------
C msgtyp I  I   I in  I  message type
C--------I------I-----I------------------------------------------------
C lmsg   I  I   I in  I  length of the message (in bytes)
C--------I------I-----I------------------------------------------------
C msg    I  C*1 I in  I  the message                  array : msg(lmsg)
C--------I------I-----I------------------------------------------------
C mid    I  I   I out I  message id (has to be handed over to MPSNDW)
C--------I------I-----I------------------------------------------------
C err    I  I   I out I  error number
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      LOCAL PARAMETERS :                                         ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      integer           info
C
C
C**** START OF CALCULATION
C     --------------------
C
      err=0
      mid=0
C
C--------------------------------------------------------------------------
C     PVM - SYSTEM: 'data left in place', actually locally synchronous send
C
      call pvmfinitsend(0,info)
      call pvmfpack(1,msg,lmsg,1,info)
      call pvmfsend(totid,msgtyp,info)
      err=info
C
C--------------------------------------------------------------------------
C     TCGMSG: (actually locally synchronous send)
C
C     call snd(msgtyp,msg,lmsg,totid,1)
C
C--------------------------------------------------------------------------
C     NCUBE: (actually locally synchronous send)
C
C     info=nwrite(msg,lmsg,totid,msgtyp,info)
C     if (info.le.0) err=info
C
C
C
C**** END OF CALCULATION
C     ------------------
C
      r e t u r n
C-----END OF MPSNDA----------------------------------------------------
      e    n    d
