C:::::      ,,,,,COMBGN..
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine COMBGN(nproc,myproc,ntids,tids,exenod,err)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COMBGN   is the initialization routine for interprocessor  ***
C**      communication (e.g.  mapping of the logical process        ***
C**      numbering to the physical process(or) numbering)           ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
      integer           nproc,myproc,ntids,tids(ntids),err
      character*(*)     exenod
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   LIST OF FORMAL PARAMETERS :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C NAME   I TYPE I I/O I     MEANING
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C nproc  I  I   I i/o I number of processors (or processes)
C--------I------I-----I------------------------------------------------
C myproc I  I   I out I logical own process(or) number
C--------I------I-----I------------------------------------------------
C tids   I  I   I out I all physical process(or) numbers
C--------I------I-----I------------------------------------------------
C ntids  I  I   I in  I dimension of array tids          
C--------I------I-----I------------------------------------------------
C exenod I  S   I --  I Dummy-string
C--------I------I-----I------------------------------------------------
C err    I  I   I out I error number
C        I      I     I =0     : no error
C        I      I     I =10301 : ntids is lower than nproc
C        I      I     I <> 0   : error code of the parallel system
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                                                                 ***
      integer   mesh(0:15,0:15)
      integer   mynode,mytid,nproct,numnodes,getcol,getrow
      integer   i,j,k,nrow,ncol,x,y
C**                                                                 ***
C**                                                                 ***
C**** START OF CALCULATION :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      err=0
      ncol = 0
      nrow = 0
C**                                                                 ***
C**   NX/2:                                                         ***
C**                                                                 ***

      mytid  = mynode()
      nproct = numnodes()

      if (nproc .ne. nproct .and. nproc .gt. 0) then
        print *,' Warning: <nproc> is set to the systemvalue for'
        print *,'                  the number of processors!'
        nproc = nproct
      endif

      if (nproc .le. 0 .or. nproc .gt. ntids) then
        err = 10301
        print *,' The array <tids> is too small dimensioned or'
        print *,' the parameter nproc is set to a value < 1'
        goto 999
      endif

c     ncol = getcol()
c     nrow = getrow()
      if ((ncol .eq. 0) .or. (nrow .eq. 0)) then
        if (mytid .eq. 0) then
          print *,' '
          print *,' Environment-variable NUMROW or NUMCOL not set'
          print *,' Note: nearest neighbor ring is switched off  '
          print *,' '
        endif 
        do 5 i=1,nproc
          tids(i) = i-1
    5   continue
        goto 99
      endif
C**
C**
      x = 0
      y = 0
      mesh(x,y) = 1 
      i = 1
      tids(1) = 0
C**
      if (nproc .gt. 1) then
      if (mod(nrow,2) .eq. 0) then

   10   continue

C** downwards
        if ((mesh(x,y+1) .eq. 0) .and. (y .lt. nrow-1)) then
          y = y+1
          goto 20
        endif 
C** to the right
        if ((mesh(x+1,y) .eq. 0) .and. (x .lt. ncol-1)) then
          x = x+1
          goto 20
        endif 
C** to the left
        if ((mesh(x-1,y) .eq. 0) .and. (x .gt. 0)) then
          x = x-1
          goto 20
        endif 
C** upwards
        if ((mesh(x,y-1) .eq. 0) .and. (y .gt. 0)) then
          y = y-1
          goto 20
        endif 

        goto 99

   20   continue
        mesh(x,y) = 1 
        i = i+1
        tids(i) = ncol*y+x
        goto 10

      else

   30   continue

C** upwards
        if ((mesh(x,y-1) .eq. 0) .and. (y .gt. 0)) then
          y = y-1
          goto 40
        endif 
C** to the right
        if ((mesh(x+1,y) .eq. 0) .and. (x .lt. ncol-1)) then
          x = x+1
          goto 40
        endif 
C** downwards
        if ((mesh(x,y+1) .eq. 0) .and. (y .lt. nrow-1)) then
          y = y+1
          goto 40
        endif 
C** to the left
        if ((mesh(x-1,y) .eq. 0) .and. (x .gt. 0)) then
          x = x-1
          goto 40
        endif 

        goto 99

   40   continue
        mesh(x,y) = 1 
        i = i+1
        tids(i) = ncol*y+x
        goto 30

      endif
      endif
   
C**                                                                 ***
C**  GENERAL PART (for PVM and NX/2):                               ***
C**                                                                 ***
C**  find the own logical processor number                          ***
C**                                                                 ***

   99 continue
      do 100 i=1,nproc 
        if (tids(i) .eq. mytid) then
          myproc=i
        endif
  100 continue

C**
C**** END OF CALCULATION
C**   ------------------
C**
 999  r e t u r n
C-----END OF COMBGN---------------------------------------------------
      e    n    d
