C:::::      ,,,,,COMBGH...
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine COMBGH(nproc,tids,exenod,err)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COMBGH   starts <nproc> tasks on the node processors       ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
      integer           nproc,tids(nproc),err
      character*(*)     exenod
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   LIST OF FORMAL PARAMETERS :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C NAME   I TYPE I I/O I     MEANING
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C nproc  I  I   I i/o I number of processors (or processes)
C--------I------I-----I------------------------------------------------
C tids   I  I   I out I all physical process(or) numbers
C--------I------I-----I------------------------------------------------
C exenod I  I   I in  I name of the executable on the nodes with
C        I      I     I specification of the path
C--------I------I-----I------------------------------------------------
C err    I  I   I out I error number
C        I      I     I =0    : no error
C        I      I     I <> 0  : error code of the parallel system
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                                                                 ***
      integer       i,j,info,msgtyp,mytid,ntasks
      include 'fpvm3.h'
C**                                                                 ***
C**                                                                 ***
C**** START OF CALCULATION :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      err=0
C**
C**   get own task id
C**
      call pvmfmytid(mytid)
      print*,' The Message Passing Interface is PVM'
      print*,' Communication Setup on Host (COMBGH)'
      print*,' mytid (COMBGH)',mytid
      print*,' exenod (COMBGH)',exenod
C**
C**   spawn nproc tasks and send the parameter <nproc> and the array 
C**   <tids> to all spawned tasks
C**
      call pvmfspawn(exenod,PvmTaskDefault,'*',nproc,tids,ntasks)
      print *,' '
      print *,' COMBGH:',ntasks,' tasks spawned'
      if (ntasks .lt. 0) then 
        call pvmfperror(' COMBGH: pvmfspawn-error',info)
        call pvmfexit(info)
        goto 9999
      endif
c     print *,' COMBGH: with the task ids -',(tids(i),i=1,nproc)
      msgtyp=1
      call pvmfinitsend(0,err)
      if (err .lt. 0) then 
        call pvmfperror(' COMBGH: pvmfinitsend-error',info)
        call pvmfexit(info)
        goto 9999
      endif
      call pvmfpack(3,nproc,1,msgtyp,err)
      if (err .lt. 0) then 
        call pvmfperror(' COMBGH: pvmfpack-error',info)
        call pvmfexit(info)
        goto 9999
      endif
      call pvmfpack(3,tids(1),nproc,msgtyp,err)
      if (err .lt. 0) then 
        call pvmfperror(' COMBGH: pvmfpack-error',info)
        call pvmfexit(info)
        goto 9999
      endif
      call pvmfmcast(nproc,tids,msgtyp,err)
      if (err .lt. 0) then 
        call pvmfperror(' COMBGH: pvmfmcast-error',info)
        call pvmfexit(info)
        goto 9999
      endif
C**
C**
C**** END OF CALCULATION
C**   ------------------
C**
9999  r e t u r n
C-----END OF COMBGH----------------------------------------------------
      e    n    d
