C:::::      ,,,,,COMBGN..
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine COMBGN(nproc,myproc,ntids,tids,exenam,err)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COMBGN   is the initialization routine for interprocessor  ***
C**      communication (e.g.  mapping of the logical process        ***
C**      numbering to the physical process(or) numbering)           ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
      integer           nproc,myproc,ntids,tids(ntids),err
      character*(*)     exenam
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   LIST OF FORMAL PARAMETERS :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C NAME   I TYPE I I/O I     MEANING
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C nproc  I  I   I out I number of processors (or processes)
C--------I------I-----I------------------------------------------------
C myproc I  I   I out I logical own process(or) number
C--------I------I-----I------------------------------------------------
C tids   I  I   I out I all physical process(or) numbers
C--------I------I-----I------------------------------------------------
C ntids  I  I   I in  I dimension of array tids          
C--------I------I-----I------------------------------------------------
C exenam I  S   I in  I name of the executable on the nodes with 
C        I      I     I specification of the path
C--------I------I-----I------------------------------------------------
C err    I  I   I out I error number
C        I      I     I =0     : no error
C        I      I     I =10301 : ntids is lower than nproc
C        I      I     I <> 0   : error code of the parallel system
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                                                                 ***
      integer       bufid,info,mytid,mydtid,patid,msgtyp,ntsk,oldval
      integer       i,j,nhost,narch,dtid,speed
      character*30  pvmnam,arch
      include 'fpvm3.h'
C**                                                                 ***
C**                                                                 ***
C**** START OF CALCULATION :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      err=0
C**
C**   get the own task id and the master task id:
C**
      call pvmfmytid (mytid)
      call pvmfparent(patid)
C**
C**   get the task id list from the master - if there - else spawn 
C**   nproc-1 tasks
C**
        msgtyp=1
        print*,' The Message Passing Interface is PVM'
        print*,' Communication Setup on Node (COMBGN)'
        print*,' '
        if (patid .eq. PvmNoParent) then
 1111     tids(1)=mytid
	  call pvmftidtohost(mytid,mydtid)
	  call pvmfconfig(nhost,narch,dtid,pvmnam,arch,speed,err)
	  if (err .lt. 0) then
            print *,' !! PVMFCONFIG failed: probably SPAWNing  !!'
            print *,' !!      of following jobs does not work  !!'
          endif
	  j=2
          do 100 i=1,nhost
	    if (mydtid .ne. dtid) then
              call pvmfspawn(exenam,PvmTaskHost,pvmnam,1,tids(j),ntsk)
              print*,' COMBGN: Task ',exenam,' spawned on ',pvmnam 
              if (ntsk .lt. 0) then
                call pvmfperror(' COMBGN: pvmfspawn-error',info)
                call pvmfexit(info)
                goto 9999
              endif
	      j=j+1
            endif
            call pvmfconfig(nhost,narch,dtid,pvmnam,arch,speed,err)
	    if (err .lt. 0) then
              print *,' !! PVMFCONFIG failed: probably SPAWNing  !!'
              print *,' !!      of following jobs does not work  !!'
            endif
  100     continue
          print*,' COMBGN:  ',j-2,' tasks spawned'
	  nproc = j-1
          print*,'           --> number of processes is ',nproc
          print*,' '

          call pvmfinitsend(0,err)
          if (err .lt. 0) then
            call pvmfperror(' COMBGN: pvmfinitsend-error',info)
            call pvmfexit(info)
            goto 9999
          endif
          call pvmfpack(3,nproc,1,msgtyp,err)
          if (err .lt. 0) then
            call pvmfperror(' COMBGN: pvmfpack-error',info)
            call pvmfexit(info)
            goto 9999
          endif
          call pvmfpack(3,tids(1),nproc,msgtyp,err)
          if (err .lt. 0) then
            call pvmfperror(' COMBGN: pvmfpack-error',info)
            call pvmfexit(info)
            goto 9999
          endif
          call pvmfmcast(nproc-1,tids(2),msgtyp,err)
          if (err .lt. 0) then
            call pvmfperror(' COMBGN: pvmfmcast-error',info)
            call pvmfexit(info)
            goto 9999
          endif
        else
          call pvmftrecv(patid,msgtyp,3,0,bufid)
c         call pvmfrecv(patid,msgtyp,bufid)
          if (bufid .le. 0) then
            print *,' COMBGN: Spawning the application from XPVM'
            print *,' COMBGN: or PVM-console is assumed         '
            goto 1111
          endif
          call pvmfunpack(3,nproc,1,msgtyp,err)
          if (err .lt. 0) then
            call pvmfperror(' COMBGN: pvmfunpack-error',info)
            call pvmfexit(info)
            goto 9999
          endif
          if (nproc .gt. ntids) then
            err=10301
            print *,' The array <tids> is too small dimensioned'
            call pvmfexit(info)
            goto 9999
          endif
          call pvmfunpack(3,tids(1),nproc,msgtyp,err)
          if (err .lt. 0) then
            call pvmfperror(' COMBGN: pvmfunpack-error',info)
            call pvmfexit(info)
            goto 9999
          endif
        endif

C**                                                                 ***
C**  find the own logical processor number                          ***
C**                                                                 ***
      do 110 i=1,nproc 
        if (tids(i) .eq. mytid) then
          myproc=i
        endif
  110 continue

C**
C**** END OF CALCULATION
C**   ------------------
C**
 9999 r e t u r n
C-----END OF COMBGN---------------------------------------------------
      e    n    d
